/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.testframework.impl;

import com.google.common.base.Suppliers;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.mojang.logging.LogUtils;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforgespi.language.ModFileScanData;
import net.neoforged.testframework.Test;
import net.neoforged.testframework.annotation.ForEachTest;
import net.neoforged.testframework.annotation.OnInit;
import net.neoforged.testframework.annotation.RegisterStructureTemplate;
import net.neoforged.testframework.annotation.TestGroup;
import net.neoforged.testframework.gametest.ExtendedGameTestHelper;
import net.neoforged.testframework.gametest.StructureTemplateBuilder;
import net.neoforged.testframework.impl.MutableTestFramework;
import net.neoforged.testframework.impl.ReflectionUtils;
import net.neoforged.testframework.impl.TestFrameworkImpl;
import net.neoforged.testframework.impl.test.MethodBasedEventTest;
import net.neoforged.testframework.impl.test.MethodBasedGameTestTest;
import net.neoforged.testframework.impl.test.MethodBasedTest;
import net.neoforged.testframework.registration.RegistrationHelper;
import org.objectweb.asm.Type;

public final class FrameworkCollectors {
    private static final Predicate<ModFileScanData.AnnotationData> SIDE_FILTER = data -> {
        Dist current = FMLLoader.getDist();
        Object sidesValue = data.annotationData().get("side");
        if (sidesValue == null) {
            sidesValue = data.annotationData().get("dist");
        }
        if (sidesValue == null) {
            return true;
        }
        EnumSet sides = ((List)sidesValue).stream().map(eh -> Dist.valueOf((String)eh.getValue())).collect(Collectors.toCollection(() -> EnumSet.noneOf(Dist.class)));
        return sides.contains(current);
    };

    public static SetMultimap<OnInit.Stage, Consumer<MutableTestFramework>> onInitMethodsWithAnnotation(ModContainer container) {
        SetMultimap set = Multimaps.newSetMultimap(new EnumMap(OnInit.Stage.class), HashSet::new);
        FrameworkCollectors.findMethodsWithAnnotation(container, d -> true, OnInit.class).filter(method -> Modifier.isStatic(method.getModifiers()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(TestFrameworkImpl.class)).forEach(LamdbaExceptionUtils.rethrowConsumer(method -> {
            MethodHandle handle = ReflectionUtils.handle(method);
            set.put((Object)method.getAnnotation(OnInit.class).value(), framework -> {
                try {
                    handle.invokeWithArguments(framework);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            });
        }));
        return set;
    }

    public static void templatesWithAnnotation(ModContainer container, BiConsumer<ResourceLocation, Supplier<StructureTemplate>> acceptor) {
        Type regStrTemplate = Type.getType(RegisterStructureTemplate.class);
        container.getModInfo().getOwningFile().getFile().getScanResult().getAnnotations().stream().filter(it -> it.targetType() == ElementType.FIELD && it.annotationType().equals((Object)regStrTemplate)).map(LamdbaExceptionUtils.rethrowFunction(data -> Class.forName(data.clazz().getClassName()).getDeclaredField(data.memberName()))).filter(it -> Modifier.isStatic(it.getModifiers()) && (StructureTemplate.class.isAssignableFrom(it.getType()) || Supplier.class.isAssignableFrom(it.getType()))).forEach(field -> {
            try {
                Object obj = ReflectionUtils.fieldHandle(field).invoke();
                RegisterStructureTemplate annotation = field.getAnnotation(RegisterStructureTemplate.class);
                ResourceLocation id = new ResourceLocation(annotation.value());
                if (obj instanceof StructureTemplate) {
                    StructureTemplate template = (StructureTemplate)obj;
                    acceptor.accept(id, () -> template);
                } else if (obj instanceof Supplier) {
                    Supplier supplier = (Supplier)obj;
                    acceptor.accept(id, supplier);
                } else if (obj instanceof StructureTemplateBuilder) {
                    StructureTemplateBuilder builder = (StructureTemplateBuilder)obj;
                    acceptor.accept(id, (Supplier<StructureTemplate>)Suppliers.memoize(builder::build));
                }
            }
            catch (Throwable exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    public static void groupsWithAnnotation(ModContainer container, Consumer<GroupData> consumer) {
        Type asmType = Type.getType(TestGroup.class);
        container.getModInfo().getOwningFile().getFile().getScanResult().getAnnotations().stream().filter(it -> asmType.equals((Object)it.annotationType())).forEach(LamdbaExceptionUtils.rethrowConsumer(annotationData -> {
            Class<?> clazz = Class.forName(annotationData.clazz().getClassName());
            Field field = clazz.getDeclaredField(annotationData.memberName());
            String groupId = (String)field.get(null);
            TestGroup annotation = field.getAnnotation(TestGroup.class);
            consumer.accept(new GroupData(groupId, (Component)Component.literal((String)annotation.name()), annotation.enabledByDefault(), annotation.parents()));
        }));
    }

    public static Stream<Method> findMethodsWithAnnotation(ModContainer container, Predicate<ModFileScanData.AnnotationData> annotationPredicate, Class<? extends Annotation> annotation) {
        Type forEach = Type.getType(ForEachTest.class);
        Set excludedSides = container.getModInfo().getOwningFile().getFile().getScanResult().getAnnotations().stream().filter(it -> forEach.equals((Object)it.annotationType()) && it.targetType() == ElementType.TYPE).filter(data -> !SIDE_FILTER.test((ModFileScanData.AnnotationData)data)).map(data -> data.clazz().getClassName()).collect(Collectors.toSet());
        Type annType = Type.getType(annotation);
        return container.getModInfo().getOwningFile().getFile().getScanResult().getAnnotations().stream().filter(it -> annType.equals((Object)it.annotationType()) && it.targetType() == ElementType.METHOD && annotationPredicate.test((ModFileScanData.AnnotationData)it)).filter(it -> !excludedSides.contains(it.clazz().getClassName())).map(LamdbaExceptionUtils.rethrowFunction(annotationData -> {
            Class<?> clazz = Class.forName(annotationData.clazz().getClassName());
            String methodName = annotationData.memberName().substring(0, annotationData.memberName().indexOf("("));
            return ReflectionUtils.methodMatching(clazz, it -> it.getName().equals(methodName) && it.getAnnotation(annotation) != null);
        }));
    }

    public record GroupData(String id, @Nullable Component title, boolean isEnabledByDefault, String[] parents) {
    }

    public static final class Tests {
        public static List<Test> forClassesWithAnnotation(ModContainer container, Class<? extends Annotation> annotation) {
            Type annType = Type.getType(annotation);
            return container.getModInfo().getOwningFile().getFile().getScanResult().getAnnotations().stream().filter(it -> annType.equals((Object)it.annotationType()) && it.targetType() == ElementType.TYPE && SIDE_FILTER.test((ModFileScanData.AnnotationData)it)).map(LamdbaExceptionUtils.rethrowFunction(annotationData -> {
                Class<?> clazz = Class.forName(annotationData.clazz().getClassName());
                return (Test)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            })).toList();
        }

        public static List<Test> forMethodsWithAnnotation(ModContainer container, Class<? extends Annotation> annotation) {
            return FrameworkCollectors.findMethodsWithAnnotation(container, SIDE_FILTER, annotation).filter(method -> method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(MethodBasedTest.class) || method.getParameterTypes().length == 2 && method.getParameterTypes()[0].isAssignableFrom(MethodBasedTest.class) && method.getParameterTypes()[1] == RegistrationHelper.class).filter(method -> {
                if (Modifier.isStatic(method.getModifiers())) {
                    return true;
                }
                LogUtils.getLogger().warn("Attempted to register method-based test on non-static method: " + method);
                return false;
            }).map(MethodBasedTest::new).toList();
        }

        public static List<Test> forGameTestMethodsWithAnnotation(ModContainer container, Class<? extends Annotation> annotation) {
            return FrameworkCollectors.findMethodsWithAnnotation(container, SIDE_FILTER, annotation).filter(method -> method.getParameterTypes().length == 1 && method.getParameterTypes()[0].isAssignableFrom(ExtendedGameTestHelper.class)).filter(method -> {
                if (Modifier.isStatic(method.getModifiers())) {
                    return true;
                }
                LogUtils.getLogger().warn("Attempted to register method-based gametest test on non-static method: " + method);
                return false;
            }).map(MethodBasedGameTestTest::new).toList();
        }

        public static List<Test> eventTestMethodsWithAnnotation(ModContainer container, Class<? extends Annotation> annotation) {
            return FrameworkCollectors.findMethodsWithAnnotation(container, SIDE_FILTER, annotation).filter(method -> method.getParameterTypes().length == 2 && Event.class.isAssignableFrom(method.getParameterTypes()[0]) && method.getParameterTypes()[1].isAssignableFrom(MethodBasedEventTest.class)).filter(method -> {
                if (Modifier.isStatic(method.getModifiers())) {
                    return true;
                }
                LogUtils.getLogger().warn("Attempted to register method-based event test on non-static method: " + method);
                return false;
            }).map(MethodBasedEventTest::new).toList();
        }
    }
}

