/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower.tasks.enhance;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.snowblower.data.Version;
import net.neoforged.snowblower.util.HashFunction;

public class EnhanceVersionTask {
    private static final List<String> EXTRA_DEPENDENCIES = List.of("org.jetbrains:annotations:24.1.0", "com.google.code.findbugs:jsr305:3.0.2", "ca.weblite:java-objc-bridge:1.1");
    private static final String BUILD_GRADLE_CONTENT = "plugins {\n    id 'java'\n}\n\njava {\n    toolchain {\n        languageVersion = JavaLanguageVersion.of(%java_version%)\n    }\n}\n\nrepositories {\n    mavenCentral()\n    maven {\n        name = 'Mojang'\n        url = 'https://libraries.minecraft.net/'\n    }\n}\n\ndependencies {\n%deps%\n}\n";
    private static final String SETTINGS_GRADLE_CONTENT = "plugins {\n    id 'org.gradle.toolchains.foojay-resolver-convention' version '0.8.0'\n}\n";

    public static List<Path> enhance(Path output, Version version) throws IOException {
        byte[] buildData = BUILD_GRADLE_CONTENT.replace("%java_version%", Integer.toString(version.javaVersion().majorVersion())).replace("%deps%", Stream.concat(version.libraries().stream().filter(Version.Library::isAllowed).map(Version.Library::name), EXTRA_DEPENDENCIES.stream()).sorted().map(lib -> "    implementation '" + lib + "'").collect(Collectors.joining("\n"))).getBytes(StandardCharsets.UTF_8);
        byte[] settingsData = SETTINGS_GRADLE_CONTENT.getBytes(StandardCharsets.UTF_8);
        ArrayList<Path> added = new ArrayList<Path>();
        EnhanceVersionTask.writeCached(buildData, added, output.resolve("build.gradle"));
        EnhanceVersionTask.writeCached(settingsData, added, output.resolve("settings.gradle"));
        return added;
    }

    private static void writeCached(byte[] data, List<Path> added, Path path) throws IOException {
        String created;
        String existing = Files.exists(path, new LinkOption[0]) ? HashFunction.MD5.hash(path) : "";
        if (!existing.equals(created = HashFunction.MD5.hash(data))) {
            Files.write(path, data, new OpenOption[0]);
            added.add(path);
        }
    }
}

