/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.neoforged.mergetool.AnnotationVersion;
import net.neoforged.mergetool.Merger;
import net.neoforged.snowblower.data.Version;
import net.neoforged.snowblower.tasks.BundlerExtractTask;
import net.neoforged.snowblower.util.Cache;
import net.neoforged.snowblower.util.DependencyHashCache;
import net.neoforged.snowblower.util.Util;
import net.neoforged.srgutils.IMappingFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeTask.class);

    public static Path getJoinedJar(Path cache, Version version, Path mappings, DependencyHashCache depCache, boolean partialCache) throws IOException {
        Cache key;
        Path keyF = cache.resolve("joined.jar.cache");
        Path joinedJar = cache.resolve("joined.jar");
        if (partialCache && Files.exists(joinedJar, new LinkOption[0]) && Files.exists(keyF, new LinkOption[0]) && (key = new Cache().put("net.neoforged:mergetool", depCache).put("client", MergeTask.getSha("client", version)).put("server-full", MergeTask.getSha("server", version)).put("map", mappings).put("net.neoforged:mergetool", depCache)).isValid(keyF, k -> !k.equals("server"))) {
            LOGGER.debug("  Hitting cache for joined jar");
            return joinedJar;
        }
        Path clientJar = MergeTask.getJar("client", cache, version);
        Path serverFullJar = MergeTask.getJar("server", cache, version);
        Path serverJar = BundlerExtractTask.getExtractedServerJar(cache, serverFullJar, depCache);
        Cache key2 = new Cache().put("net.neoforged:mergetool", depCache).put("client", clientJar).put("server", serverJar).put("server-full", serverFullJar).put("map", mappings);
        if (!Files.exists(joinedJar, new LinkOption[0]) || !key2.isValid(keyF)) {
            LOGGER.debug("  Merging client and server jars");
            Merger merger = new Merger(clientJar.toFile(), serverJar.toFile(), joinedJar.toFile());
            IMappingFile map = IMappingFile.load((File)mappings.toFile());
            map.getClasses().forEach(cls -> merger.whitelist(cls.getOriginal()));
            merger.annotate(AnnotationVersion.API, true);
            merger.keepData();
            merger.skipMeta();
            merger.process();
            key2.write(keyF);
        }
        if (partialCache) {
            Files.delete(clientJar);
            Files.delete(serverFullJar);
            Files.delete(serverJar);
        }
        return joinedJar;
    }

    private static String getSha(String type, Version version) {
        return version.downloads().get(type).sha1();
    }

    private static Path getJar(String type, Path cache, Version version) throws IOException {
        Path jar = cache.resolve(type + ".jar");
        Path keyF = cache.resolve(type + ".jar.cache");
        Version.Download dl = version.downloads().get(type);
        if (dl == null || dl.sha1() == null) {
            throw new IllegalStateException("Could not download \"" + type + "\" jar as version json doesn't have download entry");
        }
        Cache key = new Cache().put(type, dl.sha1());
        if (!Files.exists(jar, new LinkOption[0]) || !key.isValid(keyF)) {
            try {
                Util.downloadFile(jar, dl.url(), dl.sha1());
            }
            catch (IOException e) {
                throw new IOException("Failed to download " + type + " jar", e);
            }
            key.put(type, jar);
            key.write(keyF);
        }
        return jar;
    }
}

