/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.util.collections;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class NullableConcurrentHashMap<K, V>
extends ConcurrentHashMap<K, V> {
    private final Object NULL_KEY = new Object(){

        public String toString() {
            return "NCH-NullKey";
        }
    };
    private final Object NULL_VALUE = new Object(){

        public String toString() {
            return "NCH-NullValue";
        }
    };

    @Override
    public V get(Object key) {
        Object res;
        if (key == null) {
            key = this.NULL_KEY;
        }
        if ((res = super.get(key)) == this.NULL_VALUE) {
            return null;
        }
        return res;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            key = this.NULL_KEY;
        }
        if (value == null) {
            value = this.NULL_VALUE;
        }
        return super.put(key, value);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            key = this.NULL_KEY;
        }
        return super.get(key) != null;
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            key = this.NULL_KEY;
        }
        return super.remove(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set ourSet = super.entrySet();
        HashSet entries = new HashSet(ourSet);
        for (Map.Entry entry : ourSet) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            boolean mod = false;
            if (key == this.NULL_KEY) {
                key = null;
                mod = true;
            }
            if (value == this.NULL_VALUE) {
                value = null;
                mod = true;
            }
            if (!mod) continue;
            entries.remove(entry);
            entries.add(new SimpleEntry(key, value));
        }
        return entries;
    }

    private static final class SimpleEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public SimpleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

