/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DominatorEngine;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DominatorTreeExceptionFilter;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.StrongConnectivityHelper;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.SupportComponent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.GeneralStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.collections.fixed.FastFixedSet;
import org.jetbrains.java.decompiler.util.collections.fixed.FastFixedSetFactory;

public class FastExtendedPostdominanceHelper {
    private List<Statement> lstReversePostOrderList;
    private HashMap<Integer, FastFixedSet<Integer>> mapSupportPoints = new LinkedHashMap<Integer, FastFixedSet<Integer>>();
    private final HashMap<Integer, FastFixedSet<Integer>> mapExtPostdominators = new LinkedHashMap<Integer, FastFixedSet<Integer>>();
    private Statement statement;
    private FastFixedSetFactory<Integer> factory;

    public HashMap<Integer, Set<Integer>> getExtendedPostdominators(Statement statement) {
        if (!(statement instanceof GeneralStatement)) {
            throw new IllegalStateException("Cannot find extended post dominators of non generalized statement");
        }
        this.statement = statement;
        LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
        for (Statement st : statement.getStats()) {
            set.add(st.id);
        }
        this.factory = FastFixedSetFactory.create(set);
        this.lstReversePostOrderList = statement.getReversePostOrderList();
        this.calcDefaultReachableSets();
        this.removeErroneousNodes();
        DominatorTreeExceptionFilter filter = new DominatorTreeExceptionFilter(statement);
        filter.initialize();
        this.filterOnExceptionRanges(filter);
        this.filterOnDominance(filter);
        this.addSupportedComponents(filter);
        Set<Map.Entry<Integer, FastFixedSet<Integer>>> entries = this.mapExtPostdominators.entrySet();
        HashMap<Integer, Set<Integer>> res = new HashMap<Integer, Set<Integer>>(entries.size());
        for (Map.Entry<Integer, FastFixedSet<Integer>> entry : entries) {
            ArrayList<Integer> lst = new ArrayList<Integer>(entry.getValue().toPlainSet());
            Collections.sort(lst);
            res.put(entry.getKey(), new LinkedHashSet<Integer>(lst));
        }
        return res;
    }

    private void addSupportedComponents(DominatorTreeExceptionFilter filter) {
        StrongConnectivityHelper schelp = new StrongConnectivityHelper(this.statement);
        for (List<Statement> comp : schelp.getComponents()) {
            SupportComponent supcomp = SupportComponent.identify(comp, this.mapSupportPoints, filter.getDomEngine());
            if (supcomp == null) continue;
            for (Statement st : supcomp.stats) {
                if (st == supcomp.supportedPoint) continue;
                this.mapExtPostdominators.computeIfAbsent(st.id, i -> this.factory.createEmptySet()).add(supcomp.supportedPoint.id);
            }
        }
    }

    private void filterOnDominance(DominatorTreeExceptionFilter filter) {
        DominatorEngine engine = filter.getDomEngine();
        ArrayDeque<Statement> stack = new ArrayDeque<Statement>();
        ArrayDeque stackPath = new ArrayDeque();
        HashSet<Statement> setVisited = new HashSet<Statement>();
        for (int head : new HashSet<Integer>(this.mapExtPostdominators.keySet())) {
            FastFixedSet<Integer> setPostdoms = this.mapExtPostdominators.get(head);
            stack.clear();
            stackPath.clear();
            stack.add(this.statement.getStats().getWithKey(head));
            stackPath.add(this.factory.createEmptySet());
            setVisited.clear();
            setVisited.add((Statement)stack.getFirst());
            while (!stack.isEmpty()) {
                Statement stat = (Statement)stack.removeFirst();
                FastFixedSet path = (FastFixedSet)stackPath.removeFirst();
                if (!setPostdoms.containsKey(stat.id)) {
                    throw new IllegalStateException("Inconsistent statement structure!");
                }
                if (setPostdoms.contains(stat.id)) {
                    path.add(stat.id);
                }
                if (path.contains(setPostdoms)) continue;
                if (!engine.isDominator(stat.id, head)) {
                    setPostdoms.complement(path);
                    continue;
                }
                for (StatEdge edge : stat.getSuccessorEdges(9)) {
                    Statement destination;
                    if (edge.getType() == 8 && edge.getDestination() != this.statement || setVisited.contains(destination = edge.getType() == 8 && edge.getDestination() == this.statement ? edge.getDestination().getFirst() : edge.getDestination())) continue;
                    stack.add(destination);
                    stackPath.add(path.getCopy());
                    setVisited.add(destination);
                }
            }
            if (!setPostdoms.isEmpty()) continue;
            this.mapExtPostdominators.remove(head);
        }
    }

    private void filterOnExceptionRanges(DominatorTreeExceptionFilter filter) {
        for (int head : new HashSet<Integer>(this.mapExtPostdominators.keySet())) {
            FastFixedSet<Integer> set = this.mapExtPostdominators.get(head);
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Integer next = (Integer)it.next();
                if (filter.acceptStatementPair(head, next)) continue;
                it.remove();
            }
            if (!set.isEmpty()) continue;
            this.mapExtPostdominators.remove(head);
        }
    }

    private void removeErroneousNodes() {
        this.mapSupportPoints = new HashMap();
        this.calcReachabilitySuppPointsEx();
        this.iterateReachability((node, mapSets) -> {
            Integer nodeid = node.id;
            FastFixedSet setReachability = (FastFixedSet)mapSets.get(nodeid);
            ArrayList<FastFixedSet<Integer>> lstPredSets = new ArrayList<FastFixedSet<Integer>>();
            for (StatEdge prededge : node.getPredecessorEdges(1)) {
                FastFixedSet<Integer> setPred = (FastFixedSet<Integer>)mapSets.get(prededge.getSource().id);
                if (setPred == null) {
                    setPred = this.mapSupportPoints.get(prededge.getSource().id);
                }
                lstPredSets.add(setPred);
            }
            Iterator<StatEdge> iterator = setReachability.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)((Object)iterator.next());
                FastFixedSet<Integer> setReachabilityCopy = setReachability.getCopy();
                FastFixedSet<Integer> setIntersection = this.factory.createEmptySet();
                boolean isIntersectionInitialized = false;
                for (FastFixedSet fastFixedSet : lstPredSets) {
                    if (!fastFixedSet.contains(id)) continue;
                    if (!isIntersectionInitialized) {
                        setIntersection.union(fastFixedSet);
                        isIntersectionInitialized = true;
                        continue;
                    }
                    setIntersection.intersection(fastFixedSet);
                }
                if (nodeid != id) {
                    setIntersection.add(nodeid);
                } else {
                    setIntersection.remove(nodeid);
                }
                setReachabilityCopy.complement(setIntersection);
                this.mapExtPostdominators.get(id).complement(setReachabilityCopy);
            }
            return false;
        }, 1);
        FastFixedSet<Integer> setHandlers = this.factory.createEmptySet();
        boolean handlerfound = false;
        for (Statement statement : this.statement.getStats()) {
            if (!statement.getPredecessorEdges(0x40000000).isEmpty() || statement.getPredecessorEdges(2).isEmpty()) continue;
            setHandlers.add(statement.id);
            handlerfound = true;
        }
        if (handlerfound) {
            for (FastFixedSet fastFixedSet : this.mapExtPostdominators.values()) {
                fastFixedSet.complement(setHandlers);
            }
        }
    }

    private void calcDefaultReachableSets() {
        int edgetype = 3;
        this.calcReachabilitySuppPoints(edgetype);
        for (Statement stat : this.statement.getStats()) {
            this.mapExtPostdominators.put(stat.id, this.factory.createEmptySet());
        }
        this.iterateReachability((node, mapSets) -> {
            Integer nodeid = node.id;
            FastFixedSet setReachability = (FastFixedSet)mapSets.get(nodeid);
            Iterator iterator = setReachability.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                this.mapExtPostdominators.get(id).add(nodeid);
            }
            return false;
        }, edgetype);
    }

    private void calcReachabilitySuppPoints(int edgetype) {
        this.iterateReachability((node, mapSets) -> {
            for (StatEdge sucedge : node.getAllSuccessorEdges()) {
                FastFixedSet setReachability;
                if ((sucedge.getType() & edgetype) == 0 || !mapSets.containsKey(sucedge.getDestination().id) || InterpreterUtil.equalObjects(setReachability = (FastFixedSet)mapSets.get(node.id), this.mapSupportPoints.get(node.id))) continue;
                this.mapSupportPoints.put(node.id, setReachability);
                return true;
            }
            return false;
        }, edgetype);
    }

    private void calcReachabilitySuppPointsEx() {
        this.iterateReachability((node, mapSets) -> {
            for (StatEdge sucedge : node.getAllSuccessorEdges()) {
                FastFixedSet setReachability;
                Statement destination;
                if ((sucedge.getType() & 1) == 0 && ((sucedge.getType() & 8) == 0 || sucedge.getDestination() != this.statement)) continue;
                Statement statement = destination = sucedge.getType() == 8 && sucedge.getDestination() == this.statement ? sucedge.getDestination().getFirst() : sucedge.getDestination();
                if (!mapSets.containsKey(destination.id) || InterpreterUtil.equalObjects(setReachability = (FastFixedSet)mapSets.get(node.id), this.mapSupportPoints.get(node.id))) continue;
                this.mapSupportPoints.put(node.id, setReachability);
                return true;
            }
            return false;
        }, 1);
    }

    private void iterateReachability(IReachabilityAction action, int edgetype) {
        boolean iterate;
        HashMap<Integer, FastFixedSet<Integer>> mapSets = new HashMap<Integer, FastFixedSet<Integer>>();
        do {
            iterate = false;
            mapSets.clear();
            for (Statement stat : this.lstReversePostOrderList) {
                Statement pred;
                FastFixedSet<Integer> set = this.factory.createEmptySet();
                set.add(stat.id);
                for (StatEdge prededge : stat.getAllPredecessorEdges()) {
                    if ((prededge.getType() & edgetype) == 0) continue;
                    pred = prededge.getSource();
                    FastFixedSet<Integer> setPred = mapSets.get(pred.id);
                    if (setPred == null) {
                        setPred = this.mapSupportPoints.get(pred.id);
                    }
                    if (setPred == null) continue;
                    set.union(setPred);
                }
                mapSets.put(stat.id, set);
                if (action != null) {
                    iterate |= action.action(stat, mapSets);
                }
                for (StatEdge prededge : stat.getAllPredecessorEdges()) {
                    if ((prededge.getType() & edgetype) == 0) continue;
                    pred = prededge.getSource();
                    if (!mapSets.containsKey(pred.id)) continue;
                    boolean remstat = true;
                    for (StatEdge sucedge : pred.getAllSuccessorEdges()) {
                        if ((sucedge.getType() & edgetype) == 0 || mapSets.containsKey(sucedge.getDestination().id)) continue;
                        remstat = false;
                        break;
                    }
                    if (!remstat) continue;
                    mapSets.put(pred.id, null);
                }
            }
        } while (iterate);
    }

    private static interface IReachabilityAction {
        public boolean action(Statement var1, HashMap<Integer, FastFixedSet<Integer>> var2);
    }
}

