/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import org.jetbrains.java.decompiler.api.java.JavaPassLocation;
import org.jetbrains.java.decompiler.api.plugin.LanguageSpec;
import org.jetbrains.java.decompiler.api.plugin.pass.PassContext;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.decompiler.CancelationManager;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.plugins.PluginContext;
import org.jetbrains.java.decompiler.main.rels.DecompileRecord;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ClearStructHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ConcatenationHelper;
import org.jetbrains.java.decompiler.modules.decompiler.EliminateLoopsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExitHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.FinallyProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.GenericsProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.IfPatternMatchProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.InlineSingleBlockHelper;
import org.jetbrains.java.decompiler.modules.decompiler.IntersectionCastProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LoopExtractHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.PPandMMHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SecondaryFunctionsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StackVarsProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchExpressionHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchPatternMatchProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.SynchronizedHelper;
import org.jetbrains.java.decompiler.modules.decompiler.TryHelper;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DomHelper;
import org.jetbrains.java.decompiler.modules.decompiler.deobfuscator.ExceptionDeobfuscator;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.DotExporter;

public class MethodProcessor
implements Runnable {
    public static ThreadLocal<RootStatement> debugCurrentlyDecompiling = ThreadLocal.withInitial(() -> null);
    public static ThreadLocal<ControlFlowGraph> debugCurrentCFG = ThreadLocal.withInitial(() -> null);
    public static ThreadLocal<DecompileRecord> debugCurrentDecompileRecord = ThreadLocal.withInitial(() -> null);
    public final Object lock = new Object();
    private final StructClass klass;
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private final VarProcessor varProc;
    private final LanguageSpec spec;
    private final DecompilerContext parentContext;
    private volatile RootStatement root;
    private volatile Throwable error;
    private volatile boolean finished = false;

    public MethodProcessor(StructClass klass, StructMethod method, MethodDescriptor methodDescriptor, VarProcessor varProc, LanguageSpec spec, DecompilerContext parentContext) {
        this.klass = klass;
        this.method = method;
        this.methodDescriptor = methodDescriptor;
        this.varProc = varProc;
        this.spec = spec;
        this.parentContext = parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.error = null;
        this.root = null;
        try {
            DecompilerContext.setCurrentContext(this.parentContext);
            this.root = MethodProcessor.codeToJava(this.klass, this.method, this.methodDescriptor, this.varProc, this.spec);
        }
        catch (CancelationManager.CanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            this.error = t;
        }
        finally {
            DecompilerContext.setCurrentContext(null);
        }
        this.finished = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static RootStatement codeToJava(StructClass cl, StructMethod mt, MethodDescriptor md, VarProcessor varProc, LanguageSpec spec) throws IOException {
        CancelationManager.checkCanceled();
        debugCurrentlyDecompiling.set(null);
        debugCurrentCFG.set(null);
        debugCurrentDecompileRecord.set(null);
        boolean isInitializer = "<clinit>".equals(mt.getName());
        PluginContext pluginContext = PluginContext.getCurrentContext();
        mt.expandData(cl);
        InstructionSequence seq = mt.getInstructionSequence();
        ControlFlowGraph graph = new ControlFlowGraph(seq);
        debugCurrentCFG.set(graph);
        DotExporter.toDotFile(graph, mt, "cfgConstructed", true);
        DeadCodeHelper.removeDeadBlocks(graph);
        if (mt.getBytecodeVersion().hasJsr() || DecompilerContext.getOption("force-jsr-inline")) {
            graph.inlineJsr(cl, mt);
        }
        DeadCodeHelper.connectDummyExitBlock(graph);
        DeadCodeHelper.removeGotos(graph);
        ExceptionDeobfuscator.removeCircularRanges(graph);
        ExceptionDeobfuscator.restorePopRanges(graph);
        if (DecompilerContext.getOption("remove-empty-try-catch")) {
            ExceptionDeobfuscator.removeEmptyRanges(graph);
        }
        if (DecompilerContext.getOption("ensure-synchronized-monitors")) {
            DeadCodeHelper.extendSynchronizedRangeToMonitorexit(graph);
        }
        if (DecompilerContext.getOption("incorporate-returns")) {
            DeadCodeHelper.incorporateValueReturns(graph);
        }
        ExceptionDeobfuscator.insertEmptyExceptionHandlerBlocks(graph);
        DeadCodeHelper.mergeBasicBlocks(graph);
        DecompilerContext.getCounterContainer().setCounter(2, mt.getLocalVariables());
        if (ExceptionDeobfuscator.hasObfuscatedExceptions(graph)) {
            DotExporter.toDotFile(graph, mt, "cfgExceptionsPre", true);
            if (!ExceptionDeobfuscator.handleMultipleEntryExceptionRanges(graph)) {
                DecompilerContext.getLogger().writeMessage("Found multiple entry exception ranges which could not be splitted", IFernflowerLogger.Severity.WARN);
                graph.addComment("$VF: Could not handle exception ranges with multiple entries");
                graph.addErrorComment = true;
            }
            DotExporter.toDotFile(graph, mt, "cfgMultipleExceptionEntry", true);
            ExceptionDeobfuscator.insertDummyExceptionHandlerBlocks(graph, mt.getBytecodeVersion());
            DotExporter.toDotFile(graph, mt, "cfgMultipleExceptionDummyHandlers", true);
        }
        if (spec != null) {
            DecompileRecord decompileRecord = new DecompileRecord(mt);
            RootStatement root = spec.graphParser.createStatement(graph, mt);
            PassContext pctx = new PassContext(root, graph, mt, cl, varProc, decompileRecord);
            spec.pass.run(pctx);
            return root;
        }
        DotExporter.toDotFile(graph, mt, "cfgParsed", true);
        RootStatement root = DomHelper.parseGraph(graph, mt, 0);
        DecompileRecord decompileRecord = new DecompileRecord(mt);
        debugCurrentDecompileRecord.set(decompileRecord);
        decompileRecord.add("Initial", root);
        debugCurrentlyDecompiling.set(root);
        FinallyProcessor fProc = new FinallyProcessor(mt, md, varProc);
        int finallyProcessed = 0;
        while (fProc.iterateGraph(cl, mt, root, graph)) {
            RootStatement oldRoot = root;
            decompileRecord.add("ProcessFinallyOld_" + ++finallyProcessed, root);
            DotExporter.toDotFile(graph, mt, "cfgProcessFinally_" + finallyProcessed, true);
            root = DomHelper.parseGraph(graph, mt, finallyProcessed);
            root.addComments(oldRoot);
            decompileRecord.add("ProcessFinally_" + finallyProcessed, root);
            debugCurrentCFG.set(graph);
            debugCurrentlyDecompiling.set(root);
        }
        if (DomHelper.buildSynchronized(root)) {
            decompileRecord.add("BuildFinallySynchronized", root);
        }
        if (finallyProcessed > 0) {
            decompileRecord.add("ProcessFinally_Post", root);
        }
        if (DomHelper.removeSynchronizedHandler(root)) {
            decompileRecord.add("RemoveSynchronizedHandler", root);
        }
        root.buildContentFlags();
        SequenceHelper.condenseSequences(root);
        decompileRecord.add("CondenseSequences", root);
        ClearStructHelper.clearStatements(root);
        decompileRecord.add("ClearStatements", root);
        ExprProcessor proc = new ExprProcessor(md, varProc);
        proc.processStatement(root, cl);
        decompileRecord.add("ProcessStatement", root);
        SequenceHelper.condenseSequences(root);
        decompileRecord.add("CondenseSequences_1", root);
        int stackVarsProcessed = 0;
        do {
            StackVarsProcessor.simplifyStackVars(root, mt, cl);
            decompileRecord.add("SimplifyStackVars_PPMM_" + ++stackVarsProcessed, root);
            varProc.setVarVersions(root);
            decompileRecord.add("SetVarVersions_PPMM_" + stackVarsProcessed, root);
        } while (new PPandMMHelper(varProc).findPPandMM(root));
        PassContext pctx = new PassContext(root, graph, mt, cl, varProc, decompileRecord);
        if (PPandMMHelper.inlinePPIandMMIIf(root)) {
            decompileRecord.add("InlinePPIandMMI", root);
        }
        if (cl.getVersion().hasIndyStringConcat()) {
            ConcatenationHelper.simplifyStringConcat(root);
            decompileRecord.add("SimplifyStringConcat", root);
        }
        pluginContext.runPasses(JavaPassLocation.BEFORE_MAIN, pctx);
        while (true) {
            decompileRecord.incrementMainLoop();
            decompileRecord.add("Start", root);
            LabelHelper.cleanUpEdges(root);
            decompileRecord.add("CleanupEdges", root);
            if (root.hasLoops()) {
                while (true) {
                    decompileRecord.incrementMergeLoop();
                    decompileRecord.add("MergeLoopStart", root);
                    if (EliminateLoopsHelper.eliminateLoops(root, cl)) {
                        decompileRecord.add("EliminateLoops", root);
                        continue;
                    }
                    MergeHelper.enhanceLoops(root);
                    decompileRecord.add("EnhanceLoops", root);
                    if (LoopExtractHelper.extractLoops(root)) {
                        decompileRecord.add("ExtractLoops", root);
                        continue;
                    }
                    if (pluginContext.runPasses(JavaPassLocation.IN_LOOP_DECOMP, pctx)) continue;
                    if (!IfHelper.mergeAllIfs(root)) break;
                    decompileRecord.add("MergeAllIfs", root);
                }
                decompileRecord.resetMergeLoop();
                decompileRecord.add("MergeLoopEnd", root);
            }
            StackVarsProcessor.simplifyStackVars(root, mt, cl);
            decompileRecord.add("SimplifyStackVars", root);
            varProc.setVarVersions(root);
            decompileRecord.add("SetVarVersions", root);
            LabelHelper.identifyLabels(root);
            decompileRecord.add("IdentifyLabels", root);
            if (SecondaryFunctionsHelper.identifySecondaryFunctions(root, varProc)) {
                decompileRecord.add("IdentifySecondary", root);
                continue;
            }
            if (IntersectionCastProcessor.makeIntersectionCasts(root)) {
                decompileRecord.add("intersectionCasts", root);
                continue;
            }
            if (DecompilerContext.getOption("pattern-matching") && cl.getVersion().hasIfPatternMatching() && IfPatternMatchProcessor.matchInstanceof(root)) {
                decompileRecord.add("MatchIfInstanceof", root);
                continue;
            }
            if (root.hasSwitch()) {
                boolean changed = false;
                if (SwitchPatternMatchProcessor.hasPatternMatch(root) && SwitchPatternMatchProcessor.processPatternMatching(root)) {
                    decompileRecord.add("ProcessSwitchPatternMatch", root);
                    changed = true;
                }
                if (SwitchExpressionHelper.hasSwitchExpressions(root) && SwitchExpressionHelper.processSwitchExpressions(root)) {
                    decompileRecord.add("ProcessSwitchExpr", root);
                    changed = true;
                }
                if (changed) continue;
            }
            if (root.hasTryCatch() && TryHelper.enhanceTryStats(root, cl)) {
                decompileRecord.add("EnhanceTry", root);
                continue;
            }
            if (InlineSingleBlockHelper.inlineSingleBlocks(root)) {
                decompileRecord.add("InlineSingleBlocks", root);
                continue;
            }
            if (root.hasLoops() && MergeHelper.makeDoWhileLoops(root)) {
                decompileRecord.add("MatchDoWhile", root);
                continue;
            }
            if (root.hasLoops() && MergeHelper.condenseInfiniteLoopsWithReturn(root)) {
                decompileRecord.add("CondenseDo", root);
                continue;
            }
            if (pluginContext.runPasses(JavaPassLocation.MAIN_LOOP, pctx)) continue;
            if (isInitializer || !ExitHelper.condenseExits(root)) break;
            decompileRecord.add("CondenseExits", root);
        }
        decompileRecord.resetMainLoop();
        decompileRecord.add("MainLoopEnd", root);
        if (root.hasSwitch() && SwitchHelper.simplifySwitches(root, mt, root)) {
            SequenceHelper.condenseSequences(root);
            decompileRecord.add("SimplifySwitches", root);
            if (SwitchExpressionHelper.hasSwitchExpressions(root) && SwitchExpressionHelper.processSwitchExpressions(root)) {
                decompileRecord.add("ProcessSwitchExpr_SS", root);
                StackVarsProcessor.simplifyStackVars(root, mt, cl);
                decompileRecord.add("SimplifyStackVars_SS", root);
                varProc.setVarVersions(root);
                decompileRecord.add("SetVarVersions_SS", root);
            }
        }
        if (ExitHelper.adjustReturnType(root, md)) {
            decompileRecord.add("AdjustReturnType", root);
        }
        if (ExitHelper.removeRedundantReturns(root)) {
            decompileRecord.add("RedundantReturns", root);
        }
        if (SecondaryFunctionsHelper.identifySecondaryFunctions(root, varProc)) {
            decompileRecord.add("IdentifySecondary", root);
        }
        if (SynchronizedHelper.cleanSynchronizedVar(root)) {
            decompileRecord.add("ClearSynchronized", root);
        }
        if (SynchronizedHelper.insertSink(root, varProc, root)) {
            decompileRecord.add("InsertSynchronizedAssignments", root);
        }
        pluginContext.runPasses(JavaPassLocation.AFTER_MAIN, pctx);
        varProc.setVarDefinitions(root);
        decompileRecord.add("SetVarDefinitions", root);
        if (SecondaryFunctionsHelper.updateAssignments(root)) {
            decompileRecord.add("UpdateAssignments", root);
        }
        if (root.hasSwitch() && LabelHelper.hideDefaultSwitchEdges(root)) {
            decompileRecord.add("HideEmptyDefault", root);
        }
        if (GenericsProcessor.qualifyChains(root)) {
            decompileRecord.add("QualifyGenericChains", root);
        }
        if (ExprProcessor.canonicalizeCasts(root)) {
            decompileRecord.add("CanonicalizeCasts", root);
        }
        pluginContext.runPasses(JavaPassLocation.AT_END, pctx);
        if (LabelHelper.replaceContinueWithBreak(root)) {
            decompileRecord.add("ReplaceContinues", root);
        }
        ExprProcessor.markExprOddities(root);
        DotExporter.toDotFile(root, mt, "finalStatement");
        if (DotExporter.DUMP_DOTS) {
            FlattenStatementsHelper flatten = new FlattenStatementsHelper();
            DirectGraph digraph = flatten.buildDirectGraph(root);
            DotExporter.toDotFile(digraph, mt, "finalStatementDigraph");
        }
        DotExporter.toDotFile(decompileRecord, mt, "decompileRecord", false);
        mt.releaseResources();
        return root;
    }

    public RootStatement getResult() throws Throwable {
        Throwable t = this.error;
        if (t != null) {
            throw t;
        }
        return this.root;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

