/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.fabricmc.fernflower.api.IFabricJavadocProvider;
import org.jetbrains.java.decompiler.api.plugin.StatementWriter;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.main.AssertProcessor;
import org.jetbrains.java.decompiler.main.ClassReference14Processor;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.EnumProcessor;
import org.jetbrains.java.decompiler.main.InitializerProcessor;
import org.jetbrains.java.decompiler.main.RecordHelper;
import org.jetbrains.java.decompiler.main.collectors.ImportCollector;
import org.jetbrains.java.decompiler.main.decompiler.CancelationManager;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.ClassWrapper;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ExitExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.TypeAnnotation;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarTypeProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.renamer.PoolInterceptor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructField;
import org.jetbrains.java.decompiler.struct.StructMember;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.StructRecordComponent;
import org.jetbrains.java.decompiler.struct.attr.StructAnnDefaultAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructAnnotationParameterAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructBootstrapMethodsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructConstantValueAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructMethodParametersAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructModuleAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructPermittedSubclassesAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructSourceFileAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructTypeAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.consts.LinkConstant;
import org.jetbrains.java.decompiler.struct.consts.PooledConstant;
import org.jetbrains.java.decompiler.struct.consts.PrimitiveConstant;
import org.jetbrains.java.decompiler.struct.gen.CodeType;
import org.jetbrains.java.decompiler.struct.gen.FieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericClassDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericFieldDescriptor;
import org.jetbrains.java.decompiler.struct.gen.generics.GenericMethodDescriptor;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.Key;
import org.jetbrains.java.decompiler.util.TextBuffer;
import org.jetbrains.java.decompiler.util.TextUtil;
import org.jetbrains.java.decompiler.util.collections.VBStyleCollection;

public class ClassWriter
implements StatementWriter {
    private static final Set<String> ERROR_DUMP_STOP_POINTS = new HashSet<String>(Arrays.asList("Fernflower.decompileContext", "MethodProcessor.codeToJava", "ClassWriter.writeMethod", "ClassWriter.methodLambdaToJava", "ClassWriter.classLambdaToJava"));
    private final PoolInterceptor interceptor = DecompilerContext.getPoolInterceptor();
    private final IFabricJavadocProvider javadocProvider = (IFabricJavadocProvider)DecompilerContext.getProperty("fabric:javadoc");
    static final Key<?>[] ANNOTATION_ATTRIBUTES = new Key[]{StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS, StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_ANNOTATIONS};
    static final Key<?>[] PARAMETER_ANNOTATION_ATTRIBUTES = new Key[]{StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS, StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS};
    static final Key<?>[] TYPE_ANNOTATION_ATTRIBUTES = new Key[]{StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_TYPE_ANNOTATIONS, StructGeneralAttribute.ATTRIBUTE_RUNTIME_INVISIBLE_TYPE_ANNOTATIONS};
    private static final Map<Integer, String> MODIFIERS = new LinkedHashMap<Integer, String>();
    private static final int CLASS_ALLOWED = 3103;
    private static final int FIELD_ALLOWED = 223;
    private static final int METHOD_ALLOWED = 3391;
    private static final int CLASS_EXCLUDED = 1032;
    private static final int FIELD_EXCLUDED = 25;
    private static final int METHOD_EXCLUDED = 1025;
    private static final int ACCESSIBILITY_FLAGS = 7;

    private static boolean invokeProcessors(TextBuffer buffer, ClassesProcessor.ClassNode node) {
        ClassWrapper wrapper = node.getWrapper();
        if (wrapper == null) {
            buffer.append("/* $VF: Couldn't be decompiled. Class " + node.classStruct.qualifiedName + " wasn't processed yet! */");
            ArrayList<String> lines = new ArrayList<String>();
            lines.addAll(ClassWriter.getErrorComment());
            for (String line : lines) {
                buffer.append("//");
                if (!line.isEmpty()) {
                    buffer.append(' ').append(line);
                }
                buffer.appendLineSeparator();
            }
            return false;
        }
        StructClass cl = wrapper.getClassStruct();
        for (MethodWrapper method : wrapper.getMethods()) {
            if (method.root == null) continue;
            try {
                SwitchHelper.simplifySwitches(method.root, method.methodStruct, method.root);
            }
            catch (CancelationManager.CanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                DecompilerContext.getLogger().writeMessage("Method " + method.methodStruct.getName() + " " + method.methodStruct.getDescriptor() + " in class " + node.classStruct.qualifiedName + " couldn't be written.", IFernflowerLogger.Severity.WARN, e);
                method.decompileError = e;
            }
        }
        try {
            InitializerProcessor.extractInitializers(wrapper);
            InitializerProcessor.hideInitalizers(wrapper);
            if (node.type == ClassesProcessor.ClassNode.Type.ROOT && cl.getVersion().has14ClassReferences() && DecompilerContext.getOption("decompile-java4")) {
                ClassReference14Processor.processClassReferences(node);
            }
            if (cl.hasModifier(16384) && DecompilerContext.getOption("decompile-enums")) {
                EnumProcessor.clearEnum(wrapper);
            }
            if (DecompilerContext.getOption("decompile-assert")) {
                AssertProcessor.buildAssertions(node);
            }
            for (MethodWrapper mw : wrapper.getMethods()) {
                RecordHelper.fixupCanonicalConstructor(mw, cl);
                if (mw.root == null) continue;
                mw.varproc.rerunClashing(mw.root);
            }
        }
        catch (CancelationManager.CanceledException e) {
            throw e;
        }
        catch (Throwable t) {
            DecompilerContext.getLogger().writeMessage("Class " + node.simpleName + " couldn't be written.", IFernflowerLogger.Severity.WARN, t);
            ClassWriter.writeException(buffer, t);
            return false;
        }
        return true;
    }

    public static void writeException(TextBuffer buffer, Throwable t) {
        buffer.append("// $VF: Couldn't be decompiled");
        buffer.appendLineSeparator();
        if (DecompilerContext.getOption("dump-exception-on-error")) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.addAll(ClassWriter.getErrorComment());
            ClassWriter.collectErrorLines(t, lines);
            for (String line : lines) {
                buffer.append("//");
                if (!line.isEmpty()) {
                    buffer.append(' ').append(line);
                }
                buffer.appendLineSeparator();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void classLambdaToJava(ClassesProcessor.ClassNode node, TextBuffer buffer, Exprent method_object, int indent) {
        ClassWrapper wrapper = node.getWrapper();
        if (wrapper == null) {
            return;
        }
        boolean lambdaToAnonymous = DecompilerContext.getOption("lambda-to-anonymous-class");
        ClassesProcessor.ClassNode outerNode = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
        DecompilerContext.setProperty(DecompilerContext.CURRENT_CLASS_NODE, node);
        try {
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(node.simpleName);
            if (node.lambdaInformation.is_method_reference) {
                if (!node.lambdaInformation.is_content_method_static && method_object != null) {
                    method_object.getInferredExprType(new VarType(CodeType.OBJECT, 0, node.lambdaInformation.content_class_name));
                    TextBuffer instance = method_object.toJava(indent);
                    if (method_object instanceof FunctionExprent && ((FunctionExprent)method_object).getFuncType() == FunctionExprent.FunctionType.CAST && ((FunctionExprent)method_object).doesCast()) {
                        buffer.append('(').append(instance).append(')');
                    } else {
                        buffer.append(instance);
                    }
                } else {
                    buffer.appendCastTypeName(new VarType(node.lambdaInformation.content_class_name, true));
                }
                buffer.append("::").appendMethod("<init>".equals(node.lambdaInformation.content_method_name) ? "new" : node.lambdaInformation.content_method_name, false, node.lambdaInformation.content_class_name, node.lambdaInformation.content_method_name, node.lambdaInformation.content_method_descriptor);
            } else {
                StructMethod mt = cl.getMethod(node.lambdaInformation.content_method_key);
                MethodWrapper methodWrapper = wrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
                MethodDescriptor md_content = MethodDescriptor.parseDescriptor(node.lambdaInformation.content_method_descriptor);
                MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(node.lambdaInformation.method_descriptor);
                boolean simpleLambda = false;
                boolean written = false;
                if (!lambdaToAnonymous) {
                    ExitExprent exit;
                    Exprent returnValue;
                    Exprent exp;
                    RootStatement root = wrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
                    if (DecompilerContext.getOption("mark-corresponding-synthetics")) {
                        buffer.append("/* ").appendMethod(node.lambdaInformation.content_method_name, true, node.lambdaInformation.content_class_name, node.lambdaInformation.content_method_name, node.lambdaInformation.content_method_descriptor).append(" */ ");
                    }
                    if (md_lambda.params.length == 1 && md_lambda.params[0].equals(VarType.VARTYPE_INT) && md_lambda.ret.arrayDim > 0 && root.getFirst() instanceof BasicBlockStatement && root.getFirst().getExprents().size() == 1 && (exp = root.getFirst().getExprents().get(0)) instanceof ExitExprent && (returnValue = (exit = (ExitExprent)exp).getValue()) instanceof NewExprent) {
                        VarExprent sizeVar;
                        Exprent size;
                        NewExprent newExp = (NewExprent)returnValue;
                        if (newExp.getNewType().arrayDim > 0 && !newExp.isDirectArrayInit() && newExp.getLstArrayElements().isEmpty() && newExp.getLstDims().size() > 0 && (size = newExp.getLstDims().get(newExp.getLstDims().size() - 1)) instanceof VarExprent && (sizeVar = (VarExprent)size).getIndex() == (node.lambdaInformation.is_content_method_static ? 0 : 1)) {
                            VarType returnType = md_lambda.ret;
                            buffer.appendCastTypeName(returnType);
                            buffer.append("::new");
                            written = true;
                        }
                    }
                    if (!written) {
                        boolean lambdaParametersNeedParentheses;
                        boolean bl = lambdaParametersNeedParentheses = md_lambda.params.length != 1;
                        if (lambdaParametersNeedParentheses) {
                            buffer.append('(');
                        }
                        boolean firstParameter = true;
                        int index = node.lambdaInformation.is_content_method_static ? 0 : 1;
                        int start_index = md_content.params.length - md_lambda.params.length;
                        for (int i = 0; i < md_content.params.length; ++i) {
                            if (i >= start_index) {
                                if (!firstParameter) {
                                    buffer.append(", ");
                                }
                                VarType type = md_content.params[i];
                                String clashingName = methodWrapper.varproc.getClashingName(new VarVersionPair(index, 0));
                                Object parameterName = methodWrapper.varproc.getVarName(new VarVersionPair(index, 0));
                                if (parameterName == null) {
                                    parameterName = "param" + index;
                                }
                                if (clashingName != null) {
                                    parameterName = clashingName;
                                }
                                parameterName = methodWrapper.methodStruct.getVariableNamer().renameParameter(mt.getAccessFlags(), type, (String)parameterName, index);
                                buffer.appendVariable((String)parameterName, true, true, node.lambdaInformation.content_class_name, node.lambdaInformation.content_method_name, md_content, index, (String)parameterName);
                                firstParameter = false;
                            }
                            index += md_content.params[i].stackSize;
                        }
                        if (lambdaParametersNeedParentheses) {
                            buffer.append(")");
                        }
                        buffer.append(" ->");
                        if (DecompilerContext.getOption("inline-simple-lambdas") && methodWrapper.decompileError == null && root != null) {
                            Statement firstStat = root.getFirst();
                            if (firstStat instanceof BasicBlockStatement && firstStat.getExprents() != null && firstStat.getExprents().size() == 1) {
                                boolean isThrow;
                                Exprent firstExpr = firstStat.getExprents().get(0);
                                boolean isVarDefinition = firstExpr instanceof AssignmentExprent && ((AssignmentExprent)firstExpr).getLeft() instanceof VarExprent && ((VarExprent)((AssignmentExprent)firstExpr).getLeft()).isDefinition();
                                boolean bl2 = isThrow = firstExpr instanceof ExitExprent && ((ExitExprent)firstExpr).getExitType() == ExitExprent.Type.THROW;
                                if (!isVarDefinition && !isThrow) {
                                    simpleLambda = true;
                                    MethodWrapper outerWrapper = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
                                    DecompilerContext.setProperty(DecompilerContext.CURRENT_METHOD_WRAPPER, methodWrapper);
                                    try {
                                        TextBuffer codeBuffer = firstExpr.toJava(indent);
                                        if (firstExpr instanceof ExitExprent) {
                                            codeBuffer.setStart(6);
                                        } else {
                                            codeBuffer.prepend(" ");
                                        }
                                        codeBuffer.addBytecodeMapping(root.getDummyExit().bytecode);
                                        buffer.append(codeBuffer, node.classStruct.qualifiedName, InterpreterUtil.makeUniqueKey(methodWrapper.methodStruct.getName(), methodWrapper.methodStruct.getDescriptor()));
                                    }
                                    catch (CancelationManager.CanceledException e) {
                                        throw e;
                                    }
                                    catch (Throwable ex) {
                                        DecompilerContext.getLogger().writeMessage("Method " + mt.getName() + " " + mt.getDescriptor() + " in class " + node.classStruct.qualifiedName + " couldn't be written.", IFernflowerLogger.Severity.WARN, ex);
                                        methodWrapper.decompileError = ex;
                                        buffer.append(" // $VF: Couldn't be decompiled");
                                    }
                                    finally {
                                        DecompilerContext.setProperty(DecompilerContext.CURRENT_METHOD_WRAPPER, outerWrapper);
                                    }
                                }
                            } else if (firstStat instanceof BasicBlockStatement && firstStat.getExprents() != null && firstStat.getExprents().isEmpty()) {
                                buffer.append(" {}");
                                simpleLambda = true;
                            }
                        }
                    }
                }
                if (!simpleLambda && !written || lambdaToAnonymous) {
                    buffer.append(" {").appendLineSeparator();
                    ClassWriter.methodLambdaToJava(node, wrapper, mt, buffer, indent + 1, !lambdaToAnonymous);
                    buffer.appendIndent(indent).append("}");
                }
            }
        }
        finally {
            DecompilerContext.setProperty(DecompilerContext.CURRENT_CLASS_NODE, outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    @Override
    public void writeClassHeader(StructClass cl, TextBuffer buffer, ImportCollector importCollector) {
        int index = cl.qualifiedName.lastIndexOf(47);
        if (index >= 0) {
            String packageName = cl.qualifiedName.substring(0, index).replace('/', '.');
            buffer.append("package ").append(packageName).append(';').appendLineSeparator().appendLineSeparator();
        }
        importCollector.writeImports(buffer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeClass(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent) {
        ClassesProcessor.ClassNode outerNode = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
        DecompilerContext.setProperty(DecompilerContext.CURRENT_CLASS_NODE, node);
        try {
            StructSourceFileAttribute sourceFileAttr;
            boolean ok = ClassWriter.invokeProcessors(buffer, node);
            if (!ok) {
                return;
            }
            ClassWrapper wrapper = node.getWrapper();
            StructClass cl = wrapper.getClassStruct();
            DecompilerContext.getLogger().startWriteClass(cl.qualifiedName);
            if (DecompilerContext.getOption("sourcefile-comments") && (sourceFileAttr = node.classStruct.getAttribute(StructGeneralAttribute.ATTRIBUTE_SOURCE_FILE)) != null) {
                ConstantPool pool = node.classStruct.getPool();
                String sourceFile = sourceFileAttr.getSourceFile(pool);
                buffer.appendIndent(indent).append("// $VF: Compiled from " + sourceFile).appendLineSeparator();
            }
            this.writeClassDefinition(node, buffer, indent);
            AtomicBoolean hasContent = new AtomicBoolean(false);
            Runnable haveContent = () -> {
                if (!hasContent.get() && node.type == ClassesProcessor.ClassNode.Type.ANONYMOUS) {
                    buffer.appendLineSeparator();
                }
                hasContent.set(true);
            };
            boolean enumFields = false;
            List<StructRecordComponent> components = cl.getRecordComponents();
            int maxEnumIdx = 0;
            for (int i = 0; i < cl.getFields().size(); ++i) {
                boolean isEnum;
                StructField fd = (StructField)cl.getFields().get(i);
                boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("decompile-enums");
                if (!isEnum) continue;
                maxEnumIdx = i;
            }
            ArrayList<StructField> deferredEnumFields = new ArrayList<StructField>();
            for (int i = 0; i < cl.getFields().size(); ++i) {
                boolean isEnum;
                StructField fd = (StructField)cl.getFields().get(i);
                boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("decompile-enums");
                if (i >= maxEnumIdx || isEnum) continue;
                deferredEnumFields.add(fd);
            }
            for (StructField fd : cl.getFields()) {
                boolean isEnum;
                boolean hide = fd.isSynthetic() && DecompilerContext.getOption("remove-synthetic") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) || deferredEnumFields.contains(fd);
                if (hide || components != null && fd.getAccessFlags() == 18 && components.stream().anyMatch(c -> c.getName().equals(fd.getName()) && c.getDescriptor().equals(fd.getDescriptor()))) continue;
                boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("decompile-enums");
                if (isEnum) {
                    if (enumFields) {
                        buffer.append(',').appendLineSeparator();
                    }
                    enumFields = true;
                } else if (enumFields) {
                    buffer.append(';');
                    buffer.appendLineSeparator();
                    buffer.appendLineSeparator();
                    enumFields = false;
                    for (StructField fd2 : deferredEnumFields) {
                        TextBuffer fieldBuffer = new TextBuffer();
                        this.writeField(wrapper, cl, fd2, fieldBuffer, indent + 1);
                        fieldBuffer.clearUnassignedBytecodeMappingData();
                        buffer.append(fieldBuffer);
                    }
                }
                TextBuffer fieldBuffer = new TextBuffer();
                this.writeField(wrapper, cl, fd, fieldBuffer, indent + 1);
                fieldBuffer.clearUnassignedBytecodeMappingData();
                haveContent.run();
                buffer.append(fieldBuffer);
            }
            if (enumFields) {
                buffer.append(';').appendLineSeparator();
                for (StructField fd2 : deferredEnumFields) {
                    TextBuffer fieldBuffer = new TextBuffer();
                    this.writeField(wrapper, cl, fd2, fieldBuffer, indent + 1);
                    fieldBuffer.clearUnassignedBytecodeMappingData();
                    buffer.append(fieldBuffer);
                }
            }
            VBStyleCollection<StructMethod, String> methods = cl.getMethods();
            for (int i = 0; i < methods.size(); ++i) {
                boolean methodSkipped;
                boolean hide;
                StructMethod mt = (StructMethod)methods.get(i);
                boolean bl = hide = mt.isSynthetic() && DecompilerContext.getOption("remove-synthetic") || mt.hasModifier(64) && DecompilerContext.getOption("remove-bridge") || wrapper.getHiddenMembers().contains(InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                if (hide) continue;
                TextBuffer methodBuffer = new TextBuffer();
                boolean bl2 = methodSkipped = !this.writeMethod(node, mt, i, methodBuffer, indent + 1);
                if (methodSkipped) continue;
                if (hasContent.get()) {
                    buffer.appendLineSeparator();
                }
                haveContent.run();
                buffer.append(methodBuffer);
            }
            for (ClassesProcessor.ClassNode inner : node.nested) {
                if (inner.type != ClassesProcessor.ClassNode.Type.MEMBER) continue;
                StructClass innerCl = inner.classStruct;
                boolean isSynthetic = (inner.access & 0x1000) != 0 || innerCl.isSynthetic();
                boolean hide = isSynthetic && DecompilerContext.getOption("remove-synthetic") || wrapper.getHiddenMembers().contains(innerCl.qualifiedName);
                if (hide) continue;
                if (hasContent.get()) {
                    buffer.appendLineSeparator();
                }
                TextBuffer clsBuffer = new TextBuffer();
                this.writeClass(inner, clsBuffer, indent + 1);
                haveContent.run();
                buffer.append(clsBuffer);
            }
            if (hasContent.get() || node.type != ClassesProcessor.ClassNode.Type.ANONYMOUS) {
                buffer.appendIndent(indent);
            }
            buffer.append('}');
            if (node.type != ClassesProcessor.ClassNode.Type.ANONYMOUS) {
                buffer.appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty(DecompilerContext.CURRENT_CLASS_NODE, outerNode);
        }
        DecompilerContext.getLogger().endWriteClass();
    }

    public static void packageInfoToJava(StructClass cl, TextBuffer buffer) {
        ClassWriter.appendAnnotations(buffer, 0, cl, -1);
        int index = cl.qualifiedName.lastIndexOf(47);
        String packageName = cl.qualifiedName.substring(0, index).replace('/', '.');
        buffer.append("package ").append(packageName).append(';').appendLineSeparator().appendLineSeparator();
    }

    public static void moduleInfoToJava(StructClass cl, TextBuffer buffer) {
        ClassWriter.appendAnnotations(buffer, 0, cl, -1);
        StructModuleAttribute moduleAttribute = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
        if ((moduleAttribute.moduleFlags & 0x20) != 0) {
            buffer.append("open ");
        }
        buffer.append("module ").append(moduleAttribute.moduleName).append(" {").appendLineSeparator();
        ClassWriter.writeModuleInfoBody(buffer, moduleAttribute);
        buffer.append('}').appendLineSeparator();
    }

    private static void writeModuleInfoBody(TextBuffer buffer, StructModuleAttribute moduleAttribute) {
        List<StructModuleAttribute.ProvidesEntry> list;
        List<String> list2;
        List<StructModuleAttribute.OpensEntry> list3;
        List<StructModuleAttribute.ExportsEntry> exportsEntries;
        boolean newLineNeeded = false;
        List<StructModuleAttribute.RequiresEntry> requiresEntries = moduleAttribute.requires;
        if (!requiresEntries.isEmpty()) {
            for (StructModuleAttribute.RequiresEntry requiresEntry : requiresEntries) {
                if (ClassWriter.isGenerated(requiresEntry.flags)) continue;
                buffer.appendIndent(1).append("requires ");
                if ((requiresEntry.flags & 0x20) != 0) {
                    buffer.append("transitive ");
                }
                if ((requiresEntry.flags & 0x40) != 0) {
                    buffer.append("static ");
                }
                buffer.append(requiresEntry.moduleName.replace('/', '.')).append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(exportsEntries = moduleAttribute.exports).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.ExportsEntry exportsEntry : exportsEntries) {
                if (ClassWriter.isGenerated(exportsEntry.flags)) continue;
                buffer.appendIndent(1).append("exports ").append(exportsEntry.packageName.replace('/', '.'));
                List<String> list4 = exportsEntry.exportToModules;
                if (list4.size() > 0) {
                    buffer.append(" to").appendLineSeparator();
                    ClassWriter.appendFQClassNames(buffer, list4);
                }
                buffer.append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(list3 = moduleAttribute.opens).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.OpensEntry opensEntry : list3) {
                if (ClassWriter.isGenerated(opensEntry.flags)) continue;
                buffer.appendIndent(1).append("opens ").append(opensEntry.packageName.replace('/', '.'));
                List<String> opensToModules = opensEntry.opensToModules;
                if (opensToModules.size() > 0) {
                    buffer.append(" to").appendLineSeparator();
                    ClassWriter.appendFQClassNames(buffer, opensToModules);
                }
                buffer.append(';').appendLineSeparator();
                newLineNeeded = true;
            }
        }
        if (!(list2 = moduleAttribute.uses).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (String uses : list2) {
                buffer.appendIndent(1).append("uses ").append(ExprProcessor.buildJavaClassName(uses)).append(';').appendLineSeparator();
            }
            newLineNeeded = true;
        }
        if (!(list = moduleAttribute.provides).isEmpty()) {
            if (newLineNeeded) {
                buffer.appendLineSeparator();
            }
            for (StructModuleAttribute.ProvidesEntry provides : list) {
                buffer.appendIndent(1).append("provides ").append(ExprProcessor.buildJavaClassName(provides.interfaceName)).append(" with").appendLineSeparator();
                ClassWriter.appendFQClassNames(buffer, provides.implementationNames.stream().map(ExprProcessor::buildJavaClassName).collect(Collectors.toList()));
                buffer.append(';').appendLineSeparator();
            }
        }
    }

    private static boolean isGenerated(int flags) {
        return (flags & 0x9000) != 0;
    }

    private void writeClassDefinition(ClassesProcessor.ClassNode node, TextBuffer buffer, int indent) {
        int[] interfaces;
        VarType supertype;
        List<StructRecordComponent> components;
        boolean isNonSealed;
        boolean markSynthetics = DecompilerContext.getOption("mark-corresponding-synthetics");
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        if (node.type == ClassesProcessor.ClassNode.Type.ANONYMOUS) {
            if (markSynthetics) {
                ClassWriter.appendSyntheticClassComment(cl, buffer);
            }
            buffer.append(" {");
            return;
        }
        int flags = node.type == ClassesProcessor.ClassNode.Type.ROOT ? cl.getAccessFlags() : node.access;
        boolean isDeprecated = cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean isSynthetic = (flags & 0x1000) != 0 || cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
        boolean isEnum = DecompilerContext.getOption("decompile-enums") && (flags & 0x4000) != 0;
        boolean isInterface = (flags & 0x200) != 0;
        boolean isAnnotation = (flags & 0x2000) != 0;
        boolean isModuleInfo = (flags & 0x8000) != 0 && cl.hasAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
        StructPermittedSubclassesAttribute permittedSubClassesAttr = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_PERMITTED_SUBCLASSES);
        List<Object> permittedSubClasses = permittedSubClassesAttr != null ? permittedSubClassesAttr.getClasses() : Collections.emptyList();
        boolean isSealed = permittedSubClassesAttr != null && !permittedSubClasses.isEmpty();
        boolean isFinal = (flags & 0x10) != 0;
        boolean bl = isNonSealed = !isSealed && !isFinal && cl.getVersion().hasSealedClasses() && ClassWriter.isSuperClassSealed(cl);
        if (isDeprecated && !ClassWriter.containsDeprecatedAnnotation(cl)) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName);
            ClassWriter.appendRenameComment(buffer, oldName, MType.CLASS, indent);
        }
        if (isSynthetic) {
            ClassWriter.appendComment(buffer, "synthetic class", indent);
        }
        if (this.javadocProvider != null) {
            ClassWriter.appendJavadoc(buffer, this.javadocProvider.getClassDoc(cl), indent);
        }
        ClassWriter.appendAnnotations(buffer, indent, cl, -1);
        buffer.appendIndent(indent);
        if (isEnum) {
            flags &= 0xFFFFFBFF;
            flags &= 0xFFFFFFEF;
            if (node.type == ClassesProcessor.ClassNode.Type.LOCAL) {
                flags &= 0xFFFFFFF7;
            }
        }
        if ((components = cl.getRecordComponents()) != null) {
            flags &= 0xFFFFFFEF;
            flags &= 0xFFFFFFF7;
        }
        ClassWriter.appendModifiers(buffer, flags, 3103, isInterface, 1032);
        if (!isEnum && isSealed) {
            buffer.append("sealed ");
        } else if (isNonSealed) {
            buffer.append("non-sealed ");
        }
        if (isEnum) {
            buffer.append("enum ");
        } else if (isInterface) {
            if (isAnnotation) {
                buffer.append('@');
            }
            buffer.append("interface ");
        } else if (isModuleInfo) {
            StructModuleAttribute moduleAttribute = cl.getAttribute(StructGeneralAttribute.ATTRIBUTE_MODULE);
            if ((moduleAttribute.moduleFlags & 0x20) != 0) {
                buffer.append("open ");
            }
            buffer.append("module ");
            buffer.append(moduleAttribute.moduleName);
        } else if (components != null) {
            buffer.append("record ");
        } else {
            buffer.append("class ");
        }
        buffer.appendClass(node.simpleName, true, cl.qualifiedName);
        GenericClassDescriptor descriptor = cl.getSignature();
        if (descriptor != null && !descriptor.fparameters.isEmpty()) {
            ClassWriter.appendTypeParameters(buffer, descriptor.fparameters, descriptor.fbounds);
        }
        if (components != null) {
            buffer.append('(');
            RecordHelper.appendRecordComponents(buffer, cl, components, indent);
            buffer.append(')');
        }
        buffer.pushNewlineGroup(indent, 1);
        if (!(isEnum || isInterface || components != null || cl.superClass == null || VarType.VARTYPE_OBJECT.equals(supertype = new VarType(cl.superClass.getString(), true)))) {
            buffer.appendPossibleNewline(" ");
            buffer.append("extends ");
            buffer.appendCastTypeName(descriptor == null ? supertype : descriptor.superclass);
        }
        if (!isAnnotation && (interfaces = cl.getInterfaces()).length > 0) {
            buffer.appendPossibleNewline(" ");
            buffer.append(isInterface ? "extends " : "implements ");
            for (int i = 0; i < interfaces.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                    buffer.appendPossibleNewline(" ");
                }
                if (descriptor != null && descriptor.superinterfaces.size() <= i) continue;
                buffer.appendCastTypeName(descriptor == null ? new VarType(cl.getInterface(i), true) : descriptor.superinterfaces.get(i));
            }
        }
        if (!isEnum && isSealed) {
            buffer.appendPossibleNewline(" ");
            buffer.append("permits ");
            for (int i = 0; i < permittedSubClasses.size(); ++i) {
                if (i > 0) {
                    buffer.append(",");
                    buffer.appendPossibleNewline(" ");
                }
                buffer.appendCastTypeName(new VarType((String)permittedSubClasses.get(i), true));
            }
        }
        buffer.popNewlineGroup();
        if (markSynthetics && node.type == ClassesProcessor.ClassNode.Type.LOCAL) {
            ClassWriter.appendSyntheticClassComment(cl, buffer);
        }
        buffer.append(" {").appendLineSeparator();
    }

    private static boolean isSuperClassSealed(StructClass cl) {
        StructClass superClass;
        if (cl.superClass != null && (superClass = DecompilerContext.getStructContext().getClass((String)cl.superClass.value)) != null && superClass.hasAttribute(StructGeneralAttribute.ATTRIBUTE_PERMITTED_SUBCLASSES)) {
            return true;
        }
        for (String iface : cl.getInterfaceNames()) {
            StructClass ifaceClass = DecompilerContext.getStructContext().getClass(iface);
            if (ifaceClass == null || !ifaceClass.hasAttribute(StructGeneralAttribute.ATTRIBUTE_PERMITTED_SUBCLASSES)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeField(ClassWrapper wrapper, StructClass cl, StructField fd, TextBuffer buffer, int indent) {
        StructConstantValueAttribute attr;
        String newName;
        boolean isEnum;
        if (RecordHelper.isHiddenRecordField(cl.getRecordComponents(), fd)) {
            return;
        }
        boolean isInterface = cl.hasModifier(512);
        boolean isDeprecated = fd.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
        boolean bl = isEnum = fd.hasModifier(16384) && DecompilerContext.getOption("decompile-enums");
        if (isDeprecated && !ClassWriter.containsDeprecatedAnnotation(fd)) {
            ClassWriter.appendDeprecation(buffer, indent);
        }
        String name = fd.getName();
        if (this.interceptor != null && (newName = this.interceptor.getName(cl.qualifiedName + " " + fd.getName() + " " + fd.getDescriptor())) != null) {
            name = newName.split(" ")[1];
        }
        if (this.interceptor != null) {
            String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + name + " " + fd.getDescriptor());
            ClassWriter.appendRenameComment(buffer, oldName, MType.FIELD, indent);
        }
        if (fd.isSynthetic()) {
            ClassWriter.appendComment(buffer, "synthetic field", indent);
        }
        if (this.javadocProvider != null) {
            ClassWriter.appendJavadoc(buffer, this.javadocProvider.getFieldDoc(cl, fd), indent);
        }
        ClassWriter.appendAnnotations(buffer, indent, fd, 19);
        buffer.appendIndent(indent);
        if (!isEnum) {
            ClassWriter.appendModifiers(buffer, fd.getAccessFlags(), 223, isInterface, 25);
        }
        Map.Entry<VarType, GenericFieldDescriptor> fieldTypeData = ClassWriter.getFieldTypeData(fd);
        VarType fieldType = fieldTypeData.getKey();
        GenericFieldDescriptor descriptor = fieldTypeData.getValue();
        if (!isEnum) {
            buffer.appendCastTypeName(descriptor == null ? fieldType : descriptor.type);
            buffer.append(' ');
        }
        buffer.appendField(name, true, cl.qualifiedName, name, fd.getDescriptor());
        Exprent initializer = fd.hasModifier(8) ? wrapper.getStaticFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor())) : wrapper.getDynamicFieldInitializers().getWithKey(InterpreterUtil.makeUniqueKey(fd.getName(), fd.getDescriptor()));
        if (initializer != null) {
            if (isEnum && initializer instanceof NewExprent) {
                NewExprent expr = (NewExprent)initializer;
                expr.setEnumConst(true);
                buffer.append(expr.toJava(indent));
            } else {
                buffer.append(" = ");
                if (initializer instanceof ConstExprent) {
                    ((ConstExprent)initializer).adjustConstType(fieldType);
                }
                ExprProcessor.getCastedExprent(initializer, descriptor == null ? fieldType : descriptor.type, buffer, indent, false);
            }
        } else if (fd.hasModifier(16) && fd.hasModifier(8) && (attr = fd.getAttribute(StructGeneralAttribute.ATTRIBUTE_CONSTANT_VALUE)) != null) {
            PrimitiveConstant constant = cl.getPool().getPrimitiveConstant(attr.getIndex());
            buffer.append(" = ");
            buffer.append(new ConstExprent(fieldType, constant.value, null).toJava(indent));
        }
        if (!isEnum) {
            buffer.append(";").appendLineSeparator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void methodLambdaToJava(ClassesProcessor.ClassNode lambdaNode, ClassWrapper classWrapper, StructMethod mt, TextBuffer buffer, int indent, boolean codeOnly) {
        MethodWrapper methodWrapper = classWrapper.getMethodWrapper(mt.getName(), mt.getDescriptor());
        MethodWrapper outerWrapper = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
        DecompilerContext.setProperty(DecompilerContext.CURRENT_METHOD_WRAPPER, methodWrapper);
        try {
            String method_name = lambdaNode.lambdaInformation.method_name;
            MethodDescriptor md_content = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.content_method_descriptor);
            MethodDescriptor md_lambda = MethodDescriptor.parseDescriptor(lambdaNode.lambdaInformation.method_descriptor);
            if (!codeOnly) {
                buffer.appendIndent(indent);
                buffer.append("public ");
                buffer.append(method_name);
                buffer.append("(");
                boolean firstParameter = true;
                int index = lambdaNode.lambdaInformation.is_content_method_static ? 0 : 1;
                int start_index = md_content.params.length - md_lambda.params.length;
                for (int i = 0; i < md_content.params.length; ++i) {
                    if (i >= start_index) {
                        VarType type;
                        String typeName;
                        if (!firstParameter) {
                            buffer.append(", ");
                        }
                        if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName(type = md_content.params[i])) && DecompilerContext.getOption("undefined-as-object")) {
                            typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT);
                        }
                        buffer.appendCastTypeName(typeName, type);
                        buffer.append(" ");
                        Object parameterName = methodWrapper.varproc.getVarName(new VarVersionPair(index, 0));
                        if (parameterName == null) {
                            parameterName = "param" + index;
                        }
                        parameterName = methodWrapper.methodStruct.getVariableNamer().renameParameter(mt.getAccessFlags(), type, (String)parameterName, index);
                        buffer.appendVariable((String)parameterName, true, true, classWrapper.getClassStruct().qualifiedName, method_name, md_content, index, (String)parameterName);
                        firstParameter = false;
                    }
                    index += md_content.params[i].stackSize;
                }
                buffer.append(") {").appendLineSeparator();
                ++indent;
            }
            RootStatement root = classWrapper.getMethodWrapper((String)mt.getName(), (String)mt.getDescriptor()).root;
            if (methodWrapper.decompileError == null && root != null) {
                try {
                    TextBuffer childBuf = root.toJava(indent);
                    childBuf.addBytecodeMapping(root.getDummyExit().bytecode);
                    buffer.append(childBuf, classWrapper.getClassStruct().qualifiedName, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                }
                catch (CancelationManager.CanceledException e) {
                    throw e;
                }
                catch (Throwable t) {
                    String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " in class " + lambdaNode.classStruct.qualifiedName + " couldn't be written.";
                    DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                    methodWrapper.decompileError = t;
                }
            }
            if (methodWrapper.decompileError != null) {
                ClassWriter.dumpError(buffer, methodWrapper, indent);
            }
            if (!codeOnly) {
                buffer.appendIndent(--indent).append('}').appendLineSeparator();
            }
        }
        finally {
            DecompilerContext.setProperty(DecompilerContext.CURRENT_METHOD_WRAPPER, outerWrapper);
        }
    }

    private static String toValidJavaIdentifier(String name) {
        if (name == null || name.isEmpty()) {
            return name;
        }
        boolean changed = false;
        StringBuilder res = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(c) || i > 0 && !Character.isJavaIdentifierPart(c)) {
                changed = true;
                res.append("_");
                continue;
            }
            res.append(c);
        }
        if (!changed) {
            return name;
        }
        return res.append("/* $VF was: ").append(name).append("*/").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeMethod(ClassesProcessor.ClassNode node, StructMethod mt, int methodIndex, TextBuffer buffer, int indent) {
        boolean hideMethod;
        block54: {
            ClassWrapper wrapper = node.getWrapper();
            StructClass cl = wrapper.getClassStruct();
            MethodWrapper methodWrapper = wrapper.getMethodWrapper(methodIndex);
            hideMethod = false;
            MethodWrapper outerWrapper = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_METHOD_WRAPPER);
            DecompilerContext.setProperty(DecompilerContext.CURRENT_METHOD_WRAPPER, methodWrapper);
            try {
                boolean shouldApplyOverride;
                boolean isBridge;
                String newName;
                boolean isInterface = cl.hasModifier(512);
                boolean isAnnotation = cl.hasModifier(8192);
                boolean isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("decompile-enums");
                boolean isDeprecated = mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_DEPRECATED);
                boolean clInit = false;
                boolean init = false;
                boolean dInit = false;
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mt, node);
                int flags = mt.getAccessFlags();
                if ((flags & 0x100) != 0) {
                    flags &= 0xFFFFF7FF;
                }
                if ("<clinit>".equals(mt.getName())) {
                    flags &= 8;
                }
                if (isDeprecated && !ClassWriter.containsDeprecatedAnnotation(mt)) {
                    ClassWriter.appendDeprecation(buffer, indent);
                }
                String name = mt.getName();
                if (this.interceptor != null && (newName = this.interceptor.getName(cl.qualifiedName + " " + mt.getName() + " " + mt.getDescriptor())) != null) {
                    name = newName.split(" ")[1];
                }
                if (this.interceptor != null) {
                    String oldName = this.interceptor.getOldName(cl.qualifiedName + " " + name + " " + mt.getDescriptor());
                    ClassWriter.appendRenameComment(buffer, oldName, MType.METHOD, indent);
                }
                boolean isSynthetic = (flags & 0x1000) != 0 || mt.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
                boolean bl = isBridge = (flags & 0x40) != 0;
                if (isSynthetic) {
                    ClassWriter.appendComment(buffer, "synthetic method", indent);
                }
                if (isBridge) {
                    ClassWriter.appendComment(buffer, "bridge method", indent);
                }
                if (DecompilerContext.getOption("decompiler-comments") && methodWrapper.addErrorComment || methodWrapper.commentLines != null) {
                    if (methodWrapper.addErrorComment) {
                        for (String s : ClassWriter.getErrorComment()) {
                            methodWrapper.addComment(s);
                        }
                    }
                    for (String s : methodWrapper.commentLines) {
                        buffer.appendIndent(indent).append("// " + s).appendLineSeparator();
                    }
                }
                if (this.javadocProvider != null) {
                    ClassWriter.appendJavadoc(buffer, this.javadocProvider.getMethodDoc(cl, mt), indent);
                }
                ClassWriter.appendAnnotations(buffer, indent, mt, 20);
                StructAnnotationAttribute annotationAttribute = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_RUNTIME_VISIBLE_ANNOTATIONS);
                boolean bl2 = shouldApplyOverride = DecompilerContext.getOption("override-annotation") && mt.getBytecodeVersion().hasOverride() && !"<init>".equals(mt.getName()) && !"<clinit>".equals(mt.getName()) && !mt.hasModifier(8) && !mt.hasModifier(2);
                if (shouldApplyOverride) {
                    boolean alreadyHasOverride;
                    boolean isOverride = ClassWriter.searchForMethod(cl, mt.getName(), md, false);
                    boolean bl3 = alreadyHasOverride = annotationAttribute != null && annotationAttribute.getAnnotations().stream().anyMatch(annotation -> "java/lang/Override".equals(annotation.getClassName()));
                    if (isOverride && !alreadyHasOverride) {
                        buffer.appendIndent(indent);
                        buffer.append("@Override");
                        buffer.appendLineSeparator();
                    }
                }
                buffer.appendIndent(indent);
                if ("<init>".equals(name)) {
                    if (node.type == ClassesProcessor.ClassNode.Type.ANONYMOUS) {
                        name = "";
                        dInit = true;
                    } else {
                        name = node.simpleName;
                        init = true;
                    }
                } else if ("<clinit>".equals(name)) {
                    name = "";
                    clInit = true;
                }
                if (!dInit) {
                    ClassWriter.appendModifiers(buffer, flags, 3391, isInterface, 1025);
                }
                if (isInterface && !mt.hasModifier(8) && mt.containsCode() && (flags & 2) == 0) {
                    buffer.append("default ");
                }
                GenericMethodDescriptor descriptor = mt.getSignature();
                boolean throwsExceptions = false;
                int paramCount = 0;
                if (!clInit && !dInit) {
                    StructMethodParametersAttribute attr;
                    boolean thisVar;
                    boolean bl4 = thisVar = !mt.hasModifier(8);
                    if (descriptor != null && !descriptor.typeParameters.isEmpty()) {
                        ClassWriter.appendTypeParameters(buffer, descriptor.typeParameters, descriptor.typeParameterBounds);
                        buffer.append(' ');
                    }
                    if (!init) {
                        buffer.appendCastTypeName(descriptor == null ? md.ret : descriptor.returnType);
                        buffer.append(' ');
                    }
                    buffer.appendMethod(ClassWriter.toValidJavaIdentifier(name), true, cl.qualifiedName, mt.getName(), md);
                    buffer.append('(');
                    List<VarVersionPair> mask = methodWrapper.synthParameters;
                    int lastVisibleParameterIndex = -1;
                    for (int i = 0; i < md.params.length; ++i) {
                        if (mask != null && mask.get(i) != null) continue;
                        lastVisibleParameterIndex = i;
                    }
                    if (lastVisibleParameterIndex != -1) {
                        buffer.pushNewlineGroup(indent, 1);
                        buffer.appendPossibleNewline();
                    }
                    List<StructMethodParametersAttribute.Entry> methodParameters = null;
                    if (DecompilerContext.getOption("use-method-parameters") && (attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_METHOD_PARAMETERS)) != null) {
                        methodParameters = attr.getEntries();
                    }
                    int index = isEnum && init ? 3 : (thisVar ? 1 : 0);
                    int start = isEnum && init ? 2 : 0;
                    boolean hasDescriptor = descriptor != null;
                    buffer.pushNewlineGroup(indent, 0);
                    for (int i = start; i < md.params.length; ++i) {
                        VarType parameterType;
                        boolean real = mask == null || mask.get(i) == null;
                        VarType varType = parameterType = real && hasDescriptor && paramCount < descriptor.parameterTypes.size() ? descriptor.parameterTypes.get(paramCount) : md.params[i];
                        if (real) {
                            String typeName;
                            boolean isVarArg;
                            if (paramCount > 0) {
                                buffer.append(",");
                                buffer.appendPossibleNewline(" ");
                            }
                            ClassWriter.appendParameterAnnotations(buffer, mt, paramCount);
                            if (methodParameters != null && i < methodParameters.size()) {
                                ClassWriter.appendModifiers(buffer, methodParameters.get((int)i).myAccessFlags, 16, isInterface, 0);
                            } else if (methodWrapper.varproc.getVarFinal(new VarVersionPair(index, 0)) == VarTypeProcessor.FinalType.EXPLICIT_FINAL) {
                                buffer.append("final ");
                            }
                            boolean bl5 = isVarArg = i == lastVisibleParameterIndex && mt.hasModifier(128) && parameterType.arrayDim > 0;
                            if (isVarArg) {
                                parameterType = parameterType.decreaseArrayDim();
                            }
                            if ("<undefinedtype>".equals(typeName = ExprProcessor.getCastTypeName(parameterType)) && DecompilerContext.getOption("undefined-as-object")) {
                                typeName = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT);
                            }
                            buffer.appendCastTypeName(typeName, parameterType);
                            if (isVarArg) {
                                buffer.append("...");
                            }
                            buffer.append(' ');
                            String clashingName = methodWrapper.varproc.getClashingName(new VarVersionPair(index, 0));
                            String parameterName = clashingName != null ? clashingName : (methodParameters != null && i < methodParameters.size() && methodParameters.get((int)i).myName != null ? methodParameters.get((int)i).myName : methodWrapper.varproc.getVarName(new VarVersionPair(index, 0)));
                            String newParameterName = methodWrapper.methodStruct.getVariableNamer().renameParameter(flags, parameterType, parameterName, index);
                            if ((flags & 0x500) != 0 && Objects.equals(newParameterName, parameterName)) {
                                newParameterName = DecompilerContext.getStructContext().renameAbstractParameter(methodWrapper.methodStruct.getClassQualifiedName(), mt.getName(), mt.getDescriptor(), index - ((flags & 8) == 0 ? 1 : 0), parameterName);
                            }
                            buffer.appendVariable((String)((parameterName = newParameterName) == null ? "param" + index : parameterName), true, true, cl.qualifiedName, mt.getName(), md, index, parameterName);
                            ++paramCount;
                        }
                        index += parameterType.stackSize;
                    }
                    buffer.popNewlineGroup();
                    if (lastVisibleParameterIndex != -1) {
                        buffer.appendPossibleNewline("", true);
                        buffer.popNewlineGroup();
                    }
                    buffer.append(')');
                    StructExceptionsAttribute attr2 = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_EXCEPTIONS);
                    if (descriptor != null && !descriptor.exceptionTypes.isEmpty() || attr2 != null) {
                        throwsExceptions = true;
                        buffer.append(" throws ");
                        boolean useDescriptor = descriptor != null && !descriptor.exceptionTypes.isEmpty();
                        for (int i = 0; i < (attr2 == null ? descriptor.exceptionTypes.size() : attr2.getThrowsExceptions().size()); ++i) {
                            if (i > 0) {
                                buffer.append(", ");
                            }
                            VarType type = useDescriptor ? descriptor.exceptionTypes.get(i) : new VarType(attr2.getExcClassname(i, cl.getPool()), true);
                            buffer.appendCastTypeName(type);
                        }
                    }
                }
                if ((flags & 0x500) != 0) {
                    StructAnnDefaultAttribute attr;
                    if (isAnnotation && (attr = mt.getAttribute(StructGeneralAttribute.ATTRIBUTE_ANNOTATION_DEFAULT)) != null) {
                        buffer.append(" default ");
                        buffer.append(attr.getDefaultValue().toJava(0));
                    }
                    buffer.append(';');
                    buffer.appendLineSeparator();
                    break block54;
                }
                if (!clInit && !dInit) {
                    buffer.append(' ');
                }
                buffer.append('{').appendLineSeparator();
                RootStatement root = methodWrapper.root;
                if (root != null && methodWrapper.decompileError == null) {
                    try {
                        if (RecordHelper.isHiddenRecordMethod(cl, mt, root)) {
                            hideMethod = true;
                        } else {
                            TextBuffer code = root.toJava(indent + 1);
                            code.addBytecodeMapping(root.getDummyExit().bytecode);
                            hideMethod = code.length() == 0 && (clInit || dInit || ClassWriter.hideConstructor(node, init, throwsExceptions, paramCount, flags));
                            buffer.append(code, cl.qualifiedName, InterpreterUtil.makeUniqueKey(mt.getName(), mt.getDescriptor()));
                        }
                    }
                    catch (CancelationManager.CanceledException e) {
                        throw e;
                    }
                    catch (Throwable t) {
                        String message = "Method " + mt.getName() + " " + mt.getDescriptor() + " in class " + node.classStruct.qualifiedName + " couldn't be written.";
                        DecompilerContext.getLogger().writeMessage(message, IFernflowerLogger.Severity.WARN, t);
                        methodWrapper.decompileError = t;
                    }
                }
                if (methodWrapper.decompileError != null) {
                    ClassWriter.dumpError(buffer, methodWrapper, indent + 1);
                }
                buffer.appendIndent(indent).append('}').appendLineSeparator();
            }
            finally {
                DecompilerContext.setProperty(DecompilerContext.CURRENT_METHOD_WRAPPER, outerWrapper);
            }
        }
        return !hideMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpError(TextBuffer buffer, MethodWrapper wrapper, int indent) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("$VF: Couldn't be decompiled");
        boolean exceptions = DecompilerContext.getOption("dump-exception-on-error");
        boolean bytecode = DecompilerContext.getOption("dump-bytecode-on-error");
        if (exceptions) {
            lines.addAll(ClassWriter.getErrorComment());
            ClassWriter.collectErrorLines(wrapper.decompileError, lines);
            if (bytecode) {
                lines.add("");
            }
        }
        if (bytecode) {
            try {
                lines.add("Bytecode:");
                ClassWriter.collectBytecode(wrapper, lines);
            }
            catch (Exception e) {
                lines.add("Error collecting bytecode:");
                ClassWriter.collectErrorLines(e, lines);
            }
            finally {
                wrapper.methodStruct.releaseResources();
            }
        }
        for (String line : lines) {
            buffer.appendIndent(indent);
            buffer.append("//");
            if (!line.isEmpty()) {
                buffer.append(' ').append(line);
            }
            buffer.appendLineSeparator();
        }
    }

    public static void collectErrorLines(Throwable error, List<String> lines) {
        StackTraceElement[] stack = error.getStackTrace();
        ArrayList<StackTraceElement> filteredStack = new ArrayList<StackTraceElement>();
        boolean hasSeenOwnClass = false;
        for (StackTraceElement e : stack) {
            String simpleName;
            String className = e.getClassName();
            boolean isOwnClass = className.startsWith("org.jetbrains.java.decompiler");
            if (isOwnClass) {
                hasSeenOwnClass = true;
            } else if (hasSeenOwnClass) break;
            filteredStack.add(e);
            if (isOwnClass && ERROR_DUMP_STOP_POINTS.contains((simpleName = className.substring(className.lastIndexOf(46) + 1)) + "." + e.getMethodName())) break;
        }
        if (filteredStack.isEmpty()) {
            return;
        }
        lines.add(error.toString());
        for (StackTraceElement e : filteredStack) {
            lines.add("  at " + String.valueOf(e));
        }
        Throwable cause = error.getCause();
        if (cause != null) {
            ArrayList<String> causeLines = new ArrayList<String>();
            ClassWriter.collectErrorLines(cause, causeLines);
            if (!causeLines.isEmpty()) {
                lines.add("Caused by: " + (String)causeLines.get(0));
                lines.addAll(causeLines.subList(1, causeLines.size()));
            }
        }
    }

    private static void collectBytecode(MethodWrapper wrapper, List<String> lines) throws IOException {
        ClassesProcessor.ClassNode classNode = DecompilerContext.getContextProperty(DecompilerContext.CURRENT_CLASS_NODE);
        StructMethod method = wrapper.methodStruct;
        InstructionSequence instructions = method.getInstructionSequence();
        if (instructions == null) {
            method.expandData(classNode.classStruct);
            instructions = method.getInstructionSequence();
        }
        int lastOffset = instructions.getOffset(instructions.length() - 1);
        int digits = 8 - Integer.numberOfLeadingZeros(lastOffset) / 4;
        ConstantPool pool = classNode.classStruct.getPool();
        StructBootstrapMethodsAttribute bootstrap = classNode.classStruct.getAttribute(StructGeneralAttribute.ATTRIBUTE_BOOTSTRAP_METHODS);
        for (int idx = 0; idx < instructions.length(); ++idx) {
            int i;
            int offset = instructions.getOffset(idx);
            Instruction instr = instructions.getInstr(idx);
            StringBuilder sb = new StringBuilder();
            String offHex = Integer.toHexString(offset);
            for (i = offHex.length(); i < digits; ++i) {
                sb.append('0');
            }
            sb.append(offHex).append(": ");
            if (instr.wide) {
                sb.append("wide ");
            }
            sb.append(TextUtil.getInstructionName(instr.opcode));
            block0 : switch (instr.group) {
                case 4: {
                    sb.append(' ');
                    if (instr.opcode == 186 && bootstrap != null) {
                        ClassWriter.appendBootstrapCall(sb, pool.getLinkConstant(instr.operand(0)), bootstrap);
                    } else {
                        ClassWriter.appendConstant(sb, pool.getConstant(instr.operand(0)));
                    }
                    for (i = 1; i < instr.operandsCount(); ++i) {
                        sb.append(' ').append(instr.operand(i));
                    }
                    break;
                }
                case 5: {
                    sb.append(' ');
                    ClassWriter.appendConstant(sb, pool.getConstant(instr.operand(0)));
                    break;
                }
                case 2: {
                    sb.append(' ');
                    int dest = offset + instr.operand(0);
                    String destHex = Integer.toHexString(dest);
                    for (int i2 = destHex.length(); i2 < digits; ++i2) {
                        sb.append('0');
                    }
                    sb.append(destHex);
                    break;
                }
                default: {
                    switch (instr.opcode) {
                        case 18: 
                        case 19: 
                        case 20: 
                        case 187: 
                        case 192: 
                        case 193: {
                            sb.append(' ');
                            PooledConstant constant = pool.getConstant(instr.operand(0));
                            if (constant.type == 17 && bootstrap != null) {
                                ClassWriter.appendBootstrapCall(sb, (LinkConstant)constant, bootstrap);
                                break block0;
                            }
                            ClassWriter.appendConstant(sb, constant);
                            break block0;
                        }
                    }
                    for (i = 0; i < instr.operandsCount(); ++i) {
                        sb.append(' ').append(instr.operand(i));
                    }
                }
            }
            lines.add(sb.toString());
        }
    }

    private static void appendBootstrapCall(StringBuilder sb, LinkConstant target, StructBootstrapMethodsAttribute bootstrap) {
        sb.append(target.elementname).append(' ').append(target.descriptor);
        LinkConstant bsm = bootstrap.getMethodReference(target.index1);
        List<PooledConstant> bsmArgs = bootstrap.getMethodArguments(target.index1);
        sb.append(" bsm=");
        ClassWriter.appendConstant(sb, bsm);
        sb.append(" args=[ ");
        boolean first = true;
        for (PooledConstant arg : bsmArgs) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            ClassWriter.appendConstant(sb, arg);
        }
        sb.append(" ]");
    }

    private static void appendConstant(StringBuilder sb, PooledConstant constant) {
        if (constant == null) {
            sb.append("<null constant>");
            return;
        }
        if (constant instanceof PrimitiveConstant) {
            PrimitiveConstant prim = (PrimitiveConstant)constant;
            Object value = prim.value;
            String stringValue = String.valueOf(value);
            if (prim.type == 7) {
                sb.append(stringValue);
            } else if (prim.type == 8) {
                sb.append('\"').append(ConstExprent.convertStringToJava(stringValue, false)).append('\"');
            } else {
                sb.append(stringValue);
            }
        } else if (constant instanceof LinkConstant) {
            LinkConstant linkConstant = (LinkConstant)constant;
            sb.append(linkConstant.classname).append('.').append(linkConstant.elementname).append(' ').append(linkConstant.descriptor);
        }
    }

    private static boolean hideConstructor(ClassesProcessor.ClassNode node, boolean init, boolean throwsExceptions, int paramCount, int methodAccessFlags) {
        boolean isEnum;
        if (!init || throwsExceptions || paramCount > 0 || !DecompilerContext.getOption("hide-default-constructor")) {
            return false;
        }
        ClassWrapper wrapper = node.getWrapper();
        StructClass cl = wrapper.getClassStruct();
        int classAccessFlags = node.type == ClassesProcessor.ClassNode.Type.ROOT ? cl.getAccessFlags() : node.access;
        boolean bl = isEnum = cl.hasModifier(16384) && DecompilerContext.getOption("decompile-enums");
        if (!isEnum && (classAccessFlags & 7) != (methodAccessFlags & 7)) {
            return false;
        }
        int count = 0;
        for (StructMethod mt : cl.getMethods()) {
            if (!"<init>".equals(mt.getName()) || ++count <= 1) continue;
            return false;
        }
        return true;
    }

    private static Map.Entry<VarType, GenericFieldDescriptor> getFieldTypeData(StructField fd) {
        VarType fieldType = new VarType(fd.getDescriptor(), false);
        GenericFieldDescriptor descriptor = fd.getSignature();
        return new AbstractMap.SimpleImmutableEntry<VarType, GenericFieldDescriptor>(fieldType, descriptor);
    }

    private static boolean containsDeprecatedAnnotation(StructMember mb) {
        for (Key<?> key : ANNOTATION_ATTRIBUTES) {
            StructAnnotationAttribute attribute = (StructAnnotationAttribute)mb.getAttribute(key);
            if (attribute == null) continue;
            for (AnnotationExprent annotation : attribute.getAnnotations()) {
                if (!annotation.getClassName().equals("java/lang/Deprecated")) continue;
                return true;
            }
        }
        return false;
    }

    private static void appendDeprecation(TextBuffer buffer, int indent) {
        buffer.appendIndent(indent).append("/** @deprecated */").appendLineSeparator();
    }

    private static void appendRenameComment(TextBuffer buffer, String oldName, MType type, int indent) {
        if (oldName == null) {
            return;
        }
        buffer.appendIndent(indent);
        buffer.append("// $VF: renamed from: ");
        switch (type) {
            case CLASS: {
                buffer.append(ExprProcessor.buildJavaClassName(oldName));
                break;
            }
            case FIELD: {
                String[] fParts = oldName.split(" ");
                FieldDescriptor fd = FieldDescriptor.parseDescriptor(fParts[2]);
                buffer.append(fParts[1]);
                buffer.append(' ');
                buffer.append(ClassWriter.getTypePrintOut(fd.type));
                break;
            }
            default: {
                String[] mParts = oldName.split(" ");
                MethodDescriptor md = MethodDescriptor.parseDescriptor(mParts[2]);
                buffer.append(mParts[1]);
                buffer.append(" (");
                boolean first = true;
                for (VarType paramType : md.params) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(ClassWriter.getTypePrintOut(paramType));
                }
                buffer.append(") ");
                buffer.append(ClassWriter.getTypePrintOut(md.ret));
            }
        }
        buffer.appendLineSeparator();
    }

    private static String getTypePrintOut(VarType type) {
        String typeText = ExprProcessor.getCastTypeName(type, false);
        if ("<undefinedtype>".equals(typeText) && DecompilerContext.getOption("undefined-as-object")) {
            typeText = ExprProcessor.getCastTypeName(VarType.VARTYPE_OBJECT, false);
        }
        return typeText;
    }

    public static List<String> getErrorComment() {
        return Arrays.stream(((String)DecompilerContext.getProperty("error-message")).split("\n")).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }

    private static void appendComment(TextBuffer buffer, String comment, int indent) {
        buffer.appendIndent(indent).append("// $VF: ").append(comment).appendLineSeparator();
    }

    private static void appendJavadoc(TextBuffer buffer, String javaDoc, int indent) {
        if (javaDoc == null) {
            return;
        }
        buffer.appendIndent(indent).append("/**").appendLineSeparator();
        for (String s : javaDoc.split("\n")) {
            buffer.appendIndent(indent).append(" * ").append(s).appendLineSeparator();
        }
        buffer.appendIndent(indent).append(" */").appendLineSeparator();
    }

    public static void appendSyntheticClassComment(StructClass cl, TextBuffer buffer) {
        String className = cl.qualifiedName.substring(cl.qualifiedName.lastIndexOf("/") + 1);
        buffer.append(" /* ").appendClass(className, true, cl.qualifiedName).append(" */");
    }

    static void appendAnnotations(TextBuffer buffer, int indent, StructMember mb, int targetType) {
        HashSet<String> filter = new HashSet<String>();
        for (Key<?> key : ANNOTATION_ATTRIBUTES) {
            StructAnnotationAttribute attribute = (StructAnnotationAttribute)mb.getAttribute(key);
            if (attribute == null) continue;
            for (AnnotationExprent annotation : attribute.getAnnotations()) {
                buffer.appendIndent(indent);
                TextBuffer text = annotation.toJava(indent);
                filter.add(text.convertToStringAndAllowDataDiscard());
                buffer.appendText(text);
                if (indent < 0) {
                    buffer.append(' ');
                    continue;
                }
                buffer.appendLineSeparator();
            }
        }
        ClassWriter.appendTypeAnnotations(buffer, indent, mb, targetType, -1, filter);
    }

    private static boolean searchForMethod(StructClass cl, String name, MethodDescriptor md, boolean search) {
        StructClass superClass;
        boolean foundInSuperClass;
        if (cl == null) {
            return false;
        }
        VBStyleCollection<StructMethod, String> methods = cl.getMethods();
        if (search) {
            for (StructMethod method : methods) {
                if (!md.equals(MethodDescriptor.parseDescriptor(method.getDescriptor())) || !name.equals(method.getName()) || method.hasModifier(8)) continue;
                return true;
            }
        }
        if (cl.superClass != null && (foundInSuperClass = ClassWriter.searchForMethod(superClass = DecompilerContext.getStructContext().getClass((String)cl.superClass.value), name, md, true))) {
            return true;
        }
        for (String ifaceName : cl.getInterfaceNames()) {
            StructClass iface = DecompilerContext.getStructContext().getClass(ifaceName);
            boolean foundInIface = ClassWriter.searchForMethod(iface, name, md, true);
            if (!foundInIface) continue;
            return true;
        }
        return false;
    }

    private static void appendParameterAnnotations(TextBuffer buffer, StructMethod mt, int param) {
        HashSet<String> filter = new HashSet<String>();
        for (Key<?> key : PARAMETER_ANNOTATION_ATTRIBUTES) {
            List<List<AnnotationExprent>> annotations;
            StructAnnotationParameterAttribute attribute = (StructAnnotationParameterAttribute)mt.getAttribute(key);
            if (attribute == null || param >= (annotations = attribute.getParamAnnotations()).size()) continue;
            for (AnnotationExprent annotation : annotations.get(param)) {
                TextBuffer text = annotation.toJava(-1);
                filter.add(text.convertToStringAndAllowDataDiscard());
                buffer.appendText(text).append(' ');
            }
        }
        ClassWriter.appendTypeAnnotations(buffer, -1, mt, 22, param, filter);
    }

    private static void appendTypeAnnotations(TextBuffer buffer, int indent, StructMember mb, int targetType, int index, Set<String> filter) {
        for (Key<?> key : TYPE_ANNOTATION_ATTRIBUTES) {
            StructTypeAnnotationAttribute attribute = (StructTypeAnnotationAttribute)mb.getAttribute(key);
            if (attribute == null) continue;
            for (TypeAnnotation annotation : attribute.getAnnotations()) {
                TextBuffer text;
                if (!annotation.isTopLevel() || annotation.getTargetType() != targetType || index >= 0 && annotation.getIndex() != index || filter.contains((text = annotation.getAnnotation().toJava(indent)).convertToStringAndAllowDataDiscard())) continue;
                buffer.appendIndent(indent);
                buffer.appendText(text);
                if (indent < 0) {
                    buffer.append(' ');
                    continue;
                }
                buffer.appendLineSeparator();
            }
        }
    }

    private static void appendModifiers(TextBuffer buffer, int flags, int allowed, boolean isInterface, int excluded) {
        flags &= allowed;
        if (!isInterface) {
            excluded = 0;
        }
        for (int modifier : MODIFIERS.keySet()) {
            if ((flags & modifier) != modifier || (modifier & excluded) != 0) continue;
            buffer.append(MODIFIERS.get(modifier)).append(' ');
        }
    }

    public static String getModifiers(int flags) {
        return MODIFIERS.entrySet().stream().filter(e -> ((Integer)e.getKey() & flags) != 0).map(Map.Entry::getValue).collect(Collectors.joining(" "));
    }

    public static void appendTypeParameters(TextBuffer buffer, List<String> parameters, List<List<VarType>> bounds) {
        buffer.append('<');
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(parameters.get(i));
            List<VarType> parameterBounds = bounds.get(i);
            if (parameterBounds.size() <= 1 && "java/lang/Object".equals(parameterBounds.get((int)0).value)) continue;
            buffer.append(" extends ");
            buffer.appendCastTypeName(parameterBounds.get(0));
            for (int j = 1; j < parameterBounds.size(); ++j) {
                buffer.append(" & ");
                buffer.appendCastTypeName(parameterBounds.get(j));
            }
        }
        buffer.append('>');
    }

    private static void appendFQClassNames(TextBuffer buffer, List<String> names) {
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            buffer.appendIndent(2).append(name);
            if (i >= names.size() - 1) continue;
            buffer.append(',').appendLineSeparator();
        }
    }

    static {
        MODIFIERS.put(1, "public");
        MODIFIERS.put(4, "protected");
        MODIFIERS.put(2, "private");
        MODIFIERS.put(1024, "abstract");
        MODIFIERS.put(8, "static");
        MODIFIERS.put(16, "final");
        MODIFIERS.put(2048, "strictfp");
        MODIFIERS.put(128, "transient");
        MODIFIERS.put(64, "volatile");
        MODIFIERS.put(32, "synchronized");
        MODIFIERS.put(256, "native");
    }

    private static enum MType {
        CLASS,
        FIELD,
        METHOD;

    }
}

