/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.api.plugin.Plugin;
import org.jetbrains.java.decompiler.api.plugin.PluginOptions;
import org.jetbrains.java.decompiler.main.extern.IFernflowerPreferences;
import org.jetbrains.java.decompiler.main.plugins.PluginContext;
import org.jetbrains.java.decompiler.util.Pair;

public record DecompilerOption(@NotNull String id, @NotNull String name, @NotNull String description, @NotNull Type type, @Nullable String plugin, @Nullable String defaultValue) implements Comparable<DecompilerOption>
{
    @Override
    public int compareTo(@NotNull DecompilerOption decompilerOption) {
        if (!Objects.equals(decompilerOption.plugin, this.plugin)) {
            if (this.plugin == null) {
                return -1;
            }
            if (decompilerOption.plugin == null) {
                return 1;
            }
            return this.plugin.compareTo(decompilerOption.plugin);
        }
        return this.id.compareTo(decompilerOption.id);
    }

    public static List<DecompilerOption> getAll() {
        ArrayList<DecompilerOption> options = new ArrayList<DecompilerOption>();
        List<Field> fields = Arrays.stream(IFernflowerPreferences.class.getDeclaredFields()).filter(field -> field.getType() == String.class).toList();
        Map<String, Object> defaults = IFernflowerPreferences.DEFAULTS;
        DecompilerOption.addOptions(fields, options, defaults, null);
        PluginContext ctx = new PluginContext();
        ctx.findPlugins();
        for (Plugin plugin : ctx.getPlugins()) {
            PluginOptions opt = plugin.getPluginOptions();
            if (opt == null) continue;
            Pair<Class<?>, Consumer<PluginOptions.AddDefaults>> opts = opt.provideOptions();
            List<Field> pluginFields = Arrays.stream(((Class)opts.a).getDeclaredFields()).filter(field -> field.getType() == String.class).toList();
            HashMap<String, Object> pluginDefaults = new HashMap<String, Object>();
            ((Consumer)opts.b).accept(pluginDefaults::put);
            DecompilerOption.addOptions(pluginFields, options, pluginDefaults, plugin);
        }
        options.sort(DecompilerOption::compareTo);
        return options;
    }

    public static Map<Plugin, List<DecompilerOption>> getAllByPlugin() {
        HashMap<Plugin, List<DecompilerOption>> options = new HashMap<Plugin, List<DecompilerOption>>();
        List<Field> fields = Arrays.stream(IFernflowerPreferences.class.getDeclaredFields()).filter(field -> field.getType() == String.class).toList();
        Map<String, Object> defaults = IFernflowerPreferences.DEFAULTS;
        ArrayList<DecompilerOption> coreOptions = new ArrayList<DecompilerOption>();
        DecompilerOption.addOptions(fields, coreOptions, defaults, null);
        coreOptions.sort(DecompilerOption::compareTo);
        options.put(null, coreOptions);
        PluginContext ctx = new PluginContext();
        ctx.findPlugins();
        for (Plugin plugin : ctx.getPlugins()) {
            PluginOptions opt = plugin.getPluginOptions();
            if (opt == null) continue;
            Pair<Class<?>, Consumer<PluginOptions.AddDefaults>> opts = opt.provideOptions();
            List<Field> pluginFields = Arrays.stream(((Class)opts.a).getDeclaredFields()).filter(field -> field.getType() == String.class).toList();
            HashMap<String, Object> pluginDefaults = new HashMap<String, Object>();
            ((Consumer)opts.b).accept(pluginDefaults::put);
            ArrayList<DecompilerOption> pluginOptions = new ArrayList<DecompilerOption>();
            DecompilerOption.addOptions(pluginFields, pluginOptions, pluginDefaults, plugin);
            pluginOptions.sort(DecompilerOption::compareTo);
            options.put(plugin, pluginOptions);
        }
        return options;
    }

    private static void addOptions(List<Field> fields, List<DecompilerOption> options, Map<String, Object> defaults, Plugin plugin) {
        for (Field field : fields) {
            String paramName;
            IFernflowerPreferences.Name name = field.getAnnotation(IFernflowerPreferences.Name.class);
            IFernflowerPreferences.Description description = field.getAnnotation(IFernflowerPreferences.Description.class);
            IFernflowerPreferences.Type type = field.getAnnotation(IFernflowerPreferences.Type.class);
            try {
                paramName = (String)field.get(null);
            }
            catch (IllegalAccessException e) {
                IFernflowerPreferences.ShortName shortName = field.getAnnotation(IFernflowerPreferences.ShortName.class);
                if (shortName == null) continue;
                paramName = shortName.value();
            }
            if (name == null || description == null || type == null) continue;
            String friendlyName = name.value();
            String friendlyDescription = description.value();
            Type friendlyType = type.value();
            Object defaultValue = defaults.get(paramName);
            String defaultValueString = defaultValue != null ? defaultValue.toString() : null;
            options.add(new DecompilerOption(paramName, friendlyName, friendlyDescription, friendlyType, plugin != null ? plugin.id() : null, defaultValueString));
        }
    }

    public static enum Type {
        BOOLEAN("bool"),
        STRING("string"),
        INTEGER("int");

        private final String friendlyName;

        private Type(String friendlyName) {
            this.friendlyName = friendlyName;
        }

        public String toString() {
            return this.friendlyName;
        }
    }
}

