/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.snowblower.Main;
import net.neoforged.snowblower.data.Version;
import net.neoforged.snowblower.util.HashFunction;
import net.neoforged.srgutils.MinecraftVersion;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Util.class);
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)MinecraftVersion.class), (json, typeOfT, context) -> MinecraftVersion.from(json.getAsString())).create();
    public static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.of(5L, ChronoUnit.SECONDS)).followRedirects(HttpClient.Redirect.NORMAL).build();
    public static PersonIdent COMMITTER = new PersonIdent("snowforge[bot]", "127516132+snowforge[bot]@users.noreply.github.com");

    public static boolean isDev() {
        return Main.class.getPackage().getImplementationVersion() == null;
    }

    public static Path getSourcePath() {
        Path folderPath = Path.of(Util.getCodeSourceUri());
        while (!Files.exists(folderPath.resolve(".git"), new LinkOption[0])) {
            if ((folderPath = folderPath.getParent()) != null) continue;
            return null;
        }
        return folderPath;
    }

    public static URI getCodeSourceUri() {
        try {
            return Util.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLines(Path target, String ... lines) throws IOException {
        String attrib = String.join((CharSequence)"\n", lines);
        Files.writeString(target, (CharSequence)attrib, new OpenOption[0]);
    }

    public static boolean downloadFile(Path output, Version version, String key) throws IOException {
        Version.Download download = version.downloads().get(key);
        if (download == null) {
            return false;
        }
        Util.downloadFile(output, download.url(), download.sha1());
        return true;
    }

    public static void downloadFile(Path file, URL url, @Nullable String sha1) throws IOException {
        String actual;
        if (Files.exists(file, new LinkOption[0])) {
            Files.delete(file);
        } else {
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
        }
        Util.download(url, () -> HttpResponse.BodyHandlers.ofFile(file));
        if (sha1 != null && !(actual = HashFunction.SHA1.hash(file)).equals(sha1)) {
            Files.delete(file);
            throw new IOException("Failed to download " + String.valueOf(url) + " Invalid Hash:\n    Expected: " + sha1 + "\n    Actual: " + actual);
        }
    }

    private static <T> HttpResponse<T> download(URL url, Supplier<HttpResponse.BodyHandler<T>> bodyHandlerFactory) throws IOException {
        HttpResponse<T> httpResponse;
        URI uri;
        LOGGER.debug("  Downloading " + String.valueOf(url));
        int maxAttempts = 10;
        int attempts = 1;
        long waitTime = 1000L;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        HttpRequest httpRequest = Util.getHttpRequest(uri);
        while (true) {
            IOException ioException = null;
            httpResponse = null;
            try {
                httpResponse = HTTP_CLIENT.send(httpRequest, bodyHandlerFactory.get());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                ioException = e;
            }
            if (httpResponse != null && httpResponse.statusCode() == 200) break;
            if (attempts == maxAttempts) {
                String errorMessage = "    Failed to download " + String.valueOf(url) + " - exceeded max attempts of " + maxAttempts;
                if (ioException != null) {
                    throw new IOException(errorMessage, ioException);
                }
                if (httpResponse != null) {
                    throw new IOException(errorMessage + ", response code: " + httpResponse.statusCode());
                }
                throw new IOException(errorMessage);
            }
            Object error = httpResponse == null ? Objects.toString(ioException) : "HTTP Response Code " + httpResponse.statusCode();
            LOGGER.warn("    Failed to download, attempt: " + attempts + "/" + maxAttempts + ", error: " + (String)error + ", retrying in " + waitTime + " ms...");
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            waitTime = Math.min(waitTime * (long)Math.pow(2.0, attempts), 64000L);
            ++attempts;
        }
        return httpResponse;
    }

    private static HttpRequest getHttpRequest(URI uri) {
        return HttpRequest.newBuilder(uri).header("Cache-Control", "no-store,max-age=0,no-cache").header("Expires", "0").header("Pragma", "no-cache").GET().build();
    }

    public static <T> T downloadJson(URL url, Class<T> type) throws IOException {
        try (InputStreamReader in = new InputStreamReader((InputStream)Util.download(url, HttpResponse.BodyHandlers::ofInputStream).body());){
            T t = GSON.fromJson((Reader)in, type);
            return t;
        }
    }

    public static void deleteRecursive(Path dir) throws IOException {
        if (!Files.exists(dir, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> walker = Files.walk(dir, new FileVisitOption[0]);){
            walker.sorted(Comparator.reverseOrder()).forEach(p -> {
                try {
                    Files.delete(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static void commit(Git git, String message, Date time) throws GitAPIException {
        PersonIdent timed = new PersonIdent(COMMITTER, time);
        git.commit().setMessage(message).setAuthor(timed).setCommitter(timed).setSign(false).call();
    }

    public static void add(Git git, Path file) throws GitAPIException {
        Path root = git.getRepository().getDirectory().getParentFile().toPath();
        Path path = root.toAbsolutePath().relativize(file.toAbsolutePath());
        git.add().addFilepattern(path.toString()).call();
    }

    public static URL makeURL(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Collector<T, ?, Map<Integer, List<T>>> partitionEvery(int chunkSize) {
        AtomicInteger counter = new AtomicInteger();
        return Collectors.groupingBy(it -> counter.getAndIncrement() / chunkSize);
    }
}

