/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.installertools;

import java.io.File;
import java.io.IOException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpecBuilder;
import net.neoforged.installertools.Task;
import net.neoforged.srgutils.IMappingFile;

public class MergeMappings
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> base = parser.accepts("base").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder reverseBase = parser.accepts("reverse-base");
        ArgumentAcceptingOptionSpec<File> merge = parser.accepts("merge").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder reverseMerge = parser.accepts("reverse-merge");
        ArgumentAcceptingOptionSpec<File> output = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder reverseOutput = parser.accepts("reverse-output");
        try {
            OptionSet options = parser.parse(args);
            this.merge(options.valueOf(base), options.has(reverseBase), options.valueOf(merge), options.has(reverseMerge), options.valueOf(output), options.has(reverseOutput));
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            this.error("Please provide correct parameters");
        }
    }

    private void merge(File baseFile, boolean reverseBase, File mergeFile, boolean reverseMerge, File outputFile, boolean reverseOutput) throws IOException {
        this.log("Base Mappings: " + baseFile);
        this.log("Reverse Base Mappings: " + reverseBase);
        this.log("Merge Mappings: " + mergeFile);
        this.log("Reverse Merge Mappings: " + reverseMerge);
        this.log("Output: " + outputFile);
        this.log("Reverse Output: " + reverseOutput);
        IMappingFile baseMappings = IMappingFile.load(baseFile);
        if (reverseBase) {
            baseMappings = baseMappings.reverse();
        }
        IMappingFile mergeMappings = IMappingFile.load(mergeFile);
        if (reverseMerge) {
            mergeMappings = mergeMappings.reverse();
        }
        IMappingFile outputMappings = baseMappings.merge(mergeMappings);
        if (reverseOutput) {
            outputMappings = outputMappings.reverse();
        }
        outputMappings.write(outputFile.toPath(), IMappingFile.Format.TSRG2, false);
    }
}

