/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.neoforged.snowblower.util.DependencyHashCache;
import net.neoforged.snowblower.util.HashFunction;

public class Cache {
    private final Map<String, String> data = new LinkedHashMap<String, String>();
    private String comment = null;

    public Cache comment(String ... lines) {
        this.comment = lines == null || lines.length == 0 ? null : String.join((CharSequence)"\n", lines);
        return this;
    }

    public Cache put(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    public Cache put(String key, Path path) throws IOException {
        this.data.put(key, HashFunction.SHA1.hash(path));
        return this;
    }

    public Cache put(String key, DependencyHashCache depCache) {
        this.data.put(key, depCache.getHash(key));
        return this;
    }

    public void write(Path target) throws IOException {
        StringBuilder buf = new StringBuilder();
        if (this.comment != null) {
            buf.append(this.comment).append("\n\n");
        }
        this.data.forEach((k, v) -> buf.append((String)k).append(": ").append((String)v).append('\n'));
        Files.writeString(target, (CharSequence)buf.toString(), new OpenOption[0]);
    }

    public boolean isValid(Path target) throws IOException {
        return this.isValid(target, e -> true);
    }

    public boolean isValid(Path target, Predicate<String> shouldConsider) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            return false;
        }
        HashMap existing = new HashMap();
        try (Stream<String> stream = Files.lines(target);){
            stream.forEach(l -> {
                int idx = l.indexOf(32);
                if (idx <= 1 || l.charAt(idx - 1) != ':') {
                    return;
                }
                String key = l.substring(0, idx - 1);
                String value = l.substring(idx + 1);
                if (shouldConsider.test(key)) {
                    existing.put(key, value);
                }
            });
        }
        return existing.equals(this.data);
    }
}

