/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower.data;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import net.neoforged.snowblower.util.Util;
import net.neoforged.srgutils.MinecraftVersion;
import org.jetbrains.annotations.Nullable;

public record Config(Map<String, BranchSpec> branches) {
    public static Config load(Path file) throws IOException {
        try (InputStreamReader in = new InputStreamReader(Files.newInputStream(file, new OpenOption[0]));){
            Config config = (Config)Util.GSON.fromJson((Reader)in, Config.class);
            return config;
        }
    }

    public record BranchSpec(String type, @Nullable MinecraftVersion start, @Nullable MinecraftVersion end, @Nullable List<MinecraftVersion> versions, @Nullable List<MinecraftVersion> includeVersions, @Nullable List<MinecraftVersion> excludeVersions) {
        public BranchSpec(String type, MinecraftVersion start, MinecraftVersion end) {
            this(type, start, end, null, null, null);
        }
    }
}

