/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.neoforged.art.api.IdentifierFixerConfig;
import net.neoforged.art.api.Renamer;
import net.neoforged.art.api.SignatureStripperConfig;
import net.neoforged.art.api.SourceFixerConfig;
import net.neoforged.art.api.Transformer;
import net.neoforged.snowblower.data.Config;
import net.neoforged.snowblower.data.Version;
import net.neoforged.snowblower.data.VersionManifestV2;
import net.neoforged.snowblower.tasks.MappingTask;
import net.neoforged.snowblower.tasks.MergeTask;
import net.neoforged.snowblower.tasks.enhance.EnhanceVersionTask;
import net.neoforged.snowblower.tasks.init.InitTask;
import net.neoforged.snowblower.util.Cache;
import net.neoforged.snowblower.util.DependencyHashCache;
import net.neoforged.snowblower.util.HashFunction;
import net.neoforged.snowblower.util.Util;
import net.neoforged.srgutils.MinecraftVersion;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.main.decompiler.ConsoleDecompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Generator.class);
    public static final int COMMIT_BATCH_SIZE = 10;
    private final Path output;
    private final Path cache;
    private final Path extraMappings;
    private final DependencyHashCache depCache;
    private final List<String> includes;
    private final List<String> excludes;
    private Git git;
    private String remoteName;
    private String branchName;
    private Config.BranchSpec branch;
    private boolean checkout;
    private boolean push;
    private boolean removeRemote;
    private boolean freshIfRequired;
    private boolean partialCache;
    private final String[] decompileArgs = new String[]{"--decompile-inner", "--remove-bridge", "--decompile-generics", "--ascii-strings", "--remove-synthetic", "--include-classpath", "--variable-renaming=jad", "--ignore-invalid-bytecode", "--bytecode-source-mapping", "--dump-code-lines", "--indent-string=    ", "--rename-parameters", "--no-use-method-parameters"};

    public Generator(Path output, Path cache, Path extraMappings, DependencyHashCache depCache, List<String> includes, List<String> excludes) {
        this.output = output.toAbsolutePath().normalize();
        this.cache = cache.toAbsolutePath().normalize();
        this.extraMappings = extraMappings == null ? null : extraMappings.toAbsolutePath().normalize();
        this.depCache = depCache;
        this.includes = includes;
        this.excludes = excludes;
    }

    public Generator setup(String branchName, @Nullable URIish remoteUrl, boolean checkout, boolean push, Config cfg, Config.BranchSpec cliBranch, boolean fresh, boolean freshIfRequired, boolean partialCache) throws IOException, GitAPIException {
        Config.BranchSpec cfgBranch;
        try {
            this.git = Git.open((File)this.output.toFile());
        }
        catch (RepositoryNotFoundException e) {
            if (branchName == null) {
                branchName = "release";
            }
            Util.deleteRecursive(this.output);
            this.git = Git.init().setDirectory(this.output.toFile()).setInitialBranch(branchName).call();
        }
        this.setupRemote(remoteUrl);
        this.branchName = branchName;
        this.checkout = checkout;
        this.push = push;
        this.freshIfRequired = freshIfRequired;
        this.partialCache = partialCache;
        branchName = this.setupBranch(branchName, fresh);
        Config.BranchSpec branchSpec = cfgBranch = cfg.branches() == null ? null : cfg.branches().get(branchName);
        if (cfgBranch == null) {
            if (cliBranch.start() == null && cliBranch.end() == null) {
                throw new IllegalArgumentException("Unknown branch config: " + branchName);
            }
            this.branch = cliBranch;
        } else {
            this.branch = new Config.BranchSpec(cfgBranch.type(), cliBranch.start() == null ? cfgBranch.start() : cliBranch.start(), cliBranch.end() == null ? cfgBranch.end() : cliBranch.end(), cfgBranch.versions(), cfgBranch.includeVersions(), cfgBranch.excludeVersions());
        }
        return this;
    }

    private String setupBranch(@Nullable String branchName, boolean fresh) throws IOException, GitAPIException {
        String currentBranch = this.git.getRepository().getBranch();
        if (branchName == null) {
            if (currentBranch == null) {
                throw new IllegalStateException("Git repository has no HEAD reference");
            }
            branchName = currentBranch;
        }
        boolean exists = this.git.getRepository().resolve(branchName) != null;
        boolean deleteTemp = false;
        if (fresh && exists) {
            LOGGER.info("Starting over existing branch {}", (Object)branchName);
            deleteTemp = this.deleteBranch(branchName, currentBranch);
            exists = false;
            this.git.checkout().setOrphan(true).setName(branchName).call();
        } else if (!fresh && this.checkout && this.remoteName != null && this.git.getRepository().resolve(this.remoteName + "/" + branchName) != null) {
            if (exists) {
                deleteTemp = this.deleteBranch(branchName, currentBranch);
            }
            CreateBranchCommand.SetupUpstreamMode upstreamMode = this.removeRemote ? CreateBranchCommand.SetupUpstreamMode.NOTRACK : CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM;
            this.git.checkout().setCreateBranch(true).setName(branchName).setUpstreamMode(upstreamMode).setStartPoint(this.remoteName + "/" + branchName).call();
        } else if (!branchName.equals(currentBranch)) {
            this.git.checkout().setOrphan(!exists).setName(branchName).call();
        }
        this.git.reset().setMode(ResetCommand.ResetType.HARD).call();
        this.git.clean().setCleanDirectories(true).call();
        if (deleteTemp) {
            this.git.branchDelete().setBranchNames(new String[]{"orphan_temp"}).setForce(true).call();
        }
        return branchName;
    }

    private boolean deleteBranch(String branchName, String currentBranch) throws GitAPIException {
        boolean deleteTemp = false;
        if (branchName.equals(currentBranch)) {
            this.git.checkout().setOrphan(true).setName("orphan_temp").call();
            deleteTemp = true;
        }
        this.git.branchDelete().setBranchNames(new String[]{branchName}).setForce(true).call();
        return deleteTemp;
    }

    private void setupRemote(@Nullable URIish remoteUrl) throws GitAPIException {
        if (remoteUrl == null) {
            return;
        }
        Object foundRemote = null;
        HashSet<String> remoteNames = new HashSet<String>();
        block0: for (RemoteConfig remoteConfig : this.git.remoteList().call()) {
            String currRemoteName = remoteConfig.getName();
            remoteNames.add(currRemoteName);
            if (foundRemote != null) continue;
            for (URIish fakeUri : remoteConfig.getURIs()) {
                if (!fakeUri.equals((Object)remoteUrl)) continue;
                foundRemote = currRemoteName;
                continue block0;
            }
        }
        if (foundRemote == null) {
            int i = 0;
            foundRemote = "origin";
            while (remoteNames.contains(foundRemote)) {
                foundRemote = "origin" + ++i;
            }
            this.git.remoteAdd().setName((String)foundRemote).setUri(remoteUrl).call();
            this.removeRemote = true;
        }
        this.remoteName = foundRemote;
        this.git.fetch().setRemote(this.remoteName).setProgressMonitor((ProgressMonitor)new TextProgressMonitor((Writer)new OutputStreamWriter(System.out))).call();
    }

    public void run() throws IOException, GitAPIException {
        try {
            this.runInternal();
        }
        finally {
            if (this.removeRemote && this.remoteName != null) {
                this.git.remoteRemove().setRemoteName(this.remoteName).call();
            }
        }
    }

    private void runInternal() throws IOException, GitAPIException {
        MinecraftVersion startVer;
        InitTask init = new InitTask(this.output, this.git);
        VersionManifestV2 manifest = VersionManifestV2.query();
        if (manifest.versions() == null) {
            throw new IllegalStateException("Failed to find versions, manifest missing versions listing");
        }
        ArrayList<VersionManifestV2.VersionInfo> versions = new ArrayList<VersionManifestV2.VersionInfo>(Arrays.asList(manifest.versions()));
        MinecraftVersion targetVer = this.branch.end();
        if (this.branch.versions() != null) {
            versions.removeIf(v -> !this.branch.versions().contains(v.id()));
            if (targetVer == null) {
                targetVer = versions.get(0).id();
            }
        } else {
            List exclude = versions.stream().filter(v -> v.id().getType().isSpecial()).map(VersionManifestV2.VersionInfo::id).collect(Collectors.toList());
            if (this.branch.includeVersions() != null) {
                exclude.removeAll(this.branch.includeVersions());
            }
            if (this.branch.excludeVersions() != null) {
                exclude.addAll(this.branch.excludeVersions());
            }
            versions.removeIf(v -> exclude.contains(v.id()));
        }
        if (targetVer == null) {
            VersionManifestV2.LatestInfo lat = manifest.latest();
            if (lat == null) {
                throw new IllegalStateException("Failed to determine latest version, Manifest does not contain latest entries");
            }
            if (this.branch.type().equals("release")) {
                targetVer = lat.release();
            } else {
                VersionManifestV2.VersionInfo release = versions.stream().filter(e -> lat.release().equals((Object)e.id())).findFirst().orElse(null);
                VersionManifestV2.VersionInfo snapshot = versions.stream().filter(e -> lat.snapshot().equals((Object)e.id())).findFirst().orElse(null);
                if (release == null && snapshot == null) {
                    throw new IllegalStateException("Failed to find latest, manifest specified " + String.valueOf(lat.release()) + " and " + String.valueOf(lat.snapshot()) + " and both are missing");
                }
                if (release == null) {
                    targetVer = snapshot.id();
                } else if (snapshot == null) {
                    targetVer = release.id();
                } else {
                    MinecraftVersion minecraftVersion = targetVer = snapshot.releaseTime().compareTo(release.releaseTime()) > 0 ? snapshot.id() : release.id();
                }
            }
        }
        if ((startVer = this.branch.start()) == null) {
            startVer = versions.get(versions.size() - 1).id();
        }
        if (!init.validate(startVer)) {
            if (this.freshIfRequired) {
                this.setupBranch(this.branchName, true);
                if (!init.validate(startVer)) {
                    throw new IllegalStateException("This should never happen! We deleted the branch, but it still failed verification.");
                }
            } else {
                LOGGER.error("The starting commit on this branch does not have matching metadata.\nThis could be due to a different Snowblower version or a different starting Minecraft version.\nPlease choose a different branch with --branch or add the --start-over / --start-over-if-required flag and try again.\n");
                return;
            }
        }
        int startIdx = -1;
        int endIdx = -1;
        for (int i = 0; i < versions.size(); ++i) {
            MinecraftVersion ver = versions.get(i).id();
            if (ver.equals((Object)targetVer)) {
                endIdx = i;
            }
            if (!ver.equals((Object)startVer)) continue;
            startIdx = i;
            break;
        }
        if (startIdx == -1) {
            throw new IllegalStateException("Could not find start version in version list. Was it excluded? Start: " + String.valueOf(startVer) + ", End: " + String.valueOf(targetVer));
        }
        if (endIdx == -1) {
            throw new IllegalStateException("Could not find end version in version list (or end version is earlier than start version). Was it excluded? Start: " + String.valueOf(startVer) + ", End: " + String.valueOf(targetVer));
        }
        List<VersionManifestV2.VersionInfo> toGenerate = new ArrayList<VersionManifestV2.VersionInfo>(versions.subList(endIdx, startIdx + 1));
        if (this.branch.type().equals("release")) {
            toGenerate.removeIf(v -> !v.type().equals("release"));
        }
        Collections.reverse(toGenerate);
        String lastVersion = Generator.getLastVersion(this.git);
        if (lastVersion != null && !init.isInitCommit(lastVersion)) {
            boolean found = false;
            for (int i = 0; i < toGenerate.size(); ++i) {
                if (!toGenerate.get(i).id().toString().equals(lastVersion)) continue;
                toGenerate = toGenerate.subList(i + 1, toGenerate.size());
                found = true;
                break;
            }
            if (!found) {
                throw new IllegalStateException("Git is in invalid state, latest commit is " + lastVersion + " but it is not in our version list");
            }
        }
        toGenerate = Generator.findVersionsWithMappings(toGenerate, this.cache, this.extraMappings);
        this.pushRemainingCommits();
        Path libs = this.cache.resolve("libraries");
        boolean generatedAny = !toGenerate.isEmpty();
        for (int x = 0; x < toGenerate.size(); ++x) {
            VersionManifestV2.VersionInfo versionInfo = toGenerate.get(x);
            Path versionCache = this.cache.resolve(versionInfo.id().toString());
            Files.createDirectories(versionCache, new FileAttribute[0]);
            LOGGER.info("[{}, {}] Generating {}", new Object[]{x + 1, toGenerate.size(), versionInfo.id()});
            Version version = Version.load(versionCache.resolve("version.json"));
            this.generate(this.git, this.output, versionCache, libs, version, this.extraMappings, this.depCache);
            if (x % 10 != 9) continue;
            this.attemptPush("Pushing 10 versions to remote.");
        }
        if (!this.attemptPush(generatedAny ? "Pushing remaining versions to remote." : "Pushing versions to remote.") && !generatedAny) {
            LOGGER.info("No versions to process");
        }
    }

    private void pushRemainingCommits() throws GitAPIException, IOException {
        RevCommit commit;
        int idx2;
        if (this.remoteName == null) {
            return;
        }
        ObjectId remoteBranch = this.git.getRepository().resolve("refs/remotes/" + this.remoteName + "/" + this.branchName);
        if (remoteBranch == null) {
            return;
        }
        ArrayList ourCommits = new ArrayList();
        this.git.log().setMaxCount(Integer.MAX_VALUE).call().forEach(ourCommits::add);
        @FunctionalInterface
        static interface Pusher {
            public void push(int var1) throws GitAPIException;
        }
        Pusher pusher = idx -> {
            List<List> commits = ourCommits.subList(0, idx).stream().collect(Util.partitionEvery(10)).entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey).reversed()).map(Map.Entry::getValue).filter(Predicate.not(List::isEmpty)).toList();
            for (List notPushed : commits) {
                this.attemptPush("Pushed " + notPushed.size() + " old commits.", new RefSpec(((RevCommit)notPushed.get(0)).getId().getName() + ":refs/heads/" + this.branchName));
            }
        };
        boolean foundCommonAncestor = false;
        Iterator iterator = this.git.log().add((AnyObjectId)remoteBranch).setMaxCount(Integer.MAX_VALUE).call().iterator();
        while (iterator.hasNext() && (idx2 = ourCommits.indexOf(commit = (RevCommit)iterator.next())) != 0) {
            if (idx2 <= 0) continue;
            pusher.push(idx2);
            foundCommonAncestor = true;
            break;
        }
        if (!foundCommonAncestor) {
            pusher.push(ourCommits.size());
        }
    }

    private boolean attemptPush(String message) throws GitAPIException {
        return this.attemptPush(message, new RefSpec(this.branchName + ":" + this.branchName));
    }

    private boolean attemptPush(String message, RefSpec spec) throws GitAPIException {
        if (!this.push || this.remoteName == null) {
            return false;
        }
        LOGGER.info(message);
        Iterable result = this.git.push().setRemote(this.remoteName).setForce(true).setRefSpecs(new RefSpec[]{spec}).call();
        RemoteRefUpdate remoteRefUpdate = StreamSupport.stream(result.spliterator(), false).map(res -> res.getRemoteUpdate("refs/heads/" + this.branchName)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Attempted to push to remote, but failed. Reason unknown."));
        LOGGER.info(switch (remoteRefUpdate.getStatus()) {
            case RemoteRefUpdate.Status.OK -> "  Successfully pushed to remote.";
            case RemoteRefUpdate.Status.UP_TO_DATE -> "  Attempted to push to remote, but local branch was up-to-date.";
            default -> throw new IllegalStateException("Could not push to remote: status: " + String.valueOf(remoteRefUpdate.getStatus()) + ", message: " + remoteRefUpdate.getMessage());
        });
        return remoteRefUpdate.getStatus() == RemoteRefUpdate.Status.OK;
    }

    private static List<VersionManifestV2.VersionInfo> findVersionsWithMappings(List<VersionManifestV2.VersionInfo> versions, Path cache, Path extraMappings) throws IOException {
        LOGGER.info("Downloading version manifests");
        ArrayList<VersionManifestV2.VersionInfo> ret = new ArrayList<VersionManifestV2.VersionInfo>();
        for (VersionManifestV2.VersionInfo ver : versions) {
            Map<String, Version.Download> dls;
            Path json = cache.resolve(ver.id().toString()).resolve("version.json");
            if (!Files.exists(json, new LinkOption[0]) || !HashFunction.SHA1.hash(json).equals(ver.sha1())) {
                Util.downloadFile(json, ver.url(), ver.sha1());
            }
            if ((dls = Version.load(json).downloads()).containsKey("client_mappings") && dls.containsKey("server_mappings")) {
                ret.add(ver);
                continue;
            }
            if (extraMappings == null) continue;
            Path root = extraMappings.resolve(ver.type()).resolve(ver.id().toString()).resolve("maps");
            Path client = root.resolve("client.txt");
            Path server = root.resolve("server.txt");
            if (!Files.exists(client, new LinkOption[0]) || !Files.exists(server, new LinkOption[0])) continue;
            ret.add(ver);
        }
        return ret;
    }

    private static String getLastVersion(Git git) throws IOException, GitAPIException {
        ObjectId headId = git.getRepository().resolve("HEAD");
        if (headId == null) {
            return null;
        }
        for (RevCommit commit : git.log().add((AnyObjectId)headId).call()) {
            if (!commit.getCommitterIdent().getName().equals(Util.COMMITTER.getName())) continue;
            return commit.getShortMessage();
        }
        return null;
    }

    private void generate(Git git, Path output, Path cache, Path libCache, Version version, Path extraMappings, DependencyHashCache depCache) throws IOException, GitAPIException {
        Set<Object> existingFiles;
        Path src;
        Path decomped = null;
        if (this.partialCache) {
            Path decompJar = cache.resolve("joined-decompiled.jar");
            Path keyF = cache.resolve("joined-decompiled.jar.cache");
            if (Files.exists(decompJar, new LinkOption[0]) && Files.exists(keyF, new LinkOption[0])) {
                Cache key = new Cache().put("org.vineflower:vineflower", this.depCache);
                if (this.partialCache) {
                    key.put("downloads-client", version.downloads().get("client").sha1());
                    key.put("downloads-client_mappings", version.downloads().get("client_mappings").sha1());
                    key.put("downloads-server", version.downloads().get("server").sha1());
                    key.put("downloads-server", version.downloads().get("server_mappings").sha1());
                }
                key.put("decompileArgs", String.join((CharSequence)" ", this.decompileArgs));
                if (key.isValid(keyF, str -> str.equals("org.vineflower:vineflower") || str.equals("decompileArgs") || str.startsWith("downloads-"))) {
                    decomped = decompJar;
                    LOGGER.debug("  Decompiled jar partial cache hit");
                }
            }
        }
        if (decomped == null) {
            Path mappings = MappingTask.getMergedMappings(cache, version, extraMappings);
            if (mappings == null) {
                return;
            }
            Path joined = MergeTask.getJoinedJar(cache, version, mappings, depCache, this.partialCache);
            List<Path> libs = this.getLibraries(libCache, version);
            Path renamed = this.getRenamedJar(cache, joined, mappings, libCache, libs);
            decomped = this.getDecompiledJar(cache, version, renamed, libCache, libs);
        }
        if (Files.exists(src = output.resolve("src").resolve("main"), new LinkOption[0])) {
            try (Stream<Path> walker = Files.walk(src, new FileVisitOption[0]);){
                existingFiles = walker.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toSet());
            }
        } else {
            existingFiles = new HashSet();
        }
        Path java = src.resolve("java");
        Path resources = src.resolve("resources");
        ArrayList<Path> added = new ArrayList<Path>();
        ArrayList removed = new ArrayList();
        try (FileSystem zipFs = FileSystems.newFileSystem(decomped);){
            PathMatcher matcher = Generator.createMatcher(zipFs, this.includes, this.excludes);
            Path root = zipFs.getPath("/", new String[0]);
            try (Stream<Path> walker = Files.walk(root, new FileVisitOption[0]);){
                walker.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> {
                    try {
                        Path relative = root.relativize((Path)p);
                        if (!matcher.matches(relative)) {
                            return;
                        }
                        Path target = (p.toString().endsWith(".java") ? java : resources).resolve(relative.toString());
                        if (existingFiles.remove(target)) {
                            boolean copy;
                            Path realPath = target.toRealPath(LinkOption.NOFOLLOW_LINKS);
                            if (!realPath.toString().equals(target.toString())) {
                                Files.delete(realPath);
                                removed.add(realPath);
                                added.add(target);
                                copy = true;
                            } else {
                                String created;
                                String existing = HashFunction.MD5.hash(target);
                                boolean bl = copy = !existing.equals(created = HashFunction.MD5.hash((Path)p));
                            }
                            if (copy) {
                                Files.copy(p, target, StandardCopyOption.REPLACE_EXISTING);
                                added.add(target);
                            }
                        } else {
                            Files.createDirectories(target.getParent(), new FileAttribute[0]);
                            Files.copy(p, target, StandardCopyOption.REPLACE_EXISTING);
                            added.add(target);
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        }
        List<Path> enhanced = EnhanceVersionTask.enhance(output, version);
        existingFiles.removeAll(enhanced);
        added.addAll(enhanced);
        existingFiles.stream().sorted().forEach(p -> {
            try {
                Files.delete(p);
                removed.add(p);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (!added.isEmpty() || !removed.isEmpty()) {
            LOGGER.debug("  Committing files");
            Function<Path, String> convert = p -> output.relativize((Path)p).toString().replace('\\', '/');
            if (!added.isEmpty()) {
                AddCommand add = git.add();
                added.stream().map(convert).forEach(arg_0 -> ((AddCommand)add).addFilepattern(arg_0));
                add.call();
            }
            if (!removed.isEmpty()) {
                RmCommand rm = git.rm();
                removed.stream().map(convert).forEach(arg_0 -> ((RmCommand)rm).addFilepattern(arg_0));
                rm.call();
            }
            Util.commit(git, version.id().toString(), version.releaseTime());
        }
    }

    private List<Path> getLibraries(Path cache, Version version) throws IOException {
        if (version.libraries() == null) {
            return Collections.emptyList();
        }
        ArrayList<Path> ret = new ArrayList<Path>();
        for (Version.Library lib : version.libraries()) {
            if (lib.downloads() == null || !lib.downloads().containsKey("artifact")) continue;
            Version.Download dl = lib.downloads().get("artifact");
            Path target = cache.resolve(dl.path());
            if (!Files.exists(target, new LinkOption[0])) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Util.downloadFile(target, dl.url(), dl.sha1());
            }
            ret.add(target);
        }
        return ret;
    }

    private Path getRenamedJar(Path cache, Path joined, Path mappings, Path libCache, List<Path> libs) throws IOException {
        Cache key = new Cache().put("net.neoforged:AutoRenamingTool", this.depCache).put("joined", joined).put("map", mappings);
        for (Path lib : libs) {
            Path relative = libCache.relativize(lib);
            key.put(relative.toString(), lib);
        }
        Path keyF = cache.resolve("joined-renamed.jar.cache");
        Path ret = cache.resolve("joined-renamed.jar");
        if (!Files.exists(ret, new LinkOption[0]) || !key.isValid(keyF)) {
            LOGGER.debug("  Renaming joined jar");
            Renamer.Builder builder = Renamer.builder().map(mappings.toFile()).add(Transformer.parameterAnnotationFixerFactory()).add(Transformer.identifierFixerFactory((IdentifierFixerConfig)IdentifierFixerConfig.ALL)).add(Transformer.sourceFixerFactory((SourceFixerConfig)SourceFixerConfig.JAVA)).add(Transformer.recordFixerFactory()).add(Transformer.signatureStripperFactory((SignatureStripperConfig)SignatureStripperConfig.ALL)).add(Transformer.parameterFinalFlagRemoverFactory()).logger(s -> {});
            libs.forEach(l -> builder.lib(l.toFile()));
            try (Renamer renamer = builder.build();){
                renamer.run(joined.toFile(), ret.toFile());
            }
            key.write(keyF);
        }
        return ret;
    }

    private Path getDecompiledJar(Path cache, Version version, Path renamed, Path libCache, List<Path> libs) throws IOException {
        Cache key = new Cache().put("org.vineflower:vineflower", this.depCache).put("renamed", renamed);
        if (this.partialCache) {
            key.put("downloads-client", version.downloads().get("client").sha1());
            key.put("downloads-client_mappings", version.downloads().get("client_mappings").sha1());
            key.put("downloads-server", version.downloads().get("server").sha1());
            key.put("downloads-server", version.downloads().get("server_mappings").sha1());
        }
        key.put("decompileArgs", String.join((CharSequence)" ", this.decompileArgs));
        for (Path lib : libs) {
            Path relative = libCache.relativize(lib);
            key.put(relative.toString(), lib);
        }
        Path keyF = cache.resolve("joined-decompiled.jar.cache");
        Path ret = cache.resolve("joined-decompiled.jar");
        if (!Files.exists(ret, new LinkOption[0]) || !key.isValid(keyF)) {
            LOGGER.debug("  Decompiling joined-renamed.jar");
            Path cfg = cache.resolve("joined-libraries.cfg");
            Util.writeLines(cfg, (String[])libs.stream().map(l -> "-e=" + l.toString()).toArray(String[]::new));
            ConsoleDecompiler.main((String[])((String[])Stream.concat(Arrays.stream(this.decompileArgs), Stream.of("-log=ERROR", "-cfg", cfg.toString(), renamed.toString(), ret.toString())).toArray(String[]::new)));
            key.write(keyF);
        }
        return ret;
    }

    private static PathMatcher createMatcher(FileSystem fs, List<String> includes, List<String> excludes) {
        PathMatcher matcher = !includes.isEmpty() ? Generator.createMatcher(fs, includes) : path -> true;
        if (!excludes.isEmpty()) {
            PathMatcher excludesMatcher = Generator.createMatcher(fs, excludes);
            return path -> matcher.matches(path) && !excludesMatcher.matches(path);
        }
        return matcher;
    }

    private static PathMatcher createMatcher(FileSystem fs, List<String> globPatterns) {
        if (globPatterns.isEmpty()) {
            return path -> false;
        }
        if (globPatterns.size() == 1) {
            return fs.getPathMatcher("glob:" + globPatterns.get(0));
        }
        ArrayList<PathMatcher> matchers = new ArrayList<PathMatcher>(globPatterns.size());
        for (String globPattern : globPatterns) {
            matchers.add(fs.getPathMatcher("glob:" + globPattern));
        }
        return path -> {
            for (PathMatcher matcher : matchers) {
                if (!matcher.matches(path)) continue;
                return true;
            }
            return false;
        };
    }

    @Override
    public void close() throws Exception {
        if (this.git != null) {
            this.git.close();
        }
    }
}

