/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.decompose;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.api.plugin.GraphParser;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.rels.MethodProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.DomTracer;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.FastExtendedPostdominanceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.decompose.StrongConnectivityHelper;
import org.jetbrains.java.decompiler.modules.decompiler.deobfuscator.IrreducibleCFGDeobfuscator;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.GeneralStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SequenceStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.util.DotExporter;
import org.jetbrains.java.decompiler.util.InterpreterUtil;
import org.jetbrains.java.decompiler.util.collections.VBStyleCollection;
import org.jetbrains.java.decompiler.util.collections.fixed.FastFixedSet;
import org.jetbrains.java.decompiler.util.collections.fixed.FastFixedSetFactory;

public final class DomHelper
implements GraphParser {
    @Override
    public RootStatement createStatement(ControlFlowGraph graph, StructMethod mt) {
        return DomHelper.parseGraph(graph, mt, 0);
    }

    private static RootStatement graphToStatement(ControlFlowGraph graph, StructMethod mt) {
        VBStyleCollection<BasicBlockStatement, Integer> stats = new VBStyleCollection<BasicBlockStatement, Integer>();
        VBStyleCollection<BasicBlock, Integer> blocks = graph.getBlocks();
        for (BasicBlock block : blocks) {
            stats.addWithKey(new BasicBlockStatement(block), block.id);
        }
        BasicBlock firstblock = graph.getFirst();
        Statement firstst = (Statement)stats.getWithKey(firstblock.id);
        DummyExitStatement dummyexit = new DummyExitStatement();
        if (stats.size() <= 1 && !firstblock.isSuccessor(firstblock)) {
            RootStatement root = new RootStatement(firstst, dummyexit, mt);
            firstst.addSuccessor(new StatEdge(4, firstst, dummyexit, root));
            return root;
        }
        GeneralStatement general = new GeneralStatement(firstst, stats, null);
        for (BasicBlock block : blocks) {
            Statement stat = (Statement)stats.getWithKey(block.id);
            for (BasicBlock succ : block.getSuccs()) {
                int type;
                Statement stsucc = (Statement)stats.getWithKey(succ.id);
                if (stsucc == firstst) {
                    type = 8;
                    stsucc = general;
                } else if (graph.getFinallyExits().contains(block)) {
                    type = 32;
                    stsucc = dummyexit;
                } else if (succ.id == graph.getLast().id) {
                    type = 4;
                    stsucc = dummyexit;
                } else {
                    type = 1;
                }
                stat.addSuccessor(new StatEdge(type, stat, stsucc, type == 1 ? null : general));
            }
            for (BasicBlock succex : block.getSuccExceptions()) {
                Statement stsuccex = (Statement)stats.getWithKey(succex.id);
                ExceptionRangeCFG range = graph.getExceptionRange(succex, block);
                if (range.isCircular()) continue;
                stat.addSuccessor(new StatEdge(stat, stsuccex, range.getExceptionTypes()));
            }
        }
        general.buildContinueSet();
        general.buildMonitorFlags();
        return new RootStatement(general, dummyexit, mt);
    }

    public static VBStyleCollection<List<Integer>, Integer> calcPostDominators(Statement general) {
        HashMap<Statement, FastFixedSet<Statement>> lists = new HashMap<Statement, FastFixedSet<Statement>>();
        StrongConnectivityHelper schelper = new StrongConnectivityHelper(general);
        List<List<Statement>> components = schelper.getComponents();
        List<Statement> lstStats = general.getPostReversePostOrderList(StrongConnectivityHelper.getExitReps(components));
        FastFixedSetFactory<Statement> factory = FastFixedSetFactory.create(lstStats);
        FastFixedSet<Statement> setFlagNodes = factory.createCopiedSet();
        FastFixedSet<Statement> initSet = factory.createCopiedSet();
        for (List<Statement> component : components) {
            FastFixedSet<Statement> tmpSet;
            if (StrongConnectivityHelper.isExitComponent(component)) {
                tmpSet = factory.createEmptySet();
                tmpSet.addAll(component);
            } else {
                tmpSet = initSet.getCopy();
            }
            for (Statement stat : component) {
                lists.put(stat, tmpSet);
            }
        }
        do {
            for (Statement stat : lstStats) {
                if (!setFlagNodes.contains(stat)) continue;
                setFlagNodes.remove(stat);
                FastFixedSet doms = (FastFixedSet)lists.get(stat);
                FastFixedSet<Statement> domsSuccs = factory.createEmptySet();
                List<Statement> successors = stat.getNeighbours(1, Statement.EdgeDirection.FORWARD);
                for (int j = 0; j < successors.size(); ++j) {
                    Statement succ = successors.get(j);
                    FastFixedSet succlst = (FastFixedSet)lists.get(succ);
                    if (j == 0) {
                        domsSuccs.union(succlst);
                        continue;
                    }
                    domsSuccs.intersection(succlst);
                }
                if (!domsSuccs.contains(stat)) {
                    domsSuccs.add(stat);
                }
                if (InterpreterUtil.equalObjects(domsSuccs, doms)) continue;
                lists.put(stat, domsSuccs);
                List<Statement> lstPreds = stat.getNeighbours(1, Statement.EdgeDirection.BACKWARD);
                for (Statement pred : lstPreds) {
                    setFlagNodes.add(pred);
                }
            }
        } while (!setFlagNodes.isEmpty());
        VBStyleCollection<List<Integer>, Integer> postDominators = new VBStyleCollection<List<Integer>, Integer>();
        List<Statement> lstRevPost = general.getReversePostOrderList();
        HashMap<Integer, Integer> mapSortOrder = new HashMap<Integer, Integer>();
        for (int i = 0; i < lstRevPost.size(); ++i) {
            mapSortOrder.put(lstRevPost.get((int)i).id, i);
        }
        for (Statement st : lstStats) {
            ArrayList<Integer> lstPosts = new ArrayList<Integer>();
            for (Statement stt : (FastFixedSet)lists.get(st)) {
                lstPosts.add(stt.id);
            }
            lstPosts.sort(Comparator.comparing(mapSortOrder::get));
            if (lstPosts.size() > 1 && (Integer)lstPosts.get(0) == st.id) {
                lstPosts.add((Integer)lstPosts.remove(0));
            }
            postDominators.addWithKey(lstPosts, st.id);
        }
        return postDominators;
    }

    public static RootStatement parseGraph(ControlFlowGraph graph, StructMethod mt, int iteration) {
        RootStatement root = DomHelper.graphToStatement(graph, mt);
        root.addComments(graph);
        DomTracer tracer = new DomTracer("domhelper_" + iteration, mt);
        if (!DomHelper.processStatement(root, root, new LinkedHashMap<Integer, Set<Integer>>(), tracer)) {
            DotExporter.errorToDotFile(graph, mt, "parseGraphFail");
            DotExporter.errorToDotFile(root, mt, "parseGraphFailStat");
            throw new RuntimeException("parsing failure!");
        }
        MethodProcessor.debugCurrentlyDecompiling.set(root);
        LabelHelper.lowContinueLabels(root, new LinkedHashSet<StatEdge>());
        SequenceHelper.condenseSequences(root);
        root.buildMonitorFlags();
        DomHelper.buildSynchronized(root);
        return root;
    }

    public static boolean removeSynchronizedHandler(Statement stat) {
        boolean res = false;
        for (Statement st : stat.getStats()) {
            res |= DomHelper.removeSynchronizedHandler(st);
        }
        if (stat instanceof SynchronizedStatement) {
            ((SynchronizedStatement)stat).removeExc();
            res = true;
        }
        return res;
    }

    public static boolean buildSynchronized(Statement stat) {
        boolean res;
        block10: {
            boolean found;
            res = false;
            for (Statement st : stat.getStats()) {
                res |= DomHelper.buildSynchronized(st);
            }
            if (!(stat instanceof SequenceStatement)) break block10;
            block1: do {
                found = false;
                VBStyleCollection<Statement, Integer> lst = stat.getStats();
                for (int i = 0; i < lst.size() - 1; ++i) {
                    Statement next;
                    Statement current = (Statement)lst.get(i);
                    if (!current.isMonitorEnter()) continue;
                    Statement nextDirect = next = (Statement)lst.get(i + 1);
                    while (next instanceof SequenceStatement) {
                        next = next.getFirst();
                    }
                    if (!(next instanceof CatchAllStatement)) continue;
                    CatchAllStatement ca = (CatchAllStatement)next;
                    boolean headOk = ca.getFirst().containsMonitorExitOrAthrow();
                    if (!headOk) {
                        headOk = DomHelper.hasNoExits(ca.getFirst());
                    }
                    if (!headOk) {
                        headOk = ca.isFinally();
                    }
                    if (!headOk || !ca.getHandler().containsMonitorExit()) continue;
                    ca.getFirst().markMonitorexitDead();
                    ca.getHandler().markMonitorexitDead();
                    for (StatEdge edge : ca.getSuccessorEdgeView(1)) {
                        edge.getDestination().markMonitorexitDead();
                    }
                    for (StatEdge edge : ca.getParent().getSuccessorEdgeView(1)) {
                        edge.getDestination().markMonitorexitDead();
                    }
                    current.removeSuccessor(current.getSuccessorEdges(0x40000000).get(0));
                    for (StatEdge edge : current.getPredecessorEdges(0x40000000)) {
                        current.removePredecessor(edge);
                        edge.getSource().changeEdgeNode(Statement.EdgeDirection.FORWARD, edge, nextDirect);
                        nextDirect.addPredecessor(edge);
                    }
                    stat.getStats().removeWithKey(current.id);
                    stat.setFirst((Statement)stat.getStats().get(0));
                    SynchronizedStatement sync = new SynchronizedStatement(current, ca.getFirst(), ca.getHandler());
                    sync.setAllParent();
                    for (StatEdge edge : new HashSet<StatEdge>(ca.getLabelEdges())) {
                        sync.addLabeledEdge(edge);
                    }
                    current.addSuccessor(new StatEdge(1, current, ca.getFirst()));
                    ca.getParent().replaceStatement(ca, sync);
                    found = true;
                    res = true;
                    continue block1;
                }
            } while (found);
        }
        return res;
    }

    private static boolean hasNoExits(Statement head) {
        ArrayDeque<Statement> stack = new ArrayDeque<Statement>();
        stack.add(head);
        while (!stack.isEmpty()) {
            Statement stat = (Statement)stack.removeFirst();
            List<StatEdge> sucs = stat.getSuccessorEdges(0x40000000);
            for (StatEdge suc : sucs) {
                if (head.containsStatement(suc.getDestination())) continue;
                return false;
            }
            stack.addAll(stat.getStats());
        }
        return true;
    }

    private static boolean processStatement(Statement general, RootStatement root, HashMap<Integer, Set<Integer>> mapExtPost, DomTracer tracer) {
        tracer.info(general, "process statement");
        if (general instanceof RootStatement) {
            Statement stat = general.getFirst();
            if (stat instanceof BasicBlockStatement) {
                return true;
            }
            boolean complete = DomHelper.processStatement(stat, root, mapExtPost, tracer);
            if (complete) {
                general.replaceStatement(stat, stat.getFirst());
            }
            return complete;
        }
        boolean mapRefreshed = mapExtPost.isEmpty();
        for (int mapstage = 0; mapstage < 2; ++mapstage) {
            for (int reducibility = 0; reducibility < 5; ++reducibility) {
                if (reducibility > 0) {
                    if (IrreducibleCFGDeobfuscator.isStatementIrreducible(general)) {
                        if (!IrreducibleCFGDeobfuscator.splitIrreducibleNode(general)) {
                            tracer.error(general, "Could not split irreducible flow");
                            DecompilerContext.getLogger().writeMessage("Irreducible statement cannot be decomposed!", IFernflowerLogger.Severity.ERROR);
                            break;
                        }
                        tracer.warn(general, "Split irreducible flow: " + reducibility);
                        if (reducibility == 4 && (mapstage == 1 || mapRefreshed)) {
                            DecompilerContext.getLogger().writeMessage("Irreducible statement too complex to be decomposed!", IFernflowerLogger.Severity.ERROR);
                            tracer.error(general, "Flow too complex to be decomposed!");
                            root.addComment("$VF: Irreducible bytecode has more than 5 nodes in sequence and was not entirely decomposed", true);
                        }
                    } else {
                        tracer.error(general, "Flow not irreducible, but could not decompose");
                        if (mapstage != 1 && !mapRefreshed) break;
                        DecompilerContext.getLogger().writeMessage("Statement cannot be decomposed although reducible!", IFernflowerLogger.Severity.ERROR);
                        break;
                    }
                    root.addComment("$VF: Irreducible bytecode was duplicated to produce valid code");
                    mapExtPost = new HashMap();
                    mapRefreshed = true;
                }
                for (int i = 0; i < 2; ++i) {
                    boolean forceall;
                    boolean bl = forceall = i != 0;
                    if (forceall) {
                        tracer.info(general, "Force-all iteration");
                    } else {
                        tracer.info(general, "First iteration");
                    }
                    while (true) {
                        tracer.info(general, "Find simple statements");
                        if (DomHelper.findSimpleStatements(general, mapExtPost, tracer)) {
                            tracer.success(general, "Found some simple statements");
                            reducibility = 0;
                        }
                        if (((GeneralStatement)general).isPlaceholder()) {
                            tracer.success(general, "All simple statements found");
                            return true;
                        }
                        Statement stat = DomHelper.findGeneralStatement(general, forceall, mapExtPost);
                        if (stat == null) break;
                        tracer.successCreated(general, "Found general statement: " + String.valueOf(stat) + " (" + String.valueOf(stat.getStats()) + ")", stat);
                        boolean complete = DomHelper.processStatement(stat, root, general.getFirst() == stat ? mapExtPost : new HashMap<Integer, Set<Integer>>(), tracer);
                        if (!complete) {
                            tracer.error(general, "General statement processing failed! " + String.valueOf(stat));
                            return false;
                        }
                        general.replaceStatement(stat, stat.getFirst());
                        tracer.success(general, "General statement processing success " + String.valueOf(stat));
                        mapExtPost = new HashMap();
                        mapRefreshed = true;
                        reducibility = 0;
                    }
                    tracer.info(general, "No new general statement found");
                }
            }
            if (mapRefreshed) {
                tracer.error(general, "Map already refreshed");
                break;
            }
            mapExtPost = new HashMap();
            tracer.info(general, "Refreshing map for retry");
        }
        tracer.error(general, "Unable to decompose!");
        return false;
    }

    private static Statement findGeneralStatement(Statement stat, boolean forceall, HashMap<Integer, Set<Integer>> mapExtPost) {
        VBStyleCollection<List<Integer>, Integer> vbPost;
        VBStyleCollection<Statement, Integer> stats = stat.getStats();
        if (mapExtPost.isEmpty()) {
            FastExtendedPostdominanceHelper extpost = new FastExtendedPostdominanceHelper();
            mapExtPost.putAll(extpost.getExtendedPostdominators(stat));
        }
        if (forceall) {
            vbPost = new VBStyleCollection();
            List<Statement> lstAll = stat.getPostReversePostOrderList();
            for (Statement statement : lstAll) {
                Set<Integer> set = mapExtPost.get(statement.id);
                if (set == null) continue;
                ArrayList<Integer> element = new ArrayList<Integer>(set.size());
                for (Integer integer : set) {
                    if (stats.containsKey(integer) && stats.getWithKey(integer).hasSuccessor(32)) continue;
                    element.add(integer);
                }
                vbPost.addWithKey(element, statement.id);
            }
            Set<Integer> setFirst = mapExtPost.get(stat.getFirst().id);
            if (setFirst != null) {
                for (int id : setFirst) {
                    List<Integer> lst = vbPost.getWithKey(id);
                    if (lst == null) {
                        lst = new ArrayList<Integer>();
                        vbPost.addWithKey(lst, id);
                    }
                    lst.add(id);
                }
            }
        } else {
            vbPost = DomHelper.calcPostDominators(stat);
        }
        for (int k = 0; k < vbPost.size(); ++k) {
            int headid = vbPost.getKey(k);
            List list = (List)vbPost.get(k);
            if (!mapExtPost.containsKey(headid) && (list.size() != 1 || !((Integer)list.get(0)).equals(headid))) continue;
            Statement head = stats.getWithKey(headid);
            Set<Integer> setExtPosts = mapExtPost.get(headid);
            for (int postId : list) {
                boolean handlerFound;
                Statement post;
                if (postId != headid && !setExtPosts.contains(postId) || (post = stats.getWithKey(postId)) == null) continue;
                boolean same = post == head;
                LinkedHashSet<Statement> setNodes = new LinkedHashSet<Statement>();
                HashSet<Statement> setPreds = new HashSet<Statement>();
                LinkedHashSet<Statement> setHandlers = new LinkedHashSet<Statement>();
                setHandlers.add(head);
                block5: do {
                    handlerFound = false;
                    for (Statement handler : setHandlers) {
                        boolean addHandler;
                        if (setNodes.contains(handler)) continue;
                        boolean bl = addHandler = setNodes.size() == 0;
                        if (!addHandler) {
                            List<Statement> hdsupp = handler.getNeighbours(2, Statement.EdgeDirection.BACKWARD);
                            boolean bl2 = addHandler = setNodes.containsAll(hdsupp) && (setNodes.size() > hdsupp.size() || setNodes.size() == 1);
                        }
                        if (!addHandler) continue;
                        LinkedList<Statement> lstStack = new LinkedList<Statement>();
                        lstStack.add(handler);
                        while (!lstStack.isEmpty()) {
                            Statement st2 = (Statement)lstStack.remove(0);
                            if (setNodes.contains(st2) || !same && st2 == post) continue;
                            setNodes.add(st2);
                            if (st2 != head) {
                                setPreds.addAll(st2.getNeighbours(1, Statement.EdgeDirection.BACKWARD));
                            }
                            lstStack.addAll(st2.getNeighbours(1, Statement.EdgeDirection.FORWARD));
                            setHandlers.addAll(st2.getNeighbours(2, Statement.EdgeDirection.FORWARD));
                        }
                        handlerFound = true;
                        setHandlers.remove(handler);
                        continue block5;
                    }
                } while (handlerFound);
                setHandlers.clear();
                for (Statement statement : setNodes) {
                    setHandlers.addAll(statement.getNeighbours(2, Statement.EdgeDirection.FORWARD));
                }
                setHandlers.removeAll(setNodes);
                boolean exceptionsOk = true;
                for (Statement handler : setHandlers) {
                    List<Statement> exceptionRange = handler.getNeighbours(2, Statement.EdgeDirection.BACKWARD);
                    if (exceptionRange.containsAll(setNodes)) continue;
                    exceptionsOk = false;
                    break;
                }
                if (!exceptionsOk) continue;
                setPreds.removeAll(setNodes);
                if (!setPreds.isEmpty() || setNodes.size() <= 1 && !head.getNeighbours(1, Statement.EdgeDirection.BACKWARD).contains(head) || setNodes.size() >= stats.size() || !DomHelper.checkSynchronizedCompleteness(setNodes)) continue;
                GeneralStatement generalStatement = new GeneralStatement(head, setNodes, same ? null : post);
                stat.collapseNodesToStatement(generalStatement);
                return generalStatement;
            }
        }
        return null;
    }

    private static boolean checkSynchronizedCompleteness(Set<Statement> setNodes) {
        for (Statement stat : setNodes) {
            if (!stat.isMonitorEnter()) continue;
            List<StatEdge> lstSuccs = stat.getSuccessorEdges(0x40000000);
            if (lstSuccs.size() != 1 || lstSuccs.get(0).getType() != 1) {
                return false;
            }
            if (setNodes.contains(lstSuccs.get(0).getDestination())) continue;
            return false;
        }
        return true;
    }

    private static boolean findSimpleStatements(Statement stat, HashMap<Integer, Set<Integer>> mapExtPost, DomTracer tracer) {
        boolean found;
        boolean success = false;
        do {
            found = false;
            List<Statement> lstStats = stat.getPostReversePostOrderList();
            for (Statement st : lstStats) {
                Statement result = DomHelper.detectStatement(st);
                if (result == null) continue;
                if (stat instanceof GeneralStatement && !((GeneralStatement)stat).isPlaceholder() && result.getFirst() == stat.getFirst() && stat.getStats().size() == result.getStats().size()) {
                    ((GeneralStatement)stat).setPlaceholder(true);
                }
                stat.collapseNodesToStatement(result);
                tracer.successCreated(stat, "Transformed " + String.valueOf(st) + " to " + String.valueOf(result) + " (" + String.valueOf(result.getStats()) + ")", result);
                if (!mapExtPost.isEmpty()) {
                    HashSet<Integer> setOldNodes = new HashSet<Integer>();
                    for (Statement old : result.getStats()) {
                        setOldNodes.add(old.id);
                    }
                    Integer newid = result.id;
                    for (int key : new ArrayList<Integer>(mapExtPost.keySet())) {
                        Set<Integer> set = mapExtPost.get(key);
                        int oldsize = set.size();
                        set.removeAll(setOldNodes);
                        if (setOldNodes.contains(key)) {
                            mapExtPost.computeIfAbsent(newid, k -> new LinkedHashSet()).addAll(set);
                            mapExtPost.remove(key);
                            continue;
                        }
                        if (set.size() >= oldsize) continue;
                        set.add(newid);
                    }
                }
                found = true;
                break;
            }
            if (!found) continue;
            success = true;
        } while (found);
        return success;
    }

    private static Statement detectStatement(Statement head) {
        Statement res = DoStatement.isHead(head);
        if (res != null) {
            return res;
        }
        res = SwitchStatement.isHead(head);
        if (res != null) {
            return res;
        }
        res = IfStatement.isHead(head);
        if (res != null) {
            return res;
        }
        res = SequenceStatement.isHead2Block(head);
        if (res != null) {
            return res;
        }
        res = CatchStatement.isHead(head);
        if (res != null) {
            return res;
        }
        res = CatchAllStatement.isHead(head);
        if (res != null) {
            return res;
        }
        return null;
    }
}

