/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.plugins;

import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.java.decompiler.main.plugins.InJarClassLoader;

public class JarPluginLoader {
    static List<Class<?>> PLUGIN_CLASSES = new ArrayList();

    public static void init() {
        block11: {
            try {
                HashMap env;
                File myFile = new File(JarPluginLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                if (!myFile.exists() || myFile.isDirectory() || !myFile.getPath().endsWith(".jar")) break block11;
                URI uri = URI.create("jar:" + String.valueOf(myFile.toURI()));
                FileSystem zipfs = FileSystems.newFileSystem(uri, env = new HashMap());
                Path pluginsDir = zipfs.getPath("META-INF", "plugins");
                if (!Files.exists(pluginsDir, new LinkOption[0])) {
                    zipfs.close();
                    return;
                }
                try (Stream<Path> pluginStream = Files.list(pluginsDir);){
                    List plugins = pluginStream.collect(Collectors.toList());
                    for (Path pluginJar : plugins) {
                        FileSystem pluginfs = FileSystems.newFileSystem(pluginJar, (ClassLoader)null);
                        Path file = pluginfs.getPath("META-INF", "services", "org.jetbrains.java.decompiler.api.plugin.Plugin");
                        if (!Files.exists(file, new LinkOption[0])) {
                            pluginfs.close();
                            continue;
                        }
                        String pluginClass = Files.readString(file);
                        InJarClassLoader loader = new InJarClassLoader(pluginfs, JarPluginLoader.class.getClassLoader());
                        Class<?> clazz = Class.forName(pluginClass, true, loader);
                        PLUGIN_CLASSES.add(clazz);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

