/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.kohsuke.github.GHApp;
import org.kohsuke.github.GHAppInstallationToken;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;

public class GitHubAppCredentials {
    private static final String PKCS1_KEY_START = "-----BEGIN RSA PRIVATE KEY-----\n";
    private static final String PKCS1_KEY_END = "-----END RSA PRIVATE KEY-----";
    private static final String PKCS8_KEY_START = "-----BEGIN PRIVATE KEY-----\n";
    private static final String PKCS8_KEY_END = "-----END PRIVATE KEY-----";

    public static PrivateKey parsePKCS8(String input) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] key;
        if (input.startsWith(PKCS8_KEY_START)) {
            input = input.replace(PKCS8_KEY_START, "").replace(PKCS8_KEY_END, "").replaceAll("\\s", "");
            key = Base64.getDecoder().decode(input);
        } else {
            input = input.replace(PKCS1_KEY_START, "").replace(PKCS1_KEY_END, "").replaceAll("\\s", "");
            byte[] pkcs1Encoded = Base64.getDecoder().decode(input);
            AlgorithmIdentifier algId = new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE);
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algId, ASN1Sequence.getInstance(pkcs1Encoded));
            key = privateKeyInfo.getEncoded();
        }
        return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(key));
    }

    public static CredentialsProvider jwt(final String appId, final PrivateKey privateKey, final TokenGetter tokenGetter) {
        return new CredentialsProvider(){
            private Jwt jwt = null;

            @Override
            public boolean isInteractive() {
                return false;
            }

            @Override
            public boolean supports(CredentialItem ... items) {
                for (CredentialItem i : items) {
                    if (i instanceof CredentialItem.InformationalMessage || i instanceof CredentialItem.Username || i instanceof CredentialItem.Password || i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
                try {
                    for (CredentialItem i : items) {
                        if (i instanceof CredentialItem.InformationalMessage) continue;
                        if (i instanceof CredentialItem.Username) {
                            ((CredentialItem.Username)i).setValue(this.jwt());
                            continue;
                        }
                        if (i instanceof CredentialItem.Password) {
                            ((CredentialItem.Password)i).setValue(this.jwt().toCharArray());
                            continue;
                        }
                        if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                            ((CredentialItem.StringType)i).setValue(new String(this.jwt()));
                            continue;
                        }
                        throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
                    }
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
                return true;
            }

            public String jwt() throws IOException {
                Instant now = Instant.now();
                if (this.jwt == null) {
                    this.jwt = this.newJwt();
                } else if (now.isAfter(this.jwt.expirationDate())) {
                    this.jwt = this.newJwt();
                }
                return this.jwt.jwt();
            }

            public Jwt newJwt() throws IOException {
                GitHub gitHub = new GitHubBuilder().withJwtToken(GitHubAppCredentials.refreshJWT(appId, privateKey)).build();
                GHAppInstallationToken token = tokenGetter.getToken(gitHub.getApp());
                return new Jwt(token.getExpiresAt().toInstant(), token.getToken());
            }
        };
    }

    private static String refreshJWT(String appId, PrivateKey privateKey) {
        Instant now = Instant.now();
        Instant exp = now.plus(Duration.ofMinutes(10L));
        JwtBuilder builder = ((JwtBuilder)((JwtBuilder)((JwtBuilder)Jwts.builder().setIssuedAt(Date.from(now))).setExpiration(Date.from(exp))).setIssuer(appId)).signWith(privateKey, SignatureAlgorithm.RS256);
        return builder.compact();
    }

    public static interface TokenGetter {
        public GHAppInstallationToken getToken(GHApp var1) throws IOException;
    }

    public record Jwt(Instant expirationDate, String jwt) {
    }
}

