/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.installertools.util;

import java.io.File;
import java.util.Locale;

public class Artifact {
    private String group;
    private String name;
    private String version;
    private String classifier = null;
    private String ext = "jar";
    private String path;
    private String file;
    private String descriptor;
    private boolean isSnapshot = false;

    public static Artifact from(String descriptor) {
        Artifact ret = new Artifact();
        ret.descriptor = descriptor;
        String[] pts = descriptor.split(":");
        ret.group = pts[0];
        ret.name = pts[1];
        int last = pts.length - 1;
        int idx = pts[last].indexOf(64);
        if (idx != -1) {
            ret.ext = pts[last].substring(idx + 1);
            pts[last] = pts[last].substring(0, idx);
        }
        ret.version = pts[2];
        ret.isSnapshot = ret.version.toLowerCase(Locale.ENGLISH).endsWith("-snapshot");
        if (pts.length > 3) {
            ret.classifier = pts[3];
        }
        ret.file = ret.name + '-' + ret.version;
        if (ret.classifier != null) {
            ret.file = ret.file + '-' + ret.classifier;
        }
        ret.file = ret.file + '.' + ret.ext;
        ret.path = String.join((CharSequence)"/", ret.group.replace('.', '/'), ret.name, ret.version, ret.file);
        return ret;
    }

    public static Artifact from(String group, String name, String version, String classifier, String ext) {
        StringBuilder buf = new StringBuilder();
        buf.append(group).append(':').append(name).append(':').append(version);
        if (classifier != null) {
            buf.append(':').append(classifier);
        }
        if (ext != null && !"jar".equals(ext)) {
            buf.append('@').append(ext);
        }
        return Artifact.from(buf.toString());
    }

    public File getLocalFile(File base) {
        return new File(base, this.getLocalPath());
    }

    public String getLocalPath() {
        return this.path.replace('/', File.separatorChar);
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getPath() {
        return this.path;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.ext;
    }

    public String getFilename() {
        return this.file;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    public Artifact withVersion(String version) {
        return Artifact.from(this.group, this.name, version, this.classifier, this.ext);
    }

    public String toString() {
        return this.getDescriptor();
    }
}

