/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.installertools;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.stream.Collectors;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import net.neoforged.installertools.Task;

public class ExtractFiles
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> archiveO = parser.accepts("archive", "The archive").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<String> fromO = parser.accepts("from", "File in the archive to extract").withRequiredArg().ofType(String.class).required();
        ArgumentAcceptingOptionSpec<File> toO = parser.accepts("to", "Path to extract file to").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec<File> optionalO = parser.accepts("optional", "Optional paths to extract files to only if they don't already exist").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec<File> execsO = parser.accepts("execs", "A file to set the executable flag on").withRequiredArg().ofType(File.class);
        try {
            OptionSet options = parser.parse(args);
            File archive = options.valueOf(archiveO);
            List<String> from = options.valuesOf(fromO);
            List<File> to = options.valuesOf(toO);
            if (from.size() != to.size()) {
                throw new IllegalArgumentException("Invalid arguments, must have matching from/to set");
            }
            List<File> execs = options.valuesOf(execsO);
            List optional = options.valuesOf(optionalO).stream().map(File::getAbsolutePath).collect(Collectors.toList());
            this.log("Archive: " + archive);
            for (int x = 0; x < from.size(); ++x) {
                this.log("Extract: " + from.get(x));
                this.log("         " + to.get(x));
            }
            for (File file : execs) {
                this.log("Exec:    " + file);
            }
            if (!archive.exists()) {
                this.error("Could not find archive: " + archive);
            }
            PROGRESS.setMaxProgress(from.size() + execs.size());
            int amount = 0;
            try (FileSystem fs = FileSystems.newFileSystem(archive.toPath(), null);){
                for (int x = 0; x < from.size(); ++x) {
                    File toF;
                    Path path = fs.getPath(from.get(x), new String[0]);
                    if (!Files.exists(path, new LinkOption[0])) {
                        this.log("Could not find file in archive: " + from.get(x));
                    }
                    if (!(toF = to.get(x)).getParentFile().exists() && !toF.getParentFile().mkdirs()) {
                        this.error("Couldn't make parent directory: " + toF.getParentFile().getAbsolutePath());
                    }
                    if (!optional.contains(toF.getAbsolutePath()) || !toF.exists()) {
                        Files.copy(path, toF.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    PROGRESS.setProgress(++amount);
                }
            }
            for (File exec : execs) {
                if (!exec.setExecutable(true)) {
                    this.log("Couldn't set executable bit for file: " + exec.getAbsolutePath());
                }
                PROGRESS.setProgress(++amount);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }
}

