/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github.extras.authorization;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import javax.annotation.Nonnull;
import org.kohsuke.github.authorization.AuthorizationProvider;

public class JWTTokenProvider
implements AuthorizationProvider {
    private final PrivateKey privateKey;
    @Nonnull
    private Instant validUntil = Instant.MIN;
    private String authorization;
    private final String applicationId;

    public JWTTokenProvider(String applicationId, File keyFile) throws GeneralSecurityException, IOException {
        this(applicationId, keyFile.toPath());
    }

    public JWTTokenProvider(String applicationId, Path keyPath) throws GeneralSecurityException, IOException {
        this(applicationId, new String(Files.readAllBytes(keyPath), StandardCharsets.UTF_8));
    }

    public JWTTokenProvider(String applicationId, String keyString) throws GeneralSecurityException {
        this(applicationId, JWTTokenProvider.getPrivateKeyFromString(keyString));
    }

    public JWTTokenProvider(String applicationId, PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.applicationId = applicationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEncodedAuthorization() throws IOException {
        JWTTokenProvider jWTTokenProvider = this;
        synchronized (jWTTokenProvider) {
            if (this.isNotValid()) {
                String token = this.refreshJWT();
                this.authorization = String.format("Bearer %s", token);
            }
            return this.authorization;
        }
    }

    boolean isNotValid() {
        return Instant.now().isAfter(this.validUntil);
    }

    private static PrivateKey getPrivateKeyFromString(String key) throws GeneralSecurityException {
        if (key.contains(" RSA ")) {
            throw new InvalidKeySpecException("Private key must be a PKCS#8 formatted string, to convert it from PKCS#1 use: openssl pkcs8 -topk8 -inform PEM -outform PEM -in current-key.pem -out new-key.pem -nocrypt");
        }
        String privateKeyContent = key.replaceAll("(?m)^--.*", "").replaceAll("\\s", "");
        KeyFactory kf = KeyFactory.getInstance("RSA");
        try {
            byte[] decode = Base64.getDecoder().decode(privateKeyContent);
            PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(decode);
            return kf.generatePrivate(keySpecPKCS8);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidKeySpecException("Failed to decode private key: " + e.getMessage(), e);
        }
    }

    private String refreshJWT() {
        Instant now = Instant.now();
        Instant expiration = now.plus(Duration.ofMinutes(8L));
        Instant issuedAt = this.getIssuedAt(now);
        JwtBuilder builder = Jwts.builder().setIssuedAt(Date.from(issuedAt)).setExpiration(Date.from(expiration)).setIssuer(this.applicationId).signWith(this.privateKey, SignatureAlgorithm.RS256);
        this.validUntil = expiration.minus(Duration.ofMinutes(2L));
        return builder.compact();
    }

    Instant getIssuedAt(Instant now) {
        return now.minus(Duration.ofMinutes(2L));
    }
}

