/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Array;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.connector.GitHubConnectorResponse;

class GitHubResponse<T> {
    private static final Logger LOGGER = Logger.getLogger(GitHubResponse.class.getName());
    private final int statusCode;
    @Nonnull
    private final Map<String, List<String>> headers;
    @CheckForNull
    private final T body;

    GitHubResponse(GitHubResponse<T> response, @CheckForNull T body) {
        this.statusCode = response.statusCode();
        this.headers = response.headers;
        this.body = body;
    }

    GitHubResponse(GitHubConnectorResponse connectorResponse, @CheckForNull T body) {
        this.statusCode = connectorResponse.statusCode();
        this.headers = connectorResponse.allHeaders();
        this.body = body;
    }

    @CheckForNull
    static <T> T parseBody(GitHubConnectorResponse connectorResponse, Class<T> type) throws IOException {
        if (connectorResponse.statusCode() == 204) {
            if (type != null && type.isArray()) {
                return type.cast(Array.newInstance(type.getComponentType(), 0));
            }
            return null;
        }
        String data = GitHubResponse.getBodyAsString(connectorResponse);
        try {
            InjectableValues.Std inject = new InjectableValues.Std();
            inject.addValue(GitHubConnectorResponse.class, (Object)connectorResponse);
            return GitHubClient.getMappingObjectReader(connectorResponse).forType(type).readValue(data);
        }
        catch (JsonParseException | JsonMappingException e) {
            String message = "Failed to deserialize: " + data;
            LOGGER.log(Level.FINE, message);
            throw e;
        }
    }

    @CheckForNull
    static <T> T parseBody(GitHubConnectorResponse connectorResponse, T instance) throws IOException {
        String data = GitHubResponse.getBodyAsString(connectorResponse);
        try {
            return GitHubClient.getMappingObjectReader(connectorResponse).withValueToUpdate(instance).readValue(data);
        }
        catch (JsonParseException | JsonMappingException e) {
            String message = "Failed to deserialize: " + data;
            LOGGER.log(Level.FINE, message);
            throw e;
        }
    }

    @Nonnull
    static String getBodyAsString(GitHubConnectorResponse connectorResponse) throws IOException {
        InputStream inputStream = connectorResponse.bodyStream();
        try (InputStreamReader r = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            String string = IOUtils.toString(r);
            return string;
        }
    }

    static String getBodyAsStringOrNull(GitHubConnectorResponse connectorResponse) {
        try {
            return GitHubResponse.getBodyAsString(connectorResponse);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Nonnull
    public List<String> headers(String field) {
        return this.headers.get(field);
    }

    @CheckForNull
    public String header(String name) {
        String result = null;
        List<String> rawResult = this.headers.get(name);
        if (rawResult != null) {
            result = rawResult.get(0);
        }
        return result;
    }

    public T body() {
        return this.body;
    }
}

