/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdge;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectEdgeType;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.flow.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.flow.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class PPandMMHelper {
    private boolean exprentReplaced;
    private VarProcessor varProc;
    private DirectGraph dgraph;

    public PPandMMHelper(VarProcessor varProc) {
        this.varProc = varProc;
    }

    public boolean findPPandMM(RootStatement root) {
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        this.dgraph = flatthelper.buildDirectGraph(root);
        LinkedList<DirectNode> stack = new LinkedList<DirectNode>();
        stack.add(this.dgraph.first);
        HashSet<DirectNode> setVisited = new HashSet<DirectNode>();
        boolean res = false;
        while (!stack.isEmpty()) {
            DirectNode node = (DirectNode)stack.removeFirst();
            if (setVisited.contains(node)) continue;
            setVisited.add(node);
            res |= this.processExprentList(node.exprents);
            for (DirectEdge suc : node.getSuccessors(DirectEdgeType.REGULAR)) {
                stack.add(suc.getDestination());
            }
        }
        return res;
    }

    private boolean processExprentList(List<Exprent> lst) {
        boolean result = false;
        for (int i = 0; i < lst.size(); ++i) {
            Exprent exprent = lst.get(i);
            this.exprentReplaced = false;
            Exprent retexpr = this.processExprentRecursive(exprent);
            if (retexpr != null) {
                lst.set(i, retexpr);
                result = true;
                --i;
            }
            result |= this.exprentReplaced;
        }
        return result;
    }

    private Exprent processExprentRecursive(Exprent exprent) {
        AssignmentExprent as;
        boolean replaced = true;
        block0: while (replaced) {
            replaced = false;
            for (Exprent expr : exprent.getAllExprents()) {
                Exprent retexpr = this.processExprentRecursive(expr);
                if (retexpr == null) continue;
                exprent.replaceExprent(expr, retexpr);
                retexpr.addBytecodeOffsets(expr.bytecode);
                replaced = true;
                this.exprentReplaced = true;
                continue block0;
            }
        }
        if (exprent instanceof AssignmentExprent && (as = (AssignmentExprent)exprent).getRight() instanceof FunctionExprent) {
            FunctionExprent func = (FunctionExprent)as.getRight();
            VarType midlayer = func.getFuncType().castType;
            if (midlayer != null) {
                if (func.getLstOperands().get(0) instanceof FunctionExprent) {
                    func = (FunctionExprent)func.getLstOperands().get(0);
                } else {
                    return null;
                }
            }
            if (func.getFuncType() == FunctionExprent.FunctionType.ADD || func.getFuncType() == FunctionExprent.FunctionType.SUB) {
                Exprent econd = func.getLstOperands().get(0);
                Exprent econst = func.getLstOperands().get(1);
                if (!(econst instanceof ConstExprent) && econd instanceof ConstExprent && func.getFuncType() == FunctionExprent.FunctionType.ADD) {
                    econd = econst;
                    econst = func.getLstOperands().get(0);
                }
                if (econst instanceof ConstExprent && ((ConstExprent)econst).hasValueOne()) {
                    Exprent left = as.getLeft();
                    VarType condtype = left.getExprType();
                    if (this.exprsEqual(left, econd) && (midlayer == null || midlayer.equals(condtype))) {
                        FunctionExprent ret = new FunctionExprent(func.getFuncType() == FunctionExprent.FunctionType.ADD ? FunctionExprent.FunctionType.PPI : FunctionExprent.FunctionType.MMI, econd, func.bytecode);
                        ret.setImplicitType(condtype);
                        this.exprentReplaced = true;
                        if (!left.equals(econd)) {
                            this.updateVersions(this.dgraph, new VarVersionPair((VarExprent)left), new VarVersionPair((VarExprent)econd));
                        }
                        return ret;
                    }
                }
            }
        }
        return null;
    }

    private boolean exprsEqual(Exprent e1, Exprent e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1 instanceof VarExprent) {
            return this.varsEqual(e1, e2);
        }
        return e1.equals(e2);
    }

    private boolean varsEqual(Exprent e1, Exprent e2) {
        if (!(e1 instanceof VarExprent)) {
            return false;
        }
        if (!(e2 instanceof VarExprent)) {
            return false;
        }
        VarExprent v1 = (VarExprent)e1;
        VarExprent v2 = (VarExprent)e2;
        return this.varProc.getVarOriginalIndex(v1.getIndex()) == this.varProc.getVarOriginalIndex(v2.getIndex());
    }

    private void updateVersions(DirectGraph graph, final VarVersionPair oldVVP, final VarVersionPair newVVP) {
        graph.iterateExprents(new DirectGraph.ExprentIterator(){

            @Override
            public int processExprent(Exprent exprent) {
                List<Exprent> lst = exprent.getAllExprents(true);
                lst.add(exprent);
                for (Exprent expr : lst) {
                    VarExprent var;
                    if (!(expr instanceof VarExprent) || (var = (VarExprent)expr).getIndex() != oldVVP.var || var.getVersion() != oldVVP.version) continue;
                    var.setIndex(newVVP.var);
                    var.setVersion(newVVP.version);
                }
                return 0;
            }
        });
    }

    public static boolean inlinePPIandMMIIf(RootStatement stat) {
        boolean res = PPandMMHelper.inlinePPIandMMIIfRec(stat);
        if (res) {
            SequenceHelper.condenseSequences(stat);
        }
        return res;
    }

    private static boolean inlinePPIandMMIIfRec(Statement stat) {
        Exprent ifExpr;
        Exprent inner;
        FunctionExprent func;
        Exprent expr;
        IfStatement destination;
        boolean res = false;
        for (Statement st : stat.getStats()) {
            res |= PPandMMHelper.inlinePPIandMMIIfRec(st);
        }
        if (stat.getExprents() != null && !stat.getExprents().isEmpty() && (destination = PPandMMHelper.findIfSuccessor(stat)) != null && (expr = stat.getExprents().get(stat.getExprents().size() - 1)) instanceof FunctionExprent && ((func = (FunctionExprent)expr).getFuncType() == FunctionExprent.FunctionType.PPI || func.getFuncType() == FunctionExprent.FunctionType.MMI) && (inner = func.getLstOperands().get(0)) instanceof VarExprent && (ifExpr = destination.getHeadexprent().getCondition()) instanceof FunctionExprent) {
            Exprent innerFunc;
            FunctionExprent ifFunc = (FunctionExprent)ifExpr;
            while (ifFunc.getFuncType() == FunctionExprent.FunctionType.BOOL_NOT && (innerFunc = ifFunc.getLstOperands().get(0)) instanceof FunctionExprent) {
                ifFunc = (FunctionExprent)innerFunc;
            }
            boolean found = false;
            VarExprent old = null;
            for (Exprent ex : ifFunc.getAllExprents(true)) {
                FunctionExprent funcEx;
                if (ex instanceof VarExprent) {
                    VarExprent var = (VarExprent)ex;
                    if (var.getIndex() != ((VarExprent)inner).getIndex()) continue;
                    if (found) {
                        return false;
                    }
                    old = var;
                    found = true;
                    continue;
                }
                if (!(ex instanceof FunctionExprent) || (funcEx = (FunctionExprent)ex).getFuncType() != FunctionExprent.FunctionType.BOOLEAN_AND && funcEx.getFuncType() != FunctionExprent.FunctionType.BOOLEAN_OR) continue;
                return false;
            }
            if (found) {
                LinkedList<Exprent> stack = new LinkedList<Exprent>();
                stack.push(ifFunc);
                block3: while (!stack.isEmpty()) {
                    Exprent exprent = (Exprent)stack.pop();
                    for (Exprent ex : exprent.getAllExprents()) {
                        if (ex == old) {
                            exprent.replaceExprent(old, expr);
                            expr.addBytecodeOffsets(old.bytecode);
                            stack.clear();
                            continue block3;
                        }
                        stack.push(ex);
                    }
                }
                stat.getExprents().remove(expr);
                res = true;
                destination.setHasPPMM(true);
            }
        }
        return res;
    }

    private static IfStatement findIfSuccessor(Statement stat) {
        if (stat.getParent() instanceof IfStatement && stat.getParent().getFirst() == stat) {
            return (IfStatement)stat.getParent();
        }
        return null;
    }
}

