/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.extern;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

public interface IFernflowerPreferences {
    @Name(value="Remove Bridge Methods")
    @Description(value="Removes any methods that are marked as bridge from the decompiled output.")
    @ShortName(value="rbr")
    @Type(value="bool")
    public static final String REMOVE_BRIDGE = "remove-bridge";
    @Name(value="Remove Synthetic Methods And Fields")
    @Description(value="Removes any methods and fields that are marked as synthetic from the decompiled output.")
    @ShortName(value="rsy")
    @Type(value="bool")
    public static final String REMOVE_SYNTHETIC = "remove-synthetic";
    @Name(value="Decompile Inner Classes")
    @Description(value="Process inner classes and add them to the decompiled output.")
    @ShortName(value="din")
    @Type(value="bool")
    public static final String DECOMPILE_INNER = "decompile-inner";
    @Name(value="Decompile Java 4 class references")
    @Description(value="Resugar the Java 1-4 class reference format instead of leaving the synthetic code.")
    @ShortName(value="dc4")
    @Type(value="bool")
    public static final String DECOMPILE_CLASS_1_4 = "decompile-java4";
    @Name(value="Decompile Assertions")
    @Description(value="Decompile assert statements.")
    @ShortName(value="das")
    @Type(value="bool")
    public static final String DECOMPILE_ASSERTIONS = "decompile-assert";
    @Name(value="Hide Empty super()")
    @Description(value="Hide super() calls with no parameters.")
    @ShortName(value="hes")
    @Type(value="bool")
    public static final String HIDE_EMPTY_SUPER = "hide-empty-super";
    @Name(value="Hide Default Constructor")
    @Description(value="Hide constructors with no parameters and no code.")
    @ShortName(value="hdc")
    @Type(value="bool")
    public static final String HIDE_DEFAULT_CONSTRUCTOR = "hide-default-constructor";
    @Name(value="Decompile Generics")
    @Description(value="Decompile generics in classes, methods, fields, and variables.")
    @ShortName(value="dgs")
    @Type(value="bool")
    public static final String DECOMPILE_GENERIC_SIGNATURES = "decompile-generics";
    @Name(value="Incorporate returns in try-catch blocks")
    @Description(value="Integrate returns better in try-catch blocks instead of storing them in a temporary variable.")
    @ShortName(value="ner")
    @Type(value="bool")
    public static final String INCORPORATE_RETURNS = "incorporate-returns";
    @Name(value="Ensure synchronized ranges are complete")
    @Description(value="If a synchronized block has a monitorenter without any corresponding monitorexit, try to deduce where one should be to ensure the synchronized is correctly decompiled.")
    @ShortName(value="esm")
    @Type(value="bool")
    public static final String ENSURE_SYNCHRONIZED_MONITOR = "ensure-synchronized-monitors";
    @Name(value="Decompile Enums")
    @Description(value="Decompile enums.")
    @ShortName(value="den")
    @Type(value="bool")
    public static final String DECOMPILE_ENUM = "decompile-enums";
    @Name(value="Decompile Preview Features")
    @Description(value="Decompile features marked as preview or incubating in the latest Java versions.")
    @ShortName(value="dpr")
    @Type(value="bool")
    public static final String DECOMPILE_PREVIEW = "decompile-preview";
    @Name(value="Remove reference getClass()")
    @Description(value="Remove synthetic getClass() calls created by code such as 'obj.new Inner()'.")
    @ShortName(value="rgn")
    @Type(value="bool")
    public static final String REMOVE_GET_CLASS_NEW = "remove-getclass";
    @Name(value="Keep Literals As Is")
    @Description(value="Keep NaN, infinities, and pi values as is without resugaring them.")
    @ShortName(value="lit")
    @Type(value="bool")
    public static final String LITERALS_AS_IS = "keep-literals";
    @Name(value="Represent boolean as 0/1")
    @Description(value="Represent integers 0 and 1 as booleans.")
    @ShortName(value="bto")
    @Type(value="bool")
    public static final String BOOLEAN_TRUE_ONE = "boolean-as-int";
    @Name(value="ASCII String Characters")
    @Description(value="Encode non-ASCII characters in string and character literals as Unicode escapes.")
    @ShortName(value="asc")
    @Type(value="bool")
    public static final String ASCII_STRING_CHARACTERS = "ascii-strings";
    @Name(value="Synthetic Not Set")
    @Description(value="Treat some known structures as synthetic even when not explicitly set.")
    @ShortName(value="nns")
    @Type(value="bool")
    public static final String SYNTHETIC_NOT_SET = "synthetic-not-set";
    @Name(value="Treat Undefined Param Type As Object")
    @Description(value="Treat nameless types as java.lang.Object.")
    @ShortName(value="uto")
    @Type(value="bool")
    public static final String UNDEFINED_PARAM_TYPE_OBJECT = "undefined-as-object";
    @Name(value="Use LVT Names")
    @Description(value="Use LVT names for local variables and parameters instead of var<index>_<version>.")
    @ShortName(value="udv")
    @Type(value="bool")
    public static final String USE_DEBUG_VAR_NAMES = "use-lvt-names";
    @Name(value="Use Method Parameters")
    @Description(value="Use method parameter names, as given in the MethodParameters attribute.")
    @ShortName(value="ump")
    @Type(value="bool")
    public static final String USE_METHOD_PARAMETERS = "use-method-parameters";
    @Name(value="Remove Empty try-catch blocks")
    @Description(value="Remove try-catch blocks with no code.")
    @ShortName(value="rer")
    @Type(value="bool")
    public static final String REMOVE_EMPTY_RANGES = "remove-empty-try-catch";
    @Name(value="Decompile Finally")
    @Description(value="Decompile finally blocks.")
    @ShortName(value="fdi")
    @Type(value="bool")
    public static final String FINALLY_DEINLINE = "decompile-finally";
    @Name(value="Decompile Lambdas as Anonymous Classes")
    @Description(value="Decompile lambda expressions as anonymous classes.")
    @ShortName(value="lac")
    @Type(value="bool")
    public static final String LAMBDA_TO_ANONYMOUS_CLASS = "lambda-to-anonymous-class";
    @Name(value="Bytecode to Source Mapping")
    @Description(value="Map Bytecode to source lines.")
    @ShortName(value="bsm")
    @Type(value="bool")
    public static final String BYTECODE_SOURCE_MAPPING = "bytecode-source-mapping";
    @Name(value="Dump Code Lines")
    @Description(value="Dump line mappings to output archive zip entry extra data.")
    @ShortName(value="dcl")
    @Type(value="bool")
    public static final String DUMP_CODE_LINES = "dump-code-lines";
    @Name(value="Ignore Invalid Bytecode")
    @Description(value="Ignore bytecode that is malformed.")
    @ShortName(value="iib")
    @Type(value="bool")
    public static final String IGNORE_INVALID_BYTECODE = "ignore-invalid-bytecode";
    @Name(value="Verify Anonymous Classes")
    @Description(value="Verify that anonymous classes are local.")
    @ShortName(value="vac")
    @Type(value="bool")
    public static final String VERIFY_ANONYMOUS_CLASSES = "verify-anonymous-classes";
    @Name(value="Ternary Constant Simplification")
    @Description(value="Fold branches of ternary expressions that have boolean true and false constants.")
    @ShortName(value="tcs")
    @Type(value="bool")
    public static final String TERNARY_CONSTANT_SIMPLIFICATION = "ternary-constant-simplification";
    @Name(value="Pattern Matching")
    @Description(value="Decompile with if and switch pattern matching enabled.")
    @ShortName(value="pam")
    @Type(value="bool")
    public static final String PATTERN_MATCHING = "pattern-matching";
    @Name(value="Try-Loop fix")
    @Description(value="Fixes rare cases of malformed decompilation when try blocks are found inside of while loops")
    @ShortName(value="tlf")
    @Type(value="bool")
    public static final String TRY_LOOP_FIX = "try-loop-fix";
    @Name(value="[Experimental] Ternary In If Conditions")
    @Description(value="Tries to collapse if statements that have a ternary in their condition.")
    @ShortName(value="tco")
    @Type(value="bool")
    public static final String TERNARY_CONDITIONS = "ternary-in-if";
    @Name(value="Decompile Switch Expressions")
    @Description(value="Decompile switch expressions in modern Java class files.")
    @ShortName(value="swe")
    @Type(value="bool")
    public static final String SWITCH_EXPRESSIONS = "decompile-switch-expressions";
    @Name(value="[Debug] Show hidden statements")
    @Description(value="Display hidden code blocks for debugging purposes.")
    @ShortName(value="shs")
    @Type(value="bool")
    public static final String SHOW_HIDDEN_STATEMENTS = "show-hidden-statements";
    @Name(value="Override Annotation")
    @Description(value="Display override annotations for methods known to the decompiler.")
    @ShortName(value="ovr")
    @Type(value="bool")
    public static final String OVERRIDE_ANNOTATION = "override-annotation";
    @Name(value="Second-Pass Stack Simplification")
    @Description(value="Simplify variables across stack bounds to resugar complex statements.")
    @ShortName(value="ssp")
    @Type(value="bool")
    public static final String SIMPLIFY_STACK_SECOND_PASS = "simplify-stack";
    @Name(value="[Experimental] Verify Variable Merges")
    @Description(value="Tries harder to verify the validity of variable merges. If there are strange variable recompilation issues, this is a good place to start.")
    @ShortName(value="vvm")
    @Type(value="bool")
    public static final String VERIFY_VARIABLE_MERGES = "verify-merges";
    @Name(value="Include Entire Classpath")
    @Description(value="Give the decompiler information about every jar on the classpath.")
    @ShortName(value="iec")
    @Type(value="bool")
    public static final String INCLUDE_ENTIRE_CLASSPATH = "include-classpath";
    @Name(value="Include Java Runtime")
    @Description(value="Give the decompiler information about the Java runtime, either 1 or current for the current runtime, or a path to another runtime")
    @ShortName(value="jrt")
    @Type(value="string")
    public static final String INCLUDE_JAVA_RUNTIME = "include-runtime";
    @Name(value="Explicit Generic Arguments")
    @Description(value="Put explicit diamond generic arguments on method calls.")
    @ShortName(value="ega")
    @Type(value="bool")
    public static final String EXPLICIT_GENERIC_ARGUMENTS = "explicit-generics";
    @Name(value="Inline Simple Lambdas")
    @Description(value="Remove braces on simple, one line, lambda expressions.")
    @ShortName(value="isl")
    @Type(value="bool")
    public static final String INLINE_SIMPLE_LAMBDAS = "inline-simple-lambdas";
    @Name(value="Logging Level")
    @Description(value="Logging level. Must be one of: 'info', 'debug', 'warn', 'error'.")
    @ShortName(value="log")
    @Type(value="string")
    public static final String LOG_LEVEL = "log-level";
    @Name(value="[DEPRECATED] Max time to process method")
    @Description(value="Maximum time in seconds to process a method. This is deprecated, do not use.")
    @ShortName(value="mpm")
    @Type(value="int")
    public static final String MAX_PROCESSING_METHOD = "max-time-per-method";
    @Name(value="Rename Members")
    @Description(value="Rename classes, fields, and methods with a number suffix to help in deobfuscation.")
    @ShortName(value="ren")
    @Type(value="bool")
    public static final String RENAME_ENTITIES = "rename-members";
    @Name(value="User Renamer Class")
    @Description(value="Path to a class that implements IIdentifierRenamer.")
    @ShortName(value="urc")
    @Type(value="string")
    public static final String USER_RENAMER_CLASS = "user-renamer-class";
    @Name(value="[DEPRECATED] New Line Seperator")
    @Description(value="Use \\n instead of \\r\\n for new lines. Deprecated, do not use.")
    @ShortName(value="nls")
    @Type(value="bool")
    @DynamicDefaultValue(value="Disabled on Windows, enabled on other systems")
    public static final String NEW_LINE_SEPARATOR = "new-line-separator";
    @Name(value="Indent String")
    @Description(value="A string of spaces or tabs that is placed for each indent level.")
    @ShortName(value="ind")
    @Type(value="string")
    public static final String INDENT_STRING = "indent-string";
    @Name(value="Preferred line length")
    @Description(value="Max line length before formatting is applied.")
    @ShortName(value="pll")
    @Type(value="int")
    public static final String PREFERRED_LINE_LENGTH = "preferred-line-length";
    @Name(value="Banner")
    @Description(value="A message to display at the top of the decompiled file.")
    @ShortName(value="ban")
    @Type(value="string")
    public static final String BANNER = "banner";
    @Name(value="Error Message")
    @Description(value="Message to display when an error occurs in the decompiler.")
    @ShortName(value="erm")
    @Type(value="string")
    public static final String ERROR_MESSAGE = "error-message";
    @Name(value="Thread Count")
    @Description(value="How many threads to use to decompile.")
    @DynamicDefaultValue(value="all available processors")
    @ShortName(value="thr")
    @Type(value="int")
    public static final String THREADS = "thread-count";
    public static final String DUMP_ORIGINAL_LINES = "__dump_original_lines__";
    public static final String UNIT_TEST_MODE = "__unit_test_mode__";
    public static final String LINE_SEPARATOR_WIN = "\r\n";
    public static final String LINE_SEPARATOR_UNX = "\n";
    @Name(value="Skip Extra Files")
    @Description(value="Skip copying non-class files from the input folder or file to the output")
    @ShortName(value="sef")
    @Type(value="bool")
    public static final String SKIP_EXTRA_FILES = "skip-extra-files";
    @Name(value="Warn about inconsistent inner attributes")
    @Description(value="Warn about inconsistent inner class attributes")
    @ShortName(value="win")
    @Type(value="bool")
    public static final String WARN_INCONSISTENT_INNER_CLASSES = "warn-inconsistent-inner-attributes";
    @Name(value="Dump Bytecode On Error")
    @Description(value="Put the bytecode in the method body when an error occurs.")
    @ShortName(value="dbe")
    @Type(value="bool")
    public static final String DUMP_BYTECODE_ON_ERROR = "dump-bytecode-on-error";
    @Name(value="Dump Exceptions On Error")
    @Description(value="Put the exception message in the method body or source file when an error occurs.")
    @ShortName(value="dee")
    @Type(value="bool")
    public static final String DUMP_EXCEPTION_ON_ERROR = "dump-exception-on-error";
    @Name(value="Decompiler Comments")
    @Description(value="Sometimes, odd behavior of the bytecode or unfixable problems occur. This enables or disables the adding of those to the decompiled output.")
    @ShortName(value="dec")
    @Type(value="bool")
    public static final String DECOMPILER_COMMENTS = "decompiler-comments";
    @Name(value="SourceFile comments")
    @Description(value="Add debug comments showing the class SourceFile attribute if present.")
    @ShortName(value="sfc")
    @Type(value="bool")
    public static final String SOURCE_FILE_COMMENTS = "sourcefile-comments";
    @Name(value="Decompile complex constant-dynamic expressions")
    @Description(value="Some constant-dynamic expressions can't be converted to a single Java expression with identical run-time behaviour. This decompiles them to a similar non-lazy expression, marked with a comment.")
    @ShortName(value="dcc")
    @Type(value="bool")
    public static final String DECOMPILE_COMPLEX_CONDYS = "decompile-complex-constant-dynamic";
    @Name(value="Force JSR inline")
    @Description(value="Forces the processing of JSR instructions even if the class files shouldn't contain it (Java 7+)")
    @ShortName(value="fji")
    @Type(value="bool")
    public static final String FORCE_JSR_INLINE = "force-jsr-inline";
    @Name(value="Dump Text Tokens")
    @Description(value="Dump Text Tokens on each class file")
    @ShortName(value="dtt")
    @Type(value="bool")
    public static final String DUMP_TEXT_TOKENS = "dump-text-tokens";
    @Name(value="Remove Imports")
    @Description(value="Remove import statements from the decompiled code")
    @ShortName(value="rim")
    @Type(value="bool")
    public static final String REMOVE_IMPORTS = "remove-imports";
    @Name(value="Mark Corresponding Synthetics")
    @Description(value="Mark lambdas and anonymous and local classes with their respective synthetic constructs")
    @ShortName(value="mcs")
    public static final String MARK_CORRESPONDING_SYNTHETICS = "mark-corresponding-synthetics";
    public static final Map<String, Object> DEFAULTS = IFernflowerPreferences.getDefaults();

    public static Map<String, Object> getDefaults() {
        HashMap<String, String> defaults = new HashMap<String, String>();
        defaults.put(REMOVE_BRIDGE, "1");
        defaults.put(REMOVE_SYNTHETIC, "1");
        defaults.put(DECOMPILE_INNER, "1");
        defaults.put(DECOMPILE_CLASS_1_4, "1");
        defaults.put(DECOMPILE_ASSERTIONS, "1");
        defaults.put(HIDE_EMPTY_SUPER, "1");
        defaults.put(HIDE_DEFAULT_CONSTRUCTOR, "1");
        defaults.put(DECOMPILE_GENERIC_SIGNATURES, "1");
        defaults.put(INCORPORATE_RETURNS, "1");
        defaults.put(ENSURE_SYNCHRONIZED_MONITOR, "1");
        defaults.put(DECOMPILE_ENUM, "1");
        defaults.put(REMOVE_GET_CLASS_NEW, "1");
        defaults.put(LITERALS_AS_IS, "0");
        defaults.put(BOOLEAN_TRUE_ONE, "1");
        defaults.put(ASCII_STRING_CHARACTERS, "0");
        defaults.put(SYNTHETIC_NOT_SET, "0");
        defaults.put(UNDEFINED_PARAM_TYPE_OBJECT, "1");
        defaults.put(USE_DEBUG_VAR_NAMES, "1");
        defaults.put(USE_METHOD_PARAMETERS, "1");
        defaults.put(REMOVE_EMPTY_RANGES, "1");
        defaults.put(FINALLY_DEINLINE, "1");
        defaults.put(LAMBDA_TO_ANONYMOUS_CLASS, "0");
        defaults.put(BYTECODE_SOURCE_MAPPING, "0");
        defaults.put(DUMP_CODE_LINES, "0");
        defaults.put(IGNORE_INVALID_BYTECODE, "0");
        defaults.put(VERIFY_ANONYMOUS_CLASSES, "0");
        defaults.put(TERNARY_CONSTANT_SIMPLIFICATION, "0");
        defaults.put(OVERRIDE_ANNOTATION, "1");
        defaults.put(PATTERN_MATCHING, "1");
        defaults.put(TRY_LOOP_FIX, "1");
        defaults.put(TERNARY_CONDITIONS, "1");
        defaults.put(SWITCH_EXPRESSIONS, "1");
        defaults.put(SHOW_HIDDEN_STATEMENTS, "0");
        defaults.put(SIMPLIFY_STACK_SECOND_PASS, "1");
        defaults.put(VERIFY_VARIABLE_MERGES, "0");
        defaults.put(DECOMPILE_PREVIEW, "1");
        defaults.put(INCLUDE_ENTIRE_CLASSPATH, "0");
        defaults.put(INCLUDE_JAVA_RUNTIME, "");
        defaults.put(EXPLICIT_GENERIC_ARGUMENTS, "0");
        defaults.put(INLINE_SIMPLE_LAMBDAS, "1");
        defaults.put(LOG_LEVEL, IFernflowerLogger.Severity.INFO.name());
        defaults.put(MAX_PROCESSING_METHOD, "0");
        defaults.put(RENAME_ENTITIES, "0");
        defaults.put(NEW_LINE_SEPARATOR, "1");
        defaults.put(INDENT_STRING, "   ");
        defaults.put(PREFERRED_LINE_LENGTH, "160");
        defaults.put(BANNER, "");
        defaults.put(ERROR_MESSAGE, "Please report this to the Vineflower issue tracker, at https://github.com/Vineflower/vineflower/issues with a copy of the class file (if you have the rights to distribute it!)");
        defaults.put(UNIT_TEST_MODE, "0");
        defaults.put(DUMP_ORIGINAL_LINES, "0");
        defaults.put(THREADS, String.valueOf(Runtime.getRuntime().availableProcessors()));
        defaults.put(SKIP_EXTRA_FILES, "0");
        defaults.put(WARN_INCONSISTENT_INNER_CLASSES, "1");
        defaults.put(DUMP_BYTECODE_ON_ERROR, "1");
        defaults.put(DUMP_EXCEPTION_ON_ERROR, "1");
        defaults.put(DECOMPILER_COMMENTS, "1");
        defaults.put(SOURCE_FILE_COMMENTS, "0");
        defaults.put(DECOMPILE_COMPLEX_CONDYS, "0");
        defaults.put(FORCE_JSR_INLINE, "0");
        defaults.put(DUMP_TEXT_TOKENS, "0");
        defaults.put(REMOVE_IMPORTS, "0");
        defaults.put(MARK_CORRESPONDING_SYNTHETICS, "0");
        return Collections.unmodifiableMap(defaults);
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Type {
        public static final String BOOLEAN = "bool";
        public static final String INTEGER = "int";
        public static final String STRING = "string";

        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface ShortName {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface DynamicDefaultValue {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Description {
        public String value();
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Name {
        public String value();
    }
}

