/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class DependencyHashCache {
    private final Map<String, String> hashes;

    private DependencyHashCache(Map<String, String> hashes) {
        this.hashes = hashes;
    }

    public static DependencyHashCache load(Path path) throws IOException {
        HashMap<String, String> hashes = new HashMap<String, String>();
        Files.readAllLines(path).forEach(line -> {
            int commentIdx = line.indexOf(35);
            int equalIdx = line.indexOf(61);
            if (commentIdx == 0 || equalIdx == -1) {
                return;
            }
            if (commentIdx != -1) {
                line = line.substring(0, commentIdx).trim();
            }
            String key = line.substring(0, equalIdx);
            String value = line.substring(equalIdx + 1);
            hashes.put(key, value);
        });
        return new DependencyHashCache(hashes);
    }

    public String getHash(String key) {
        return this.hashes.get(key);
    }
}

