/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.snowblower.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.neoforged.snowblower.data.Version;
import net.neoforged.snowblower.util.Cache;
import net.neoforged.snowblower.util.Util;
import net.neoforged.srgutils.IMappingFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingTask.class);

    public static Path getMergedMappings(Path cache, Version version, Path extraMappings) throws IOException {
        IMappingFile clientMojToObf = MappingTask.downloadMappings(cache, extraMappings, version, "client");
        if (clientMojToObf == null) {
            LOGGER.debug("  Client mappings not found, skipping version");
            return null;
        }
        IMappingFile serverMojToObf = MappingTask.downloadMappings(cache, extraMappings, version, "server");
        if (serverMojToObf == null) {
            LOGGER.debug("  Server mappings not found, skipping version");
            return null;
        }
        if (!MappingTask.canMerge(clientMojToObf, serverMojToObf)) {
            throw new IllegalStateException("Client mappings for " + version.id() + " are not a strict superset of the server mappings.");
        }
        Cache key = new Cache().put("client", cache.resolve("client_mappings.txt")).put("server", cache.resolve("server_mappings.txt"));
        Path keyF = cache.resolve("obf_to_moj.tsrg.cache");
        Path ret = cache.resolve("obf_to_moj.tsrg");
        if (!Files.exists(ret, new LinkOption[0]) || !key.isValid(keyF)) {
            clientMojToObf.write(ret, IMappingFile.Format.TSRG2, true);
            key.write(keyF);
        }
        return ret;
    }

    private static IMappingFile downloadMappings(Path cache, Path extraMappings, Version version, String type) throws IOException {
        Path mappings = cache.resolve(type + "_mappings.txt");
        if (!Files.exists(mappings, new LinkOption[0])) {
            Path extraMap;
            boolean copiedFromExtra = false;
            if (extraMappings != null && Files.exists(extraMap = extraMappings.resolve(version.type()).resolve(version.id().toString()).resolve("maps").resolve(type + ".txt"), new LinkOption[0])) {
                Files.copy(extraMap, mappings, StandardCopyOption.REPLACE_EXISTING);
                copiedFromExtra = true;
            }
            if (!copiedFromExtra && !Util.downloadFile(mappings, version, type + "_mappings")) {
                return null;
            }
        }
        try (InputStream in = Files.newInputStream(mappings, new OpenOption[0]);){
            IMappingFile iMappingFile = IMappingFile.load(in);
            return iMappingFile;
        }
    }

    private static boolean canMerge(IMappingFile client, IMappingFile server) {
        Function<IMappingFile.IField, String> fldToString = fld -> fld.getOriginal() + " " + fld.getDescriptor() + " -> " + fld.getMapped() + " " + fld.getMappedDescriptor();
        Function<IMappingFile.IMethod, String> mtdToString = mtd -> mtd.getOriginal() + " " + mtd.getDescriptor() + " -> " + mtd.getMapped() + " " + mtd.getMappedDescriptor();
        for (IMappingFile.IClass iClass : server.getClasses()) {
            IMappingFile.IClass clsC = client.getClass(iClass.getOriginal());
            if (clsC == null || !iClass.getMapped().equals(clsC.getMapped())) {
                return false;
            }
            Set fldsS = iClass.getFields().stream().map(fldToString).collect(Collectors.toCollection(HashSet::new));
            Set fldsC = clsC.getFields().stream().map(fldToString).collect(Collectors.toCollection(HashSet::new));
            Set mtdsS = iClass.getMethods().stream().map(mtdToString).collect(Collectors.toCollection(HashSet::new));
            Set mtdsC = clsC.getMethods().stream().map(mtdToString).collect(Collectors.toCollection(HashSet::new));
            fldsS.removeAll(fldsC);
            mtdsS.removeAll(mtdsC);
            if (fldsS.isEmpty() && mtdsS.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

