/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.installertools;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.neoforged.installertools.Task;
import net.neoforged.srgutils.IMappingFile;
import net.neoforged.srgutils.INamedMappingFile;
import net.neoforged.srgutils.IRenamer;

public class ChainMappings
extends Task {
    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<File> leftO = parser.accepts("left").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder reverseLeftO = parser.accepts("reverse-left");
        ArgumentAcceptingOptionSpec<String> leftNamesO = parser.accepts("left-names").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<File> rightO = parser.accepts("right").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder reverseRightO = parser.accepts("reverse-right");
        ArgumentAcceptingOptionSpec<String> rightNamesO = parser.accepts("right-names").withRequiredArg().ofType(String.class);
        ArgumentAcceptingOptionSpec<File> outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder classesO = parser.accepts("classes");
        OptionSpecBuilder fieldsO = parser.accepts("fields");
        OptionSpecBuilder methodsO = parser.accepts("methods");
        OptionSpecBuilder paramsO = parser.accepts("params");
        try {
            IMappingFile rightM;
            IMappingFile leftM;
            OptionSet options = parser.parse(args);
            File left = options.valueOf(leftO);
            File right = options.valueOf(rightO);
            String[] leftNames = this.parseNames(options, leftNamesO);
            String[] rightNames = this.parseNames(options, rightNamesO);
            File output = options.valueOf(outputO);
            boolean selective = options.has(classesO) || options.has(methodsO) || options.has(fieldsO) || options.has(paramsO);
            boolean classes = !selective || options.has(classesO);
            boolean fields = !selective || options.has(fieldsO);
            boolean methods = !selective || options.has(methodsO);
            boolean params = !selective || options.has(paramsO);
            this.log("Left:    " + left);
            this.log("         Reversed=" + options.has(reverseLeftO));
            this.log("         " + (leftNames == null ? "null" : options.valueOf(leftNamesO)));
            this.log("Right:   " + right);
            this.log("         Reversed=" + options.has(reverseRightO));
            this.log("         " + (rightNames == null ? "null" : options.valueOf(rightNamesO)));
            this.log("Classes: " + classes);
            this.log("Fields:  " + fields);
            this.log("Methods: " + methods);
            this.log("Params:  " + params);
            this.log("Output:  " + output);
            if (output.exists() && !this.delete(output)) {
                this.error("Could not delete output file: " + output);
            }
            if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                this.error("Could not make output folders: " + output.getParentFile());
            }
            if (!left.exists()) {
                this.error("Left does not exist: " + left);
            }
            if (!right.exists()) {
                this.error("Right does not exist: " + right);
            }
            IMappingFile iMappingFile = leftM = leftNames == null ? IMappingFile.load(left) : INamedMappingFile.load(left).getMap(leftNames[0], leftNames[1]);
            if (options.has(reverseLeftO)) {
                leftM = leftM.reverse();
            }
            IMappingFile iMappingFile2 = rightM = rightNames == null ? IMappingFile.load(right) : INamedMappingFile.load(right).getMap(rightNames[0], rightNames[1]);
            if (options.has(reverseRightO)) {
                rightM = rightM.reverse();
            }
            IMappingFile outputM = leftM.rename(this.makeRenamer(rightM, classes, fields, methods, params));
            outputM.write(output.toPath(), IMappingFile.Format.TSRG2, false);
        }
        catch (OptionException e) {
            parser.printHelpOn(System.out);
            e.printStackTrace();
        }
    }

    private boolean delete(File path) throws IOException {
        if (path.isDirectory()) {
            return Files.walk(path.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).map(File::delete).anyMatch(v -> v == false);
        }
        return path.delete();
    }

    private String[] parseNames(OptionSet options, OptionSpec<String> spec) {
        if (!options.has(spec)) {
            return null;
        }
        String[] ret = options.valueOf(spec).split(",");
        if (ret.length != 2) {
            throw new IllegalArgumentException("Name argument must be exactly two values, EXA: left,right");
        }
        return ret;
    }

    protected IRenamer makeRenamer(final IMappingFile link, final boolean classes, final boolean fields, final boolean methods, final boolean params) {
        return new IRenamer(){

            @Override
            public String rename(IMappingFile.IPackage value) {
                return link.remapPackage(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IClass value) {
                return classes ? link.remapClass(value.getMapped()) : value.getMapped();
            }

            @Override
            public String rename(IMappingFile.IField value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null || !fields ? value.getMapped() : cls.remapField(value.getMapped());
            }

            @Override
            public String rename(IMappingFile.IMethod value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getMapped());
                return cls == null || !methods ? value.getMapped() : cls.remapMethod(value.getMapped(), value.getMappedDescriptor());
            }

            @Override
            public String rename(IMappingFile.IParameter value) {
                IMappingFile.IMethod mtd = (IMappingFile.IMethod)value.getParent();
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)mtd.getParent()).getMapped());
                mtd = cls == null ? null : cls.getMethod(mtd.getMapped(), mtd.getMappedDescriptor());
                return mtd == null || !params ? value.getMapped() : mtd.remapParameter(value.getIndex(), value.getMapped());
            }
        };
    }
}

