/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.art.internal;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.neoforged.art.api.ClassProvider;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

class ClassProviderImpl
implements ClassProvider {
    private final List<FileSystem> fileSystems;
    private final Map<String, Path> sources;
    private final Map<String, Optional<? extends ClassProvider.IClassInfo>> classInfos;
    @Nullable
    private final Map<String, Optional<? extends ClassProvider.IClassInfo>> classCache;

    ClassProviderImpl(List<FileSystem> fileSystems, Map<String, Path> sources, Map<String, Optional<? extends ClassProvider.IClassInfo>> classInfos, boolean cacheAll) {
        this.fileSystems = Collections.unmodifiableList(fileSystems);
        this.sources = Collections.unmodifiableMap(sources);
        this.classInfos = Collections.unmodifiableMap(classInfos);
        this.classCache = cacheAll ? new ConcurrentHashMap() : null;
    }

    @Override
    public Optional<? extends ClassProvider.IClassInfo> getClass(String name) {
        return this.classCache != null ? this.classCache.computeIfAbsent(name, this::computeClassInfo) : this.computeClassInfo(name);
    }

    private Optional<? extends ClassProvider.IClassInfo> computeClassInfo(String name) {
        Optional<? extends ClassProvider.IClassInfo> knownClassInfo = this.classInfos.get(name);
        if (knownClassInfo != null) {
            return knownClassInfo;
        }
        Path source = this.sources.get(name);
        if (source == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(new ClassInfo(Files.readAllBytes(source)));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get data to compute class info in file: " + source.toAbsolutePath(), e);
        }
    }

    @Override
    public void close() throws IOException {
        for (FileSystem fs : this.fileSystems) {
            fs.close();
        }
    }

    private static class Access {
        private static final int[] ACC = new int[23];
        private static final String[] NAME = new String[23];
        private final int value;
        private String toString;

        private static void put(int idx, int acc, String name) {
            Access.ACC[idx] = acc;
            Access.NAME[idx] = name;
        }

        public Access(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            if (this.toString == null) {
                ArrayList<String> ret = new ArrayList<String>();
                for (int x = 0; x < ACC.length; ++x) {
                    if ((this.value & ACC[x]) == 0) continue;
                    ret.add(NAME[x]);
                }
                this.toString = ret.isEmpty() ? "default" : ret.stream().collect(Collectors.joining(" "));
            }
            return this.toString;
        }

        static {
            int idx = 0;
            Access.put(idx++, 1, "public");
            Access.put(idx++, 2, "private");
            Access.put(idx++, 4, "protected");
            Access.put(idx++, 8, "static");
            Access.put(idx++, 16, "final");
            Access.put(idx++, 32, "super");
            Access.put(idx++, 32, "synchronized");
            Access.put(idx++, 32, "open");
            Access.put(idx++, 32, "transitive");
            Access.put(idx++, 64, "volatile");
            Access.put(idx++, 64, "bridge");
            Access.put(idx++, 64, "static_phase");
            Access.put(idx++, 128, "varargs");
            Access.put(idx++, 128, "transient");
            Access.put(idx++, 256, "native");
            Access.put(idx++, 512, "interface");
            Access.put(idx++, 1024, "abstract");
            Access.put(idx++, 2048, "strict");
            Access.put(idx++, 4096, "synthetic");
            Access.put(idx++, 8192, "annotation");
            Access.put(idx++, 16384, "enum");
            Access.put(idx++, 32768, "mandated");
            Access.put(idx++, 32768, "module");
        }
    }

    static class ClassInfo
    implements ClassProvider.IClassInfo {
        private final String name;
        private final Access access;
        private final String superName;
        private final List<String> interfaces;
        private final Map<String, FieldInfo> fields;
        private Collection<FieldInfo> fieldsView;
        private final Map<String, MethodInfo> methods;
        private Collection<MethodInfo> methodsView;

        ClassInfo(byte[] data) {
            ClassReader reader = new ClassReader(data);
            ClassNode node = new ClassNode();
            reader.accept(node, 1);
            this.name = node.name;
            this.access = new Access(node.access);
            this.superName = node.superName;
            this.interfaces = node.interfaces.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(node.interfaces);
            this.methods = !node.methods.isEmpty() ? Collections.unmodifiableMap(node.methods.stream().map(x$0 -> new MethodInfo((MethodNode)x$0)).collect(Collectors.toMap(m -> m.getName() + m.getDescriptor(), Function.identity()))) : null;
            this.fields = !node.fields.isEmpty() ? Collections.unmodifiableMap(node.fields.stream().map(x$0 -> new FieldInfo((FieldNode)x$0)).collect(Collectors.toMap(FieldInfo::getName, Function.identity()))) : null;
        }

        ClassInfo(Class<?> node) {
            this.name = ClassInfo.nameToBytecode(node);
            this.access = new Access(node.getModifiers());
            this.superName = ClassInfo.nameToBytecode(node.getSuperclass());
            this.interfaces = Arrays.stream(node.getInterfaces()).map(ClassInfo::nameToBytecode).collect(Collectors.toList());
            Map mtds = Stream.concat(Arrays.stream(node.getConstructors()).map(x$0 -> new MethodInfo((Constructor<?>)x$0)), Arrays.stream(node.getDeclaredMethods()).map(x$0 -> new MethodInfo((Method)x$0))).collect(Collectors.toMap(m -> m.getName() + m.getDescriptor(), Function.identity()));
            this.methods = mtds.isEmpty() ? null : Collections.unmodifiableMap(mtds);
            Field[] flds = node.getDeclaredFields();
            this.fields = flds.length > 0 ? Collections.unmodifiableMap(Arrays.asList(flds).stream().map(x$0 -> new FieldInfo((Field)x$0)).collect(Collectors.toMap(FieldInfo::getName, Function.identity()))) : null;
        }

        private static String nameToBytecode(Class<?> cls) {
            return cls == null ? null : cls.getName().replace('.', '/');
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        @Nullable
        public String getSuper() {
            return this.superName;
        }

        @Override
        public int getAccess() {
            return this.access.getValue();
        }

        public Access getAccessLevel() {
            return this.access;
        }

        @Override
        public Collection<String> getInterfaces() {
            return this.interfaces;
        }

        @Override
        public Collection<? extends ClassProvider.IFieldInfo> getFields() {
            if (this.fieldsView == null) {
                this.fieldsView = this.fields == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.fields.values());
            }
            return this.fieldsView;
        }

        @Override
        public Optional<? extends ClassProvider.IFieldInfo> getField(String name) {
            return this.fields == null ? Optional.empty() : Optional.ofNullable(this.fields.get(name));
        }

        @Override
        public Collection<? extends ClassProvider.IMethodInfo> getMethods() {
            if (this.methodsView == null) {
                this.methodsView = this.methods == null ? Collections.emptyList() : Collections.unmodifiableCollection(this.methods.values());
            }
            return this.methodsView;
        }

        @Override
        public Optional<? extends ClassProvider.IMethodInfo> getMethod(String name, String desc) {
            return this.methods == null ? Optional.empty() : Optional.ofNullable(this.methods.get(name + " " + desc));
        }

        public String toString() {
            return this.getAccessLevel().toString() + ' ' + this.getName();
        }

        private class MethodInfo
        implements ClassProvider.IMethodInfo {
            private final String name;
            private final String desc;
            private final Access access;

            MethodInfo(MethodNode node) {
                this.name = node.name;
                this.desc = node.desc;
                this.access = new Access(node.access);
            }

            MethodInfo(Method node) {
                this.name = node.getName();
                this.desc = Type.getMethodDescriptor(node);
                this.access = new Access(node.getModifiers());
            }

            MethodInfo(Constructor<?> node) {
                this.name = "<init>";
                this.desc = Type.getConstructorDescriptor(node);
                this.access = new Access(node.getModifiers());
            }

            @Override
            public int getAccess() {
                return this.access.getValue();
            }

            public Access getAccessLevel() {
                return this.access;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            public String toString() {
                return this.getAccessLevel().toString() + ' ' + ClassInfo.this.getName() + '/' + this.getName() + this.getDescriptor();
            }
        }

        private class FieldInfo
        implements ClassProvider.IFieldInfo {
            private final String name;
            private final String desc;
            private final Access access;

            public FieldInfo(FieldNode node) {
                this.name = node.name;
                this.desc = node.desc;
                this.access = new Access(node.access);
            }

            public FieldInfo(Field node) {
                this.name = node.getName();
                this.desc = Type.getType(node.getType()).getDescriptor();
                this.access = new Access(node.getModifiers());
            }

            @Override
            public int getAccess() {
                return this.access.getValue();
            }

            public Access getAccessLevel() {
                return this.access;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDescriptor() {
                return this.desc;
            }

            public String toString() {
                return this.getAccessLevel().toString() + ' ' + ClassInfo.this.getName() + '/' + this.getName() + ' ' + this.getDescriptor();
            }
        }
    }
}

