/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.bean.CsvConverter;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCsvConverter
implements CsvConverter {
    protected Class<?> type;
    protected Locale locale;
    protected Locale errorLocale;

    public AbstractCsvConverter() {
        this.type = null;
        this.locale = null;
        this.errorLocale = Locale.getDefault();
    }

    public AbstractCsvConverter(Class<?> type, String locale, Locale errorLocale) {
        this.type = type;
        this.locale = StringUtils.isNotEmpty(locale) ? Locale.forLanguageTag(locale) : null;
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public String convertToWrite(Object value) throws CsvDataTypeMismatchException {
        return Objects.toString(value, "");
    }

    @Override
    public void setErrorLocale(Locale errorLocale) {
        this.errorLocale = ObjectUtils.defaultIfNull(errorLocale, Locale.getDefault());
    }

    @Override
    public void setType(Class<?> type) {
        this.type = type;
    }

    @Override
    public void setLocale(String locale) {
        this.locale = StringUtils.isNotEmpty(locale) ? Locale.forLanguageTag(locale) : null;
    }
}

