/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.neoforged.neoform.runtime.actions.CreateLibrariesOptionsFile;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.cache.CacheKey;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.neoform.runtime.utils.AnsiColor;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;
import org.jetbrains.annotations.Nullable;

public class ExternalJavaToolAction
implements ExecutionNodeAction {
    private static final Logger LOG = Logger.create();
    private MavenCoordinate toolArtifactId;
    @Nullable
    private URI repositoryUrl;
    private List<String> jvmArgs = new ArrayList<String>();
    private List<String> args = new ArrayList<String>();
    @Nullable
    private CreateLibrariesOptionsFile listLibraries = null;
    private final SequencedMap<String, Supplier<CacheKey.AnnotatedValue>> dataDependencyHashes = new LinkedHashMap<String, Supplier<CacheKey.AnnotatedValue>>();
    private final boolean useHostJavaExecutable;

    public ExternalJavaToolAction(MavenCoordinate toolArtifactId) {
        this.toolArtifactId = toolArtifactId;
        this.useHostJavaExecutable = false;
    }

    public ExternalJavaToolAction(ToolCoordinate toolCoordinate) {
        this.toolArtifactId = toolCoordinate.version();
        this.useHostJavaExecutable = true;
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path listLibrariesFile = this.listLibraries != null ? this.listLibraries.writeFile(environment) : null;
        Artifact toolArtifact = this.repositoryUrl != null ? environment.getArtifactManager().get(this.toolArtifactId, this.repositoryUrl) : environment.getArtifactManager().get(this.toolArtifactId);
        String javaExecutablePath = this.useHostJavaExecutable ? ProcessHandle.current().info().command().orElseThrow() : environment.getJavaExecutable();
        Path workingDir = environment.getWorkspace();
        ArrayList<String> command = new ArrayList<String>();
        command.add(javaExecutablePath);
        for (String string : this.jvmArgs) {
            command.add(environment.interpolateString(string));
        }
        command.add("-jar");
        command.add(environment.getPathArgument(toolArtifact.path()));
        boolean isVineflower = this.isVineflower();
        for (String arg : this.args) {
            if (isVineflower) {
                arg = arg.replace("TRACE", "WARN");
            }
            if (listLibrariesFile != null) {
                arg = arg.replace("{listLibrariesOutput}", environment.getPathArgument(listLibrariesFile));
            }
            command.add(environment.interpolateString(arg));
        }
        LOG.println(" \u21b3 Running external tool " + String.valueOf(this.toolArtifactId));
        if (environment.isVerbose()) {
            LOG.println(" " + String.valueOf((Object)AnsiColor.MUTED) + ExternalJavaToolAction.printableCommand(command) + String.valueOf((Object)AnsiColor.RESET));
        }
        File file = workingDir.resolve("console_output.txt").toFile();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8));){
            writer.append("-".repeat(80)).append("\n\n");
            writer.append("Command-Line:\n");
            for (String s : command) {
                writer.append(" - ").append(s).append("\n");
            }
            writer.append("-".repeat(80)).append("\n\n");
        }
        Process process = new ProcessBuilder(new String[0]).directory(workingDir.toFile()).command(command).redirectErrorStream(true).redirectOutput(ProcessBuilder.Redirect.appendTo(file)).start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            this.tailLogFile(file);
            throw new RuntimeException("Failed to execute tool");
        }
        if (isVineflower && this.fileContains(file, "java.lang.OutOfMemoryError")) {
            this.tailLogFile(file);
            throw new RuntimeException("Vineflower ran out of memory during decompilation. Try again.");
        }
    }

    private boolean isVineflower() {
        return this.toolArtifactId.groupId().equals("org.vineflower") && this.toolArtifactId.artifactId().equals("vineflower");
    }

    private static String printableCommand(List<String> command) {
        return command.stream().map(arg -> {
            if (arg.contains("\"")) {
                return "\"" + arg + "\"";
            }
            return arg;
        }).collect(Collectors.joining(" "));
    }

    private void tailLogFile(File logFile) {
        System.err.println("Last lines of " + String.valueOf(logFile) + ":");
        System.err.println("------------------------------------------------------------");
        try (RandomAccessFile raf = new RandomAccessFile(logFile, "r");){
            raf.seek(Math.max(0L, raf.length() - 1L));
            int bytesRead = 0;
            int linesRead = 0;
            while (raf.getFilePointer() > 0L && raf.getFilePointer() < raf.length() && bytesRead < 2048 && linesRead < 30) {
                byte b = raf.readByte();
                ++bytesRead;
                if (b == 10) {
                    ++linesRead;
                }
                raf.seek(Math.max(0L, raf.getFilePointer() - 2L));
            }
            long toRead = raf.length() - raf.getFilePointer();
            byte[] data = new byte[(int)toRead];
            raf.readFully(data);
            System.err.println(new String(data, StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            System.err.println("Failed to tail log-file " + String.valueOf(logFile));
        }
        System.err.println("------------------------------------------------------------");
    }

    private boolean fileContains(File file, String s) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(s)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        ck.add("external tool", this.toolArtifactId.toString());
        if (this.repositoryUrl != null) {
            ck.add("external tool repository", this.repositoryUrl.toString());
        }
        ck.add("command line arg", String.join((CharSequence)" ", this.args));
        ck.add("jvm args", String.join((CharSequence)" ", this.jvmArgs));
        for (Map.Entry entry : this.dataDependencyHashes.entrySet()) {
            ck.add("data[" + (String)entry.getKey() + "]", (CacheKey.AnnotatedValue)((Supplier)entry.getValue()).get());
        }
        if (this.listLibraries != null) {
            this.listLibraries.computeCacheKey(ck);
        }
        if (this.isVineflower()) {
            ck.add("oom check", "true");
        }
    }

    public MavenCoordinate getToolArtifactId() {
        return this.toolArtifactId;
    }

    public void setToolArtifactId(MavenCoordinate toolArtifactId) {
        this.toolArtifactId = Objects.requireNonNull(toolArtifactId);
    }

    @Nullable
    public URI getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(@Nullable URI repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = Objects.requireNonNull(jvmArgs);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = Objects.requireNonNull(args);
    }

    @Nullable
    public CreateLibrariesOptionsFile getListLibraries() {
        return this.listLibraries;
    }

    public void setListLibraries(@Nullable CreateLibrariesOptionsFile listLibraries) {
        this.listLibraries = listLibraries;
    }

    public void addDataDependencyHash(String id, Supplier<CacheKey.AnnotatedValue> hash) {
        if (this.dataDependencyHashes.put(id, hash) != null) {
            throw new IllegalArgumentException("Data dependency " + id + " was registered twice.");
        }
    }
}

