/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.manifests.MinecraftDownload;
import net.neoforged.neoform.runtime.manifests.MinecraftLibrary;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import org.jetbrains.annotations.Nullable;

public class ExtensibleClasspath {
    private List<ClasspathItem> additionalClasspath = new ArrayList<ClasspathItem>();
    @Nullable
    private List<ClasspathItem> overriddenClasspath;

    public List<ClasspathItem> getEffectiveClasspath() {
        if (this.overriddenClasspath != null) {
            return this.overriddenClasspath;
        }
        return List.copyOf(this.additionalClasspath);
    }

    public void addMinecraftLibraries(Collection<MinecraftLibrary> libraries) {
        for (MinecraftLibrary library : libraries) {
            if (!library.rulesMatch() || library.getArtifactDownload() == null) continue;
            this.add(ClasspathItem.of(library));
        }
    }

    public void addMavenLibraries(Collection<MavenCoordinate> additionalLibraries) {
        for (MavenCoordinate library : additionalLibraries) {
            this.add(ClasspathItem.of(library));
        }
    }

    public void addPaths(Collection<Path> additionalPaths) {
        for (Path path : additionalPaths) {
            this.add(ClasspathItem.of(path));
        }
    }

    public void addAll(Iterable<ClasspathItem> classpathItems) {
        for (ClasspathItem classpathItem : classpathItems) {
            this.add(classpathItem);
        }
    }

    public void add(ClasspathItem classpathItem) {
        MavenCoordinate coordinate = this.getMavenCoordinate(classpathItem);
        if (coordinate != null) {
            this.additionalClasspath.removeIf(existingItem -> {
                MavenCoordinate existingCoord = this.getMavenCoordinate((ClasspathItem)existingItem);
                return existingCoord != null && existingCoord.equalsWithoutVersion(coordinate);
            });
        }
        this.additionalClasspath.add(classpathItem);
    }

    @Nullable
    private MavenCoordinate getMavenCoordinate(ClasspathItem classpathItem) {
        ClasspathItem classpathItem2 = classpathItem;
        Objects.requireNonNull(classpathItem2);
        ClasspathItem classpathItem3 = classpathItem2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClasspathItem.MavenCoordinateItem.class, ClasspathItem.MinecraftLibraryItem.class}, (Object)classpathItem3, n)) {
            case 0 -> {
                ClasspathItem.MavenCoordinateItem mavenCoordinateItem = (ClasspathItem.MavenCoordinateItem)classpathItem3;
                yield mavenCoordinateItem.coordinate();
            }
            case 1 -> {
                ClasspathItem.MinecraftLibraryItem minecraftLibraryItem = (ClasspathItem.MinecraftLibraryItem)classpathItem3;
                yield minecraftLibraryItem.library().getMavenCoordinate();
            }
            default -> null;
        };
    }

    public List<ClasspathItem> getAdditionalClasspath() {
        return this.additionalClasspath;
    }

    public void setAdditionalClasspath(List<ClasspathItem> additionalClasspath) {
        Objects.requireNonNull(additionalClasspath, "additionalClasspath");
        this.additionalClasspath.clear();
        additionalClasspath.forEach(this::add);
    }

    @Nullable
    public List<ClasspathItem> getOverriddenClasspath() {
        return this.overriddenClasspath;
    }

    public void setOverriddenClasspath(@Nullable List<ClasspathItem> overriddenClasspath) {
        this.overriddenClasspath = overriddenClasspath != null ? List.copyOf(overriddenClasspath) : null;
    }

    public boolean isEmpty() {
        return this.getEffectiveClasspath().isEmpty();
    }

    /*
     * Loose catch block
     */
    public void computeCacheKey(String prefix, CacheKeyBuilder ck) {
        List<ClasspathItem> effectiveItems;
        if (this.overriddenClasspath != null) {
            effectiveItems = this.overriddenClasspath;
            prefix = "overridden " + (String)prefix;
        } else {
            effectiveItems = this.additionalClasspath;
            prefix = "additional " + (String)prefix;
        }
        block12: for (int i = 0; i < effectiveItems.size(); ++i) {
            ClasspathItem classpathItem;
            String component = String.format(Locale.ROOT, "%s[%03d]", prefix, i);
            ClasspathItem item = effectiveItems.get(i);
            Objects.requireNonNull(item);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClasspathItem.MavenCoordinateItem.class, ClasspathItem.MinecraftLibraryItem.class, ClasspathItem.PathItem.class, ClasspathItem.NodeOutputItem.class}, (Object)classpathItem, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ClasspathItem.MavenCoordinateItem mavenCoordinateItem = (ClasspathItem.MavenCoordinateItem)classpathItem;
                    Object object = mavenCoordinateItem.coordinate();
                    Record coordinate = object;
                    Object uri = object = mavenCoordinateItem.repositoryBaseUrl();
                    if (uri != null) {
                        ck.add(component, String.valueOf(coordinate) + " from " + String.valueOf(uri));
                        continue block12;
                    }
                    ck.add(component, ((MavenCoordinate)coordinate).toString());
                    continue block12;
                }
                case 1: {
                    Record record;
                    Object object = (ClasspathItem.MinecraftLibraryItem)classpathItem;
                    Record library = record = ((ClasspathItem.MinecraftLibraryItem)object).library();
                    MinecraftDownload artifactDownload = ((MinecraftLibrary)library).getArtifactDownload();
                    if (artifactDownload != null) {
                        ck.add(component, ((MinecraftLibrary)library).artifactId() + " [" + artifactDownload.checksum() + "]");
                        continue block12;
                    }
                    ck.add(component, ((MinecraftLibrary)library).artifactId());
                    continue block12;
                }
                case 2: {
                    Object object;
                    Record record = (ClasspathItem.PathItem)classpathItem;
                    Object path = object = ((ClasspathItem.PathItem)record).path();
                    ck.addPath(component, (Path)path);
                    continue block12;
                }
                case 3: {
                    NodeOutput nodeOutput;
                    Object object = (ClasspathItem.NodeOutputItem)classpathItem;
                    NodeOutput output = nodeOutput = ((ClasspathItem.NodeOutputItem)object).output();
                    ck.addPath(component, output.getResultPath());
                }
            }
            continue;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
    }

    public ExtensibleClasspath mergeWithMinecraftLibraries(MinecraftVersionManifest versionManifest) {
        if (this.overriddenClasspath == null) {
            ExtensibleClasspath mergedClasspath = new ExtensibleClasspath();
            mergedClasspath.addMinecraftLibraries(versionManifest.libraries());
            mergedClasspath.addAll(this.getEffectiveClasspath());
            return mergedClasspath;
        }
        return this;
    }

    public ExtensibleClasspath copy() {
        ExtensibleClasspath result = new ExtensibleClasspath();
        result.overriddenClasspath = this.overriddenClasspath;
        result.additionalClasspath = new ArrayList<ClasspathItem>(this.additionalClasspath);
        return result;
    }
}

