/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.problems;

import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.function.Predicate;
import net.neoforged.problems.FileProblemReporter;
import net.neoforged.problems.Problem;
import net.neoforged.problems.ProblemId;
import net.neoforged.problems.ProblemLocation;
import net.neoforged.problems.ProblemSeverity;

public interface ProblemReporter {
    public static final ProblemReporter NOOP = problem -> {};

    default public void report(ProblemId problemId, ProblemSeverity severity, ProblemLocation location, String contextualLabel) {
        this.report(Problem.builder(problemId).severity(severity).location(location).contextualLabel(contextualLabel).build());
    }

    default public void report(ProblemId problemId, ProblemSeverity severity, String contextualLabel) {
        this.report(Problem.builder(problemId).severity(severity).contextualLabel(contextualLabel).build());
    }

    public void report(Problem var1);

    default public void tryMergeFromFile(Path reportFile) throws IOException {
        this.tryMergeFromFile(reportFile, problem -> true);
    }

    default public void tryMergeFromFile(Path reportFile, Predicate<Problem> filter) throws IOException {
        try {
            for (Problem problem : FileProblemReporter.loadRecords(reportFile)) {
                if (!filter.test(problem)) continue;
                this.report(problem);
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }
}

