/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cache.LauncherInstallations;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.cli.MinecraftCommand;
import net.neoforged.neoform.runtime.downloads.AssetDownloadResult;
import net.neoforged.neoform.runtime.downloads.AssetDownloader;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.downloads.DownloadsFailedException;
import picocli.CommandLine;

@CommandLine.Command(name="download-assets", description={"Download the client assets used to run a particular game version"})
public class DownloadAssetsCommand
extends MinecraftCommand {
    @CommandLine.Option(names={"--asset-root"}, defaultValue="${env:NFRT_ASSET_ROOT}")
    public Path assetRoot;
    @CommandLine.Option(names={"--asset-repository"}, defaultValue="${env:NFRT_ASSET_REPOSITORY}")
    public URI assetRepository = URI.create("https://resources.download.minecraft.net/");
    @CommandLine.Option(names={"--copy-launcher-assets"}, description={"Try to find the Minecraft Launcher in common locations and copy its assets"}, negatable=true, fallbackValue="true")
    public boolean copyLauncherAssets = true;
    @CommandLine.Option(names={"--use-launcher-asset-root"}, description={"Try to find an existing Minecraft Launcher asset root, and use it to store the requested assets"}, negatable=true, fallbackValue="true")
    public boolean useLauncherAssetRoot = true;
    @CommandLine.Option(names={"--concurrent-downloads"})
    public int concurrentDownloads = 25;
    @CommandLine.Option(names={"--write-properties"})
    public Path outputPropertiesPath;
    @CommandLine.Option(names={"--write-json"})
    public Path outputJsonPath;

    @Override
    protected int runMinecraftCommand(DownloadManager downloadManager, CacheManager cacheManager, LockManager lockManager, ArtifactManager artifactManager, LauncherInstallations launcherInstallations, String minecraftVersion) throws IOException {
        AssetDownloadResult result;
        AssetDownloader downloader = new AssetDownloader(downloadManager, artifactManager, launcherInstallations, cacheManager, this.assetRoot);
        try {
            result = downloader.downloadAssets(minecraftVersion, this.assetRepository, this.useLauncherAssetRoot, this.copyLauncherAssets, this.concurrentDownloads);
        }
        catch (DownloadsFailedException e) {
            System.err.println(e.getErrors().size() + " files failed to download");
            System.err.println("First error:");
            e.getErrors().getFirst().printStackTrace();
            return 1;
        }
        if (this.outputPropertiesPath != null) {
            result.writeAsProperties(this.outputPropertiesPath);
        }
        if (this.outputJsonPath != null) {
            result.writeAsJson(this.outputJsonPath);
        }
        return 0;
    }
}

