/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;

public class CopyUnpatchedClassesAction
extends BuiltInAction {
    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path patchedClassesFile = environment.getRequiredInputPath("patched");
        Path unpatchedClassesFile = environment.getRequiredInputPath("unpatched");
        Path output = environment.getOutputPath("output");
        try (ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0])));){
            ZipEntry entry;
            HashSet<String> patchedNames = new HashSet<String>();
            try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(Files.newInputStream(patchedClassesFile, new OpenOption[0])));){
                entry = in.getNextEntry();
                while (entry != null) {
                    patchedNames.add(entry.getName());
                    os.putNextEntry(entry);
                    in.transferTo(os);
                    os.closeEntry();
                    entry = in.getNextEntry();
                }
            }
            in = new ZipInputStream(new BufferedInputStream(Files.newInputStream(unpatchedClassesFile, new OpenOption[0])));
            try {
                entry = in.getNextEntry();
                while (entry != null) {
                    if (entry.getName().endsWith(".class") && !patchedNames.contains(entry.getName())) {
                        os.putNextEntry(entry);
                        in.transferTo(os);
                        os.closeEntry();
                    }
                    entry = in.getNextEntry();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

