/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;

public abstract class NodeInput {
    private String id;
    private ExecutionNode node;

    public String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    public ExecutionNode getNode() {
        return this.node;
    }

    void setNode(ExecutionNode node) {
        this.node = node;
    }

    public abstract void replaceReferences(NodeOutput var1, NodeOutput var2);

    public abstract Collection<ExecutionNode> getNodeDependencies();

    public abstract void collectCacheKeyComponent(CacheKeyBuilder var1);

    public abstract <T> T getValue(ResultRepresentation<T> var1) throws IOException;

    public static final class NodeInputForOutput
    extends NodeInput {
        private NodeOutput output;

        public NodeInputForOutput(NodeOutput output) {
            this.output = output;
        }

        public NodeOutput getOutput() {
            return this.output;
        }

        @Override
        public void replaceReferences(NodeOutput oldOutput, NodeOutput newOutput) {
            if (this.output == oldOutput) {
                this.output = newOutput;
                this.getNode().updatePredecessors();
            }
        }

        @Override
        public Collection<ExecutionNode> getNodeDependencies() {
            return Set.of(this.output.getNode());
        }

        @Override
        public void collectCacheKeyComponent(CacheKeyBuilder builder) {
            builder.addPath(this.getId(), this.output.getResultPath());
        }

        @Override
        public <T> T getValue(ResultRepresentation<T> representation) throws IOException {
            return this.output.getResultRepresentation(representation);
        }
    }
}

