/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.downloads;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public record AssetDownloadResult(Path assetRoot, String assetIndexId) {
    public void writeAsProperties(Path destination) throws IOException {
        if (destination.getParent() != null) {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        }
        Properties properties = new Properties();
        properties.put("assets_root", this.assetRoot.toAbsolutePath().toString());
        properties.put("asset_index", this.assetIndexId);
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(destination, new OpenOption[0]));){
            properties.store(out, null);
        }
    }

    public void writeAsJson(Path destination) throws IOException {
        if (destination.getParent() != null) {
            Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("assets", this.assetRoot.toAbsolutePath().toString());
        jsonObject.addProperty("asset_index", this.assetIndexId);
        String jsonString = new Gson().toJson((JsonElement)jsonObject);
        Files.writeString(destination, (CharSequence)jsonString, StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

