/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cache;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.neoforged.neoform.runtime.utils.AnsiColor;
import net.neoforged.neoform.runtime.utils.Logger;
import org.jetbrains.annotations.Nullable;

public class LauncherInstallations {
    private static final Logger LOG = Logger.create();
    private static final String[] CANDIDATES = new String[]{"${env.APPDATA}/.minecraft/", "${user.home}/.minecraft/", "${user.home}/Library/Application Support/minecraft/", "${user.home}/curseforge/minecraft/Install/", "${env.APPDATA}/com.modrinth.theseus/meta/", "${env.LOCALAPPDATA}/.ftba/bin/", "${user.home}/.ftba/bin/", "${user.home}/Library/Application Support/.ftba/bin/", "${user.home}/.local/share/PrismLauncher/", "${user.home}/.local/share/multimc/", "${user.home}/Library/Application Support/PrismLauncher/", "${env.APPDATA}/PrismLauncher/", "${user.home}/scoop/persist/multimc/"};
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([^}]+)}");
    private static final Comparator<LauncherDirectory> ASSET_INDEX_COUNT_DESCENDING = Comparator.comparingInt(d -> d.assetIndices.size()).reversed();
    private final List<LauncherDirectory> launcherDirectories = new ArrayList<LauncherDirectory>();
    private boolean scanned;
    private boolean verbose;

    public LauncherInstallations(List<Path> additionalLauncherDirs) throws IOException {
        for (Path dir : additionalLauncherDirs) {
            LauncherDirectory launcherDir = this.analyzeLauncherDirectory(dir);
            if (launcherDir == null) {
                throw new NoSuchFileException(dir.toString());
            }
            this.launcherDirectories.add(launcherDir);
        }
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public List<Path> getInstallationRoots() {
        this.scanIfNecessary();
        return this.launcherDirectories.stream().map(LauncherDirectory::directory).toList();
    }

    @Nullable
    public Path getAssetDirectoryForIndex(String assetIndexId) {
        this.scanIfNecessary();
        ArrayList<LauncherDirectory> haveIndex = new ArrayList<LauncherDirectory>();
        for (LauncherDirectory launcherDirectory : this.launcherDirectories) {
            if (!launcherDirectory.assetIndices.contains(assetIndexId)) continue;
            haveIndex.add(launcherDirectory);
        }
        haveIndex.sort(ASSET_INDEX_COUNT_DESCENDING);
        if (!haveIndex.isEmpty()) {
            return ((LauncherDirectory)haveIndex.getFirst()).assetDirectory();
        }
        return null;
    }

    public List<Path> getAssetRoots() {
        this.scanIfNecessary();
        ArrayList<LauncherDirectory> launcherDirsWithAssets = new ArrayList<LauncherDirectory>();
        for (LauncherDirectory launcherDirectory : this.launcherDirectories) {
            if (launcherDirectory.assetDirectory() == null) continue;
            launcherDirsWithAssets.add(launcherDirectory);
        }
        launcherDirsWithAssets.sort(ASSET_INDEX_COUNT_DESCENDING);
        return launcherDirsWithAssets.stream().map(LauncherDirectory::assetDirectory).toList();
    }

    private void scanIfNecessary() {
        if (this.scanned) {
            return;
        }
        this.scanned = true;
        if ("true".equals(System.getenv("CI"))) {
            if (this.verbose) {
                LOG.println("Not scanning for Minecraft Launcher installations in CI");
            }
            return;
        }
        if (this.verbose) {
            LOG.println("Scanning for Minecraft Launcher installations");
        }
        for (String candidate : CANDIDATES) {
            String resolvedPath = this.resolvePlaceholders(candidate);
            if (resolvedPath == null) continue;
            try {
                LauncherDirectory result = this.analyzeLauncherDirectory(Paths.get(candidate, new String[0]));
                if (result == null) continue;
                this.launcherDirectories.add(result);
            }
            catch (Exception e) {
                if (!this.verbose) continue;
                LOG.println(" Failed to scan launcher directory " + candidate + ": " + String.valueOf(e));
            }
        }
        if (this.verbose) {
            LOG.println("Launcher directories found:");
            for (LauncherDirectory launcherDirectory : this.launcherDirectories) {
                Object details = launcherDirectory.assetDirectory == null || launcherDirectory.assetIndices().isEmpty() ? "no assets" : "asset indices: " + String.join((CharSequence)" ", launcherDirectory.assetIndices());
                LOG.println(String.valueOf((Object)AnsiColor.MUTED) + "  " + String.valueOf(launcherDirectory.directory) + " (" + (String)details + ")" + String.valueOf((Object)AnsiColor.RESET));
            }
        }
    }

    @Nullable
    private String resolvePlaceholders(String candidate) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(candidate);
        ArrayList unmatchedVariables = new ArrayList();
        candidate = matcher.replaceAll(match -> {
            String variable = match.group(1);
            String value = variable.startsWith("env.") ? System.getenv(variable.substring("env.".length())) : System.getProperty(variable);
            if (value == null) {
                unmatchedVariables.add(variable);
                return "";
            }
            return Matcher.quoteReplacement(value);
        });
        if (!unmatchedVariables.isEmpty()) {
            if (this.verbose) {
                LOG.println("  Skipping candidate " + candidate + " due to undefined references: " + String.valueOf(unmatchedVariables));
            }
            return null;
        }
        return candidate;
    }

    @Nullable
    private LauncherDirectory analyzeLauncherDirectory(Path installDir) throws IOException {
        if (!Files.isDirectory(installDir, new LinkOption[0])) {
            if (this.verbose) {
                LOG.println(String.valueOf((Object)AnsiColor.MUTED) + " Not found: " + String.valueOf(installDir) + String.valueOf((Object)AnsiColor.RESET));
            }
            return null;
        }
        HashSet<String> assetIndices = new HashSet<String>();
        Path assetRoot = installDir.resolve("assets");
        Path assetIndicesDir = assetRoot.resolve("indexes");
        Path assetObjectsDir = assetRoot.resolve("objects");
        if (Files.isDirectory(assetIndicesDir, new LinkOption[0]) && Files.isDirectory(assetObjectsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(assetIndicesDir);){
                stream.map(f -> f.getFileName().toString()).filter(f -> f.endsWith(".json")).map(f -> f.substring(0, f.length() - 5)).forEach(assetIndices::add);
            }
        }
        if (assetIndices.isEmpty()) {
            assetRoot = null;
        }
        return new LauncherDirectory(installDir, assetRoot, assetIndices);
    }

    private record LauncherDirectory(Path directory, @Nullable Path assetDirectory, Set<String> assetIndices) {
    }
}

