/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import net.neoforged.neoform.runtime.actions.ExtensibleClasspath;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;

public class CreateLibrariesOptionsFile {
    private ExtensibleClasspath classpath = new ExtensibleClasspath();

    public Path writeFile(ProcessingEnvironment environment) throws IOException {
        MinecraftVersionManifest versionManifest = environment.getRequiredInput("versionManifest", ResultRepresentation.MINECRAFT_VERSION_MANIFEST);
        List<ClasspathItem> effectiveClasspathItems = this.classpath.mergeWithMinecraftLibraries(versionManifest).getEffectiveClasspath();
        List<Path> classpath = environment.getArtifactManager().resolveClasspath(effectiveClasspathItems);
        List<String> vineflowerArgs = classpath.stream().map(l -> "-e=" + String.valueOf(l.toAbsolutePath())).toList();
        Path libraryListFile = environment.getWorkspace().resolve("libraries.txt");
        Files.write(libraryListFile, vineflowerArgs, new OpenOption[0]);
        return libraryListFile;
    }

    public void computeCacheKey(CacheKeyBuilder ck) {
        this.classpath.computeCacheKey("listLibraries classpath", ck);
    }

    public ExtensibleClasspath getClasspath() {
        return this.classpath;
    }

    public void setClasspath(ExtensibleClasspath classpath) {
        this.classpath = classpath;
    }
}

