/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;

public class ApplyDevTransformsAction
extends ExternalJavaToolAction {
    private List<String> accessTransformersData = new ArrayList<String>();
    private List<Path> additionalAccessTransformers = new ArrayList<Path>();
    private List<Path> injectedInterfaces = new ArrayList<Path>();

    public ApplyDevTransformsAction() {
        super(ToolCoordinate.INSTALLER_TOOLS);
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "--task", "PROCESS_MINECRAFT_JAR", "--input", "{input}", "--output", "{output}", "--no-mod-manifest");
        for (String dataId : this.accessTransformersData) {
            Path accessTransformers = environment.extractData(dataId);
            Stream<Path> stream = Files.walk(accessTransformers, new FileVisitOption[0]);
            try {
                stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                    args.add("--access-transformer");
                    args.add(environment.getPathArgument((Path)path));
                });
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        for (Path path2 : this.additionalAccessTransformers) {
            args.add("--access-transformer");
            args.add(environment.getPathArgument(path2.toAbsolutePath()));
        }
        for (Path path2 : this.injectedInterfaces) {
            args.add("--interface-injection-data");
            args.add(environment.getPathArgument(path2.toAbsolutePath()));
        }
        this.setArgs(args);
        super.run(environment);
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.addStrings("access transformers data ids", this.accessTransformersData);
        ck.addPaths("additional access transformers", this.additionalAccessTransformers);
        ck.addPaths("injected interfaces", this.injectedInterfaces);
    }

    public void setAccessTransformersData(List<String> accessTransformersData) {
        this.accessTransformersData = accessTransformersData;
    }

    public void setAdditionalAccessTransformers(List<Path> additionalAccessTransformers) {
        this.additionalAccessTransformers = additionalAccessTransformers;
    }

    public void setInjectedInterfaces(List<Path> injectedInterfaces) {
        this.injectedInterfaces = List.copyOf(injectedInterfaces);
    }
}

