/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph;

import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutputType;
import net.neoforged.neoform.runtime.graph.NodeState;
import net.neoforged.neoform.runtime.graph.ResultRepresentation;

public final class NodeOutput {
    private final String id;
    private final NodeOutputType type;
    private final String description;
    private ExecutionNode node;
    private Path resultPath;
    private final Map<ResultRepresentation<?>, Object> resultRepresentations = new HashMap();

    public NodeOutput(String id, NodeOutputType type, String description) {
        this.id = id;
        this.type = type;
        this.description = description;
    }

    public ExecutionNode getNode() {
        return Objects.requireNonNull(this.node, "node");
    }

    void setNode(ExecutionNode node) {
        this.node = node;
    }

    public synchronized Path getResultPath() {
        if (this.node.getState() != NodeState.COMPLETED) {
            throw new IllegalStateException("Trying to access " + String.valueOf(this) + " while node is in state " + String.valueOf((Object)this.node.getState()));
        }
        return this.resultPath;
    }

    synchronized void setResultPath(Path result) {
        this.resultPath = result;
    }

    public String id() {
        return this.id;
    }

    public NodeOutputType type() {
        return this.type;
    }

    public String description() {
        return this.description;
    }

    public String toString() {
        return "output '" + this.id + "' of node '" + this.node.id() + "'";
    }

    public NodeInput asInput() {
        return new NodeInput.NodeInputForOutput(this);
    }

    public synchronized <T> T getResultRepresentation(ResultRepresentation<T> representation) throws IOException {
        Object cachedResult = this.resultRepresentations.get(representation);
        if (cachedResult == null) {
            cachedResult = representation.loader().load(this.getResultPath());
            this.resultRepresentations.put(representation, cachedResult);
        }
        return representation.resultClass().cast(cachedResult);
    }
}

