/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.actions.ApplyDevTransformsAction;
import net.neoforged.neoform.runtime.actions.ApplySourceTransformAction;
import net.neoforged.neoform.runtime.actions.CopyUnpatchedClassesAction;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.actions.InjectFromZipFileSource;
import net.neoforged.neoform.runtime.actions.InjectZipContentAction;
import net.neoforged.neoform.runtime.actions.MergeWithSourcesAction;
import net.neoforged.neoform.runtime.actions.PatchActionFactory;
import net.neoforged.neoform.runtime.actions.RecompileSourcesAction;
import net.neoforged.neoform.runtime.actions.StripManifestDigestContentFilter;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.artifacts.ClasspathItem;
import net.neoforged.neoform.runtime.cli.NeoFormEngineCommand;
import net.neoforged.neoform.runtime.config.neoforge.BinpatcherConfig;
import net.neoforged.neoform.runtime.config.neoforge.NeoForgeConfig;
import net.neoforged.neoform.runtime.engine.DataSource;
import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeBuilder;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.NodeOutputType;
import net.neoforged.neoform.runtime.graph.transforms.ModifyAction;
import net.neoforged.neoform.runtime.graph.transforms.ReplaceNodeOutput;
import net.neoforged.neoform.runtime.utils.FileUtil;
import net.neoforged.neoform.runtime.utils.HashingUtil;
import net.neoforged.neoform.runtime.utils.Logger;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;
import picocli.CommandLine;

@CommandLine.Command(name="run", description={"Run the NeoForm engine and produce Minecraft artifacts"})
public class RunNeoFormCommand
extends NeoFormEngineCommand {
    private static final Logger LOG = Logger.create();
    @CommandLine.ArgGroup(exclusive=false, multiplicity="1")
    SourceArtifacts sourceArtifacts;
    @CommandLine.Option(names={"--dist"}, required=true)
    String dist;
    @CommandLine.Option(names={"--write-result"}, arity="*")
    List<String> writeResults = new ArrayList<String>();
    @CommandLine.Option(names={"--access-transformer"}, arity="*", description={"path to an access transformer file, which widens the access modifiers of classes/methods/fields"})
    List<String> additionalAccessTransformers = new ArrayList<String>();
    @CommandLine.Option(names={"--validated-access-transformer"}, arity="*", description={"same as --access-transformer, but files added using this option will fail the build if they contain targets that do not exist."})
    List<String> validatedAccessTransformers = new ArrayList<String>();
    @CommandLine.Option(names={"--interface-injection-data"}, arity="*", description={"path to an interface injection data file, which extends classes with implements/extends clauses."})
    List<Path> interfaceInjectionDataFiles = new ArrayList<Path>();
    @Deprecated
    @CommandLine.Option(names={"--validate-access-transformers"}, description={"[DEPRECATED] Use --validated-access-transformer instead"})
    boolean validateAccessTransformers;
    @CommandLine.Option(names={"--parchment-data"}, description={"Path or Maven coordinates of parchment data to use"})
    String parchmentData;
    @CommandLine.Option(names={"--parchment-conflict-prefix"}, description={"Setting this option enables automatic Parchment parameter conflict resolution and uses this prefix for parameter names that clash."})
    String parchmentConflictPrefix;

    @Override
    protected void runWithNeoFormEngine(NeoFormEngine engine, List<AutoCloseable> closables) throws IOException, InterruptedException {
        ArtifactManager artifactManager = engine.getArtifactManager();
        if (this.sourceArtifacts.neoforge != null) {
            Path neoformArtifact;
            Artifact neoforgeArtifact = artifactManager.get(this.sourceArtifacts.neoforge);
            JarFile neoforgeZipFile = engine.addManagedResource(new JarFile(neoforgeArtifact.path().toFile()));
            NeoForgeConfig neoforgeConfig = NeoForgeConfig.from(neoforgeZipFile);
            if (this.sourceArtifacts.neoform != null) {
                LOG.println("Overriding NeoForm version " + neoforgeConfig.neoformArtifact() + " with CLI argument " + this.sourceArtifacts.neoform);
                neoformArtifact = artifactManager.get(this.sourceArtifacts.neoform).path();
            } else {
                neoformArtifact = artifactManager.get(neoforgeConfig.neoformArtifact()).path();
            }
            engine.loadNeoFormData(neoformArtifact, this.dist);
            RunNeoFormCommand.applyNeoForgeProcessTransforms(engine, neoforgeZipFile, neoforgeConfig);
        } else {
            Path neoFormDataPath = artifactManager.get(this.sourceArtifacts.neoform).path();
            engine.loadNeoFormData(neoFormDataPath, this.dist);
        }
        this.applyAdditionalAccessTransformers(engine);
        if (this.parchmentData != null) {
            Artifact parchmentDataFile = artifactManager.get(this.parchmentData);
            Consumer<ApplySourceTransformAction> jstConsumer = transformSources -> {
                transformSources.setParchmentData(parchmentDataFile.path());
                if (this.parchmentConflictPrefix != null) {
                    transformSources.addArg("--parchment-conflict-prefix=" + this.parchmentConflictPrefix);
                }
            };
            if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
                engine.applyTransform(new ReplaceNodeOutput("remapSrgSourcesToOfficial", "output", "applyParchment", RunNeoFormCommand.sourceTransform(engine, jstConsumer)));
            } else {
                jstConsumer.accept(RunNeoFormCommand.getOrAddTransformSourcesAction(engine));
            }
        }
        if (!this.interfaceInjectionDataFiles.isEmpty()) {
            ExecutionNode transformNode = RunNeoFormCommand.getOrAddTransformSourcesNode(engine);
            ((ApplySourceTransformAction)transformNode.action()).setInjectedInterfaces(this.interfaceInjectionDataFiles);
            engine.applyTransform(new ModifyAction<RecompileSourcesAction>("recompile", RecompileSourcesAction.class, action -> action.getSourcepath().add(ClasspathItem.of(transformNode.getRequiredOutput("stubs")))));
        }
        if (!(this.additionalAccessTransformers.isEmpty() && this.validatedAccessTransformers.isEmpty() && this.interfaceInjectionDataFiles.isEmpty())) {
            ApplyDevTransformsAction applyDevTransforms = RunNeoFormCommand.getOrAddDevTransformsAction(engine);
            ArrayList<Path> allAts = new ArrayList<Path>();
            allAts.addAll(this.additionalAccessTransformers.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
            allAts.addAll(this.validatedAccessTransformers.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
            applyDevTransforms.setAdditionalAccessTransformers(allAts);
            applyDevTransforms.setInjectedInterfaces(this.interfaceInjectionDataFiles);
        }
        this.execute(engine);
    }

    private static void applyNeoForgeProcessTransforms(NeoFormEngine engine, JarFile neoforgeZipFile, NeoForgeConfig neoforgeConfig) throws IOException {
        List<String> sasFiles;
        engine.addDataSource("neoForgeAccessTransformers", neoforgeZipFile, neoforgeConfig.accessTransformersFolder());
        ArtifactManager artifactManager = engine.getArtifactManager();
        Path neoforgeSources = artifactManager.get(neoforgeConfig.sourcesArtifact()).path();
        Path neoforgeClasses = artifactManager.get(neoforgeConfig.universalArtifact()).path();
        ZipFile neoforgeSourcesZip = new ZipFile(neoforgeSources.toFile());
        ZipFile neoforgeClassesZip = new ZipFile(neoforgeClasses.toFile());
        engine.addManagedResource(neoforgeSourcesZip);
        engine.addManagedResource(neoforgeClassesZip);
        ApplySourceTransformAction transformSources = RunNeoFormCommand.getOrAddTransformSourcesAction(engine);
        transformSources.setAccessTransformersData(List.of("neoForgeAccessTransformers"));
        if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
            engine.applyTransform(new ModifyAction<InjectZipContentAction>("inject", InjectZipContentAction.class, action -> {
                action.getInjectedSources().add(new InjectFromZipFileSource(neoforgeClassesZip, "/", Pattern.compile("^(?!META-INF/[^/]+\\.(SF|RSA|DSA|EC)$|.*\\.class$).*"), StripManifestDigestContentFilter.INSTANCE));
                action.getInjectedSources().add(new InjectFromZipFileSource(neoforgeSourcesZip, "/", Pattern.compile("^(?!META-INF/MANIFEST.MF$).*")));
            }));
        }
        engine.applyTransform(new ModifyAction<RecompileSourcesAction>("recompile", RecompileSourcesAction.class, action -> {
            action.getClasspath().addMavenLibraries(neoforgeConfig.libraries());
            action.getClasspath().addPaths(List.of(neoforgeClasses));
        }));
        if (engine.getProcessGeneration().supportsSideAnnotationStripping() && !(sasFiles = neoforgeConfig.sideAnnotationStrippers()).isEmpty()) {
            for (int i = 0; i < sasFiles.size(); ++i) {
                engine.addDataSource("sasFile" + i, neoforgeZipFile, sasFiles.get(i));
            }
            engine.applyTransform(new ReplaceNodeOutput("rename", "output", "stripSideAnnotations", (builder, previousOutput) -> {
                builder.input("input", previousOutput.asInput());
                ExternalJavaToolAction action = new ExternalJavaToolAction(ToolCoordinate.MCF_SIDE_ANNOTATION_STRIPPER);
                ArrayList<String> args = new ArrayList<String>();
                Collections.addAll(args, "--strip", "--input", "{input}", "--output", "{output}");
                for (int i = 0; i < sasFiles.size(); ++i) {
                    args.add("--data");
                    args.add("{sasFile" + i + "}");
                }
                action.setArgs(args);
                builder.action(action);
                return builder.output("output", NodeOutputType.JAR, "The jar file with the desired side annotations removed");
            }));
        }
        engine.applyTransform(new ReplaceNodeOutput("patch", "output", "applyNeoforgePatches", (builder, previousOutput) -> PatchActionFactory.makeAction(builder, new DataSource(neoforgeZipFile, neoforgeConfig.patchesFolder(), engine.getFileHashingService()), previousOutput, Objects.requireNonNullElse(neoforgeConfig.basePathPrefix(), "a/"), Objects.requireNonNullElse(neoforgeConfig.modifiedPathPrefix(), "b/"))));
        ExecutionGraph graph = engine.getGraph();
        NodeOutput sourcesWithNeoForgeOutput = RunNeoFormCommand.createSourcesWithNeoForge(engine, neoforgeSourcesZip);
        NodeOutput compiledWithNeoForgeOutput = RunNeoFormCommand.createCompiledWithNeoForge(engine, neoforgeClassesZip);
        NodeOutput sourcesAndCompiledWithNeoForgeOutput = RunNeoFormCommand.createSourcesAndCompiledWithNeoForge(graph, compiledWithNeoForgeOutput, sourcesWithNeoForgeOutput);
        graph.setResult("gameSourcesWithNeoForge", sourcesWithNeoForgeOutput);
        graph.setResult("gameJarWithNeoForge", compiledWithNeoForgeOutput);
        graph.setResult("gameJarWithSourcesAndNeoForge", sourcesAndCompiledWithNeoForgeOutput);
        NodeOutput renamedOutput = graph.getRequiredOutput("rename", "output");
        engine.addDataSource("patch", neoforgeZipFile, neoforgeConfig.binaryPatchesFile());
        NodeOutput binaryPatchOnlyOutput = RunNeoFormCommand.createBinaryPatch(graph, renamedOutput, neoforgeConfig.binaryPatcherConfig());
        NodeOutput binaryPatchOutput = RunNeoFormCommand.createCopyUnpatchedClasses(graph, renamedOutput, binaryPatchOnlyOutput);
        NodeOutput binaryWithNeoForgeOutput = RunNeoFormCommand.createBinaryWithNeoForge(graph, binaryPatchOutput, neoforgeClassesZip);
        if (!engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
            graph.setResult("gameJarNoRecomp", binaryPatchOutput);
            graph.setResult("gameJarNoRecompWithNeoForge", binaryWithNeoForgeOutput);
        } else {
            NodeOutput remapOutput = graph.getRequiredOutput("remapSrgClassesToOfficial", "output");
            remapOutput.getNode().setInput("input", binaryWithNeoForgeOutput.asInput());
            graph.setResult("gameJarNoRecomp", remapOutput);
            graph.setResult("gameJarNoRecompWithNeoForge", remapOutput);
        }
        RunNeoFormCommand.getOrAddDevTransformsAction(engine).setAccessTransformersData(List.of("neoForgeAccessTransformers"));
    }

    private void applyAdditionalAccessTransformers(NeoFormEngine engine) {
        if (!this.additionalAccessTransformers.isEmpty() || !this.validatedAccessTransformers.isEmpty()) {
            ApplySourceTransformAction transformSources = RunNeoFormCommand.getOrAddTransformSourcesAction(engine);
            transformSources.setAdditionalAccessTransformers(this.additionalAccessTransformers.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
            transformSources.setValidatedAccessTransformers(this.validatedAccessTransformers.stream().map(x$0 -> Paths.get(x$0, new String[0])).toList());
            if (this.validateAccessTransformers) {
                transformSources.addArg("--access-transformer-validation=error");
            }
        }
    }

    private static NodeOutput createCompiledWithNeoForge(NeoFormEngine engine, ZipFile neoforgeClassesZip) {
        ExecutionGraph graph = engine.getGraph();
        NodeOutput recompiledClasses = graph.getRequiredOutput("recompile", "output");
        if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
            return recompiledClasses;
        }
        ExecutionNodeBuilder builder = graph.nodeBuilder("compiledWithNeoForge");
        builder.input("input", recompiledClasses.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "JAR containing NeoForge classes, resources and Minecraft classes");
        builder.action(new InjectZipContentAction(List.of(new InjectFromZipFileSource(neoforgeClassesZip, "/"))));
        builder.build();
        return output;
    }

    private static NodeOutput createSourcesWithNeoForge(NeoFormEngine engine, ZipFile neoforgeSourcesZip) {
        ExecutionGraph graph = engine.getGraph();
        if (engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
            return graph.getRequiredOutput("remapSrgSourcesToOfficial", "output");
        }
        NodeOutput transformedSourceOutput = graph.getRequiredOutput("transformSources", "output");
        ExecutionNodeBuilder builder = graph.nodeBuilder("sourcesWithNeoForge");
        builder.input("input", transformedSourceOutput.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.ZIP, "Source ZIP containing NeoForge and Minecraft sources");
        builder.action(new InjectZipContentAction(List.of(new InjectFromZipFileSource(neoforgeSourcesZip, "/"))));
        builder.build();
        return output;
    }

    private static NodeOutput createSourcesAndCompiledWithNeoForge(ExecutionGraph graph, NodeOutput compiledWithNeoForgeOutput, NodeOutput sourcesWithNeoForgeOutput) {
        ExecutionNodeBuilder builder = graph.nodeBuilder("sourcesAndCompiledWithNeoForge");
        builder.input("classes", compiledWithNeoForgeOutput.asInput());
        builder.input("sources", sourcesWithNeoForgeOutput.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "Combined output of sourcesWithNeoForge and compiledWithNeoForge");
        builder.action(new MergeWithSourcesAction());
        builder.build();
        return output;
    }

    private static NodeOutput createBinaryPatch(ExecutionGraph graph, NodeOutput clean, BinpatcherConfig config) {
        ExecutionNodeBuilder builder = graph.nodeBuilder("binaryPatch");
        builder.input("clean", clean.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "JAR containing the patched Minecraft classes");
        ExternalJavaToolAction action = new ExternalJavaToolAction(MavenCoordinate.parse(config.version()));
        action.setArgs(config.args());
        builder.action(action);
        builder.build();
        return output;
    }

    private static NodeOutput createCopyUnpatchedClasses(ExecutionGraph graph, NodeOutput clean, NodeOutput binaryPatched) {
        ExecutionNodeBuilder builder = graph.nodeBuilder("copyUnpatchedClasses");
        builder.input("patched", binaryPatched.asInput());
        builder.input("unpatched", clean.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "JAR containing the patched and clean (if not patched) Minecraft classes");
        builder.action(new CopyUnpatchedClassesAction());
        builder.build();
        return output;
    }

    private static NodeOutput createBinaryWithNeoForge(ExecutionGraph graph, NodeOutput binary, ZipFile neoforgeClassesZip) {
        ExecutionNodeBuilder builder = graph.nodeBuilder("binaryWithNeoForge");
        builder.input("input", binary.asInput());
        NodeOutput output = builder.output("output", NodeOutputType.JAR, "JAR containing NeoForge classes, resources and Minecraft classes");
        builder.action(new InjectZipContentAction(List.of(new InjectFromZipFileSource(neoforgeClassesZip, "/"))));
        builder.build();
        return output;
    }

    private void execute(NeoFormEngine engine) throws InterruptedException, IOException {
        Map<String, Path> neededResults;
        if (this.printGraph) {
            StringWriter stringWriter = new StringWriter();
            engine.dumpGraph(new PrintWriter(stringWriter));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try (DeflaterOutputStream dos = new DeflaterOutputStream(bos);){
                JsonObject obj = new JsonObject();
                obj.addProperty("code", stringWriter.toString());
                dos.write(obj.toString().getBytes(StandardCharsets.UTF_8));
            }
            LOG.println("Open in Browser: https://mermaid.live/view#pako:" + Base64.getEncoder().encodeToString(bos.toByteArray()));
        }
        if ((neededResults = this.writeResults.stream().map(encodedResult -> {
            String[] parts = encodedResult.split(":", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Specify a result destination in the form: <resultid>:<destination>");
            }
            return parts;
        }).collect(Collectors.toMap(parts -> parts[0], parts -> Paths.get(parts[1], new String[0])))).isEmpty() && !this.printGraph) {
            System.err.println("No results requested using --write-result=<result>:<path>. Available results: " + String.valueOf(engine.getGraph().getAvailableResults()));
            System.exit(1);
        }
        Map<String, Path> results = engine.createResults(neededResults.keySet().toArray(new String[0]));
        for (Map.Entry<String, Path> entry : neededResults.entrySet()) {
            Path result = results.get(entry.getKey());
            if (result == null) {
                throw new IllegalStateException("Result " + entry.getKey() + " was requested but not produced");
            }
            String resultFileHash = HashingUtil.hashFile(result, "SHA-1");
            try {
                if (HashingUtil.hashFile(entry.getValue(), "SHA-1").equals(resultFileHash)) {
                    continue;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
            Path tmpFile = Paths.get(String.valueOf(entry.getValue()) + ".tmp", new String[0]);
            Files.copy(result, tmpFile, StandardCopyOption.REPLACE_EXISTING);
            FileUtil.atomicMove(tmpFile, entry.getValue());
        }
    }

    private static ApplySourceTransformAction getOrAddTransformSourcesAction(NeoFormEngine engine) {
        return (ApplySourceTransformAction)RunNeoFormCommand.getOrAddTransformSourcesNode(engine).action();
    }

    private static ExecutionNode getOrAddTransformSourcesNode(NeoFormEngine engine) {
        ExecutionGraph graph = engine.getGraph();
        ExecutionNode transformNode = graph.getNode("transformSources");
        if (transformNode != null) {
            if (transformNode.action() instanceof ApplySourceTransformAction) {
                return transformNode;
            }
            throw new IllegalStateException("Node transformSources has a different action type than expected. Expected: " + String.valueOf(ApplySourceTransformAction.class) + " but got " + String.valueOf(transformNode.action().getClass()));
        }
        new ReplaceNodeOutput("patch", "output", "transformSources", RunNeoFormCommand.sourceTransform(engine, applySourceTransformAction -> {})).apply(engine, graph);
        return RunNeoFormCommand.getOrAddTransformSourcesNode(engine);
    }

    private static ReplaceNodeOutput.NodeFactory sourceTransform(NeoFormEngine engine, Consumer<ApplySourceTransformAction> actionConsumer) {
        return (builder, previousNodeOutput) -> {
            builder.input("input", previousNodeOutput.asInput());
            builder.inputFromNodeOutput("versionManifest", "downloadJson", "output");
            ApplySourceTransformAction action = new ApplySourceTransformAction();
            ExternalJavaToolAction renameAction = (ExternalJavaToolAction)engine.getGraph().getNode("rename").action();
            action.getListLibraries().setClasspath(renameAction.getListLibraries().getClasspath().copy());
            builder.action(action);
            actionConsumer.accept(action);
            builder.output("stubs", NodeOutputType.JAR, "Additional stubs (resulted as part of interface injection) to add to the recompilation classpath");
            return builder.output("output", NodeOutputType.ZIP, "Sources with additional transforms (ATs, Parchment, Interface Injections) applied");
        };
    }

    private static ApplyDevTransformsAction getOrAddDevTransformsAction(NeoFormEngine engine) {
        return (ApplyDevTransformsAction)RunNeoFormCommand.getOrAddDevTransformsNode(engine).action();
    }

    private static ExecutionNode getOrAddDevTransformsNode(NeoFormEngine engine) {
        NodeOutput untransformedOutput;
        ExecutionGraph graph = engine.getGraph();
        ExecutionNode transformNode = graph.getNode("applyDevTransforms");
        if (transformNode != null) {
            if (transformNode.action() instanceof ApplyDevTransformsAction) {
                return transformNode;
            }
            throw new IllegalStateException("Node applyDevTransforms has a different action type than expected. Expected: " + String.valueOf(ApplyDevTransformsAction.class) + " but got " + String.valueOf(transformNode.action().getClass()));
        }
        if (!engine.getProcessGeneration().sourcesUseIntermediaryNames()) {
            untransformedOutput = engine.getGraph().getResult("gameJarNoRecomp");
        } else {
            NodeInput nodeInput;
            ExecutionNode remapSrgClasses = engine.getGraph().getNode("remapSrgClassesToOfficial");
            if (remapSrgClasses == null || !((nodeInput = remapSrgClasses.getRequiredInput("input")) instanceof NodeInput.NodeInputForOutput)) {
                throw new IllegalStateException("Could not find SRG input to apply dev transform to.");
            }
            NodeInput.NodeInputForOutput nifo = (NodeInput.NodeInputForOutput)nodeInput;
            untransformedOutput = nifo.getOutput();
        }
        new ReplaceNodeOutput(untransformedOutput.getNode().id(), untransformedOutput.id(), "applyDevTransforms", (builder, previousOutput) -> {
            builder.input("input", previousOutput.asInput());
            NodeOutput transformedOutput = builder.output("output", NodeOutputType.JAR, "The jar file with the desired dev transforms applied.");
            builder.action(new ApplyDevTransformsAction());
            return transformedOutput;
        }).apply(engine, graph);
        return RunNeoFormCommand.getOrAddDevTransformsNode(engine);
    }

    static class SourceArtifacts {
        @CommandLine.Option(names={"--neoform"})
        String neoform;
        @CommandLine.Option(names={"--neoforge"})
        String neoforge;

        SourceArtifacts() {
        }
    }
}

