/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.manifests;

import java.util.regex.Pattern;
import net.neoforged.neoform.runtime.utils.OsUtil;
import org.jetbrains.annotations.Nullable;

public record OsCondition(@Nullable String name, @Nullable String version, @Nullable String arch) {
    public boolean nameMatches() {
        if (this.name == null) {
            return true;
        }
        return switch (this.name) {
            case "linux" -> OsUtil.isLinux();
            case "osx" -> OsUtil.isMac();
            case "windows" -> OsUtil.isWindows();
            default -> false;
        };
    }

    public boolean versionMatches() {
        return this.version == null || Pattern.compile(this.version).matcher(System.getProperty("os.version")).find();
    }

    public boolean archMatches() {
        return this.arch == null || Pattern.compile(this.arch).matcher(System.getProperty("os.arch")).find();
    }

    public boolean platformMatches() {
        return this.nameMatches() && this.versionMatches() && this.archMatches();
    }
}

