/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cache.LauncherInstallations;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.cli.Main;
import net.neoforged.neoform.runtime.config.neoforge.NeoForgeConfig;
import net.neoforged.neoform.runtime.config.neoform.NeoFormConfig;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import picocli.CommandLine;

public abstract class MinecraftCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    Main commonOptions;
    @CommandLine.ArgGroup(multiplicity="1")
    public Version version;

    @Override
    public Integer call() throws Exception {
        try (DownloadManager downloadManager = new DownloadManager();){
            Integer n;
            block11: {
                CacheManager cacheManager = this.commonOptions.createCacheManager();
                try {
                    LockManager lockManager = this.commonOptions.createLockManager();
                    LauncherInstallations launcherInstallations = this.commonOptions.createLauncherInstallations();
                    ArtifactManager artifactManager = this.commonOptions.createArtifactManager(cacheManager, downloadManager, lockManager, launcherInstallations);
                    String minecraftVersion = this.getMinecraftVersion(artifactManager);
                    n = this.runMinecraftCommand(downloadManager, cacheManager, lockManager, artifactManager, launcherInstallations, minecraftVersion);
                    if (cacheManager == null) break block11;
                }
                catch (Throwable throwable) {
                    if (cacheManager != null) {
                        try {
                            cacheManager.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cacheManager.close();
            }
            return n;
        }
    }

    protected abstract int runMinecraftCommand(DownloadManager var1, CacheManager var2, LockManager var3, ArtifactManager var4, LauncherInstallations var5, String var6) throws IOException;

    private String getMinecraftVersion(ArtifactManager artifactManager) throws IOException {
        Artifact neoFormArchive;
        if (this.version.minecraftVersion != null) {
            return this.version.minecraftVersion;
        }
        if (this.version.neoformArtifact != null) {
            neoFormArchive = artifactManager.get(this.version.neoformArtifact);
        } else {
            Artifact neoforgeArtifact = artifactManager.get(this.version.neoforgeArtifact);
            try (JarFile neoforgeZipFile = new JarFile(neoforgeArtifact.path().toFile());){
                NeoForgeConfig neoforgeConfig = NeoForgeConfig.from(neoforgeZipFile);
                neoFormArchive = artifactManager.get(neoforgeConfig.neoformArtifact());
            }
        }
        try (ZipFile zipFile = new ZipFile(neoFormArchive.path().toFile());){
            String string = NeoFormConfig.from(zipFile).minecraftVersion();
            return string;
        }
    }

    public static class Version {
        @CommandLine.Option(names={"--minecraft-version"})
        String minecraftVersion;
        @CommandLine.Option(names={"--neoform"})
        String neoformArtifact;
        @CommandLine.Option(names={"--neoforge"})
        String neoforgeArtifact;
    }
}

