/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.graph.ExecutionNodeAction;
import net.neoforged.srgutils.IMappingFile;

public class CreateLegacyMappingsAction
implements ExecutionNodeAction {
    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path first = environment.getRequiredInputPath("officialToObf");
        Path second = environment.getRequiredInputPath("obfToSrg");
        IMappingFile firstMappings = IMappingFile.load((File)first.toFile());
        IMappingFile secondMappings = IMappingFile.load((File)second.toFile());
        IMappingFile officialToSrg = firstMappings.chain(secondMappings);
        officialToSrg.write(environment.getOutputPath("officialToSrg"), IMappingFile.Format.TSRG, false);
        IMappingFile srgToOfficial = officialToSrg.reverse();
        srgToOfficial.write(environment.getOutputPath("srgToOfficial"), IMappingFile.Format.SRG, false);
        try (ZipOutputStream zipCsv = new ZipOutputStream(Files.newOutputStream(environment.getOutputPath("csvMappings"), new OpenOption[0]));){
            CreateLegacyMappingsAction.writeCsv(zipCsv, "methods.csv", srgToOfficial.getClasses().stream().flatMap(c -> c.getMethods().stream()).filter(c -> c.getOriginal().startsWith("m_")));
            CreateLegacyMappingsAction.writeCsv(zipCsv, "fields.csv", srgToOfficial.getClasses().stream().flatMap(c -> c.getFields().stream()).filter(c -> c.getOriginal().startsWith("f_")));
        }
    }

    private static void writeCsv(ZipOutputStream stream, String name, Stream<? extends IMappingFile.INode> nodes) throws IOException {
        stream.putNextEntry(new ZipEntry(name));
        stream.write(("searge,name,side,desc\n" + nodes.map(n -> n.getOriginal() + "," + n.getMapped() + ",0,").collect(Collectors.joining("\n"))).getBytes(StandardCharsets.UTF_8));
        stream.closeEntry();
    }
}

