/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.neoforged.neoform.runtime.actions.BuiltInAction;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;

public class MergeWithSourcesAction
extends BuiltInAction {
    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        Path classesFile = environment.getRequiredInputPath("classes");
        Path sourcesFile = environment.getRequiredInputPath("sources");
        Path output = environment.getOutputPath("output");
        try (ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(Files.newOutputStream(output, new OpenOption[0])));){
            ZipEntry entry;
            try (ZipInputStream in = new ZipInputStream(new BufferedInputStream(Files.newInputStream(classesFile, new OpenOption[0])));){
                entry = in.getNextEntry();
                while (entry != null) {
                    os.putNextEntry(entry);
                    in.transferTo(os);
                    os.closeEntry();
                    entry = in.getNextEntry();
                }
            }
            in = new ZipInputStream(new BufferedInputStream(Files.newInputStream(sourcesFile, new OpenOption[0])));
            try {
                entry = in.getNextEntry();
                while (entry != null) {
                    block21: {
                        if (entry.getName().endsWith(".java")) {
                            try {
                                os.putNextEntry(entry);
                                in.transferTo(os);
                                os.closeEntry();
                            }
                            catch (ZipException e) {
                                if (e.getMessage().startsWith("duplicate entry:")) break block21;
                                throw e;
                            }
                        }
                    }
                    entry = in.getNextEntry();
                }
            }
            finally {
                in.close();
            }
        }
    }
}

