/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.cache.CacheKeyBuilder;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;

public class ApplyDevTransformsAction
extends ExternalJavaToolAction {
    private List<Path> accessTransformers = new ArrayList<Path>();
    private List<Path> injectedInterfaces = new ArrayList<Path>();

    public ApplyDevTransformsAction() {
        super(ToolCoordinate.INSTALLER_TOOLS);
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        Collections.addAll(args, "--task", "PROCESS_MINECRAFT_JAR", "--input", "{input}", "--output", "{output}", "--no-mod-manifest");
        for (Path path : this.accessTransformers) {
            args.add("--access-transformer");
            args.add(environment.getPathArgument(path.toAbsolutePath()));
        }
        for (Path path : this.injectedInterfaces) {
            args.add("--interface-injection-data");
            args.add(environment.getPathArgument(path.toAbsolutePath()));
        }
        this.setArgs(args);
        super.run(environment);
    }

    @Override
    public void computeCacheKey(CacheKeyBuilder ck) {
        super.computeCacheKey(ck);
        ck.addPaths("access transformers", this.accessTransformers);
        ck.addPaths("injected interfaces", this.injectedInterfaces);
    }

    public void setAccessTransformers(List<Path> accessTransformers) {
        this.accessTransformers = accessTransformers;
    }

    public void setInjectedInterfaces(List<Path> injectedInterfaces) {
        this.injectedInterfaces = List.copyOf(injectedInterfaces);
    }
}

