/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.graph.transforms;

import net.neoforged.neoform.runtime.engine.NeoFormEngine;
import net.neoforged.neoform.runtime.graph.ExecutionGraph;
import net.neoforged.neoform.runtime.graph.ExecutionNode;
import net.neoforged.neoform.runtime.graph.ExecutionNodeBuilder;
import net.neoforged.neoform.runtime.graph.NodeInput;
import net.neoforged.neoform.runtime.graph.NodeOutput;
import net.neoforged.neoform.runtime.graph.transforms.GraphTransform;

public final class ReplaceNodeInput
extends GraphTransform {
    private final String nodeId;
    private final String inputId;
    private final String newNodeId;
    private final NodeFactory nodeFactory;

    public ReplaceNodeInput(String nodeId, String inputId, String newNodeId, NodeFactory nodeFactory) {
        this.nodeId = nodeId;
        this.inputId = inputId;
        this.newNodeId = newNodeId;
        this.nodeFactory = nodeFactory;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public String inputId() {
        return this.inputId;
    }

    @Override
    public void apply(NeoFormEngine engine, ExecutionGraph graph) {
        NodeInput originalInput = graph.getRequiredInput(this.nodeId, this.inputId);
        ExecutionNode originalNode = originalInput.getNode();
        ExecutionNodeBuilder builder = graph.nodeBuilder(this.newNodeId);
        NodeOutput newOutput = this.nodeFactory.make(builder, originalInput);
        builder.build();
        originalNode.setInput(this.inputId, newOutput.asInput());
    }

    @FunctionalInterface
    public static interface NodeFactory {
        public NodeOutput make(ExecutionNodeBuilder var1, NodeInput var2);
    }
}

