/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.actions;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import net.neoforged.neoform.runtime.actions.ExternalJavaToolAction;
import net.neoforged.neoform.runtime.actions.RemapSrgSourcesAction;
import net.neoforged.neoform.runtime.engine.ProcessingEnvironment;
import net.neoforged.neoform.runtime.utils.ToolCoordinate;
import net.neoforged.srgutils.IMappingFile;

public class RemapSrgClassesAction
extends ExternalJavaToolAction {
    public RemapSrgClassesAction() {
        super(ToolCoordinate.AUTO_RENAMING_TOOL);
    }

    @Override
    public void run(ProcessingEnvironment environment) throws IOException, InterruptedException {
        IMappingFile srgToOfficial = RemapSrgSourcesAction.buildSrgToOfficialMappings(environment);
        Path mappingsFile = environment.getWorkspace().resolve("mappings.tsrg2");
        srgToOfficial.write(mappingsFile, IMappingFile.Format.TSRG2, false);
        this.setArgs(List.of("--input", "{input}", "--output", "{output}", "--map", environment.getPathArgument(mappingsFile.toAbsolutePath())));
        super.run(environment);
    }
}

