/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

public record MavenCoordinate(String groupId, String artifactId, String extension, String classifier, String version) {
    public static final TypeAdapter<MavenCoordinate> TYPE_ADAPTER = new TypeAdapter<MavenCoordinate>(){

        @Override
        public void write(JsonWriter out, MavenCoordinate value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(value.toString());
            }
        }

        @Override
        public MavenCoordinate read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return MavenCoordinate.parse(in.nextString());
        }
    };

    public MavenCoordinate {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        Objects.requireNonNull(version);
        if (extension == null || "jar".equals(extension)) {
            extension = "";
        }
        if (classifier == null) {
            classifier = "";
        }
    }

    public static MavenCoordinate parse(String coordinate) {
        String[] parts;
        String[] coordinateAndExt = coordinate.split("@");
        String extension = "";
        if (coordinateAndExt.length > 2) {
            throw new IllegalArgumentException("Malformed Maven coordinate: " + coordinate);
        }
        if (coordinateAndExt.length == 2) {
            extension = coordinateAndExt[1];
            coordinate = coordinateAndExt[0];
        }
        if ((parts = coordinate.split(":")).length != 3 && parts.length != 4) {
            throw new IllegalArgumentException("Malformed Maven coordinate: " + coordinate);
        }
        String groupId = parts[0];
        String artifactId = parts[1];
        String version = parts[2];
        String classifier = parts.length == 4 ? parts[3] : "";
        return new MavenCoordinate(groupId, artifactId, extension, classifier, version);
    }

    public Path toRelativeRepositoryPath() {
        String fileName = this.artifactId + "-" + this.version + (String)(!this.classifier.isEmpty() ? "-" + this.classifier : "") + (String)(!this.extension.isEmpty() ? "." + this.extension : ".jar");
        String[] groups = this.groupId.split("\\.");
        Path result = Paths.get(groups[0], new String[0]);
        for (int i = 1; i < groups.length; ++i) {
            result = result.resolve(groups[i]);
        }
        return result.resolve(this.artifactId).resolve(this.version).resolve(fileName);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.groupId).append(":").append(this.artifactId).append(":").append(this.version);
        if (!this.classifier.isEmpty()) {
            result.append(":").append(this.classifier);
        }
        if (!this.extension.isEmpty()) {
            result.append("@").append(this.extension);
        }
        return result.toString();
    }

    public URI toRepositoryUri(URI baseUri) {
        String originalBaseUri = baseUri.toString();
        String relativePath = this.toRelativeRepositoryPath().toString().replace('\\', '/');
        if (originalBaseUri.endsWith("/")) {
            return URI.create(originalBaseUri + relativePath);
        }
        return URI.create(originalBaseUri + "/" + relativePath);
    }

    public MavenCoordinate withClassifier(String classifier) {
        return new MavenCoordinate(this.groupId, this.artifactId, this.extension, classifier, this.version);
    }

    public MavenCoordinate withVersion(String version) {
        return new MavenCoordinate(this.groupId, this.artifactId, this.extension, this.classifier, version);
    }

    public boolean equalsWithoutVersion(MavenCoordinate other) {
        return Objects.equals(this.groupId, other.groupId) && Objects.equals(this.artifactId, other.artifactId) && Objects.equals(this.classifier, other.classifier) && Objects.equals(this.extension, other.extension);
    }
}

