/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.config.neoforge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.neoforged.neoform.runtime.config.neoforge.BinpatcherConfig;
import net.neoforged.neoform.runtime.utils.FilenameUtil;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;
import org.jetbrains.annotations.Nullable;

public record NeoForgeConfig(int spec, @SerializedName(value="mcp") String neoformArtifact, @SerializedName(value="ats") String accessTransformersFolder, @SerializedName(value="binpatches") String binaryPatchesFile, @SerializedName(value="binpatcher") BinpatcherConfig binaryPatcherConfig, @SerializedName(value="patches") String patchesFolder, @SerializedName(value="sources") String sourcesArtifact, @SerializedName(value="universal") String universalArtifact, @SerializedName(value="patchesOriginalPrefix") @Nullable String basePathPrefix, @SerializedName(value="patchesModifiedPrefix") @Nullable String modifiedPathPrefix, Map<String, JsonObject> runs, List<MavenCoordinate> libraries, List<String> modules, @SerializedName(value="sass") List<String> sideAnnotationStrippers) {
    public static NeoForgeConfig from(ZipFile zipFile) throws IOException {
        byte[] configContent;
        ZipEntry configEntry = zipFile.getEntry("config.json");
        if (configEntry == null || configEntry.isDirectory()) {
            throw new IOException("NeoForge config file config.json not found in " + zipFile.getName());
        }
        try (InputStream in = zipFile.getInputStream(configEntry);){
            configContent = in.readAllBytes();
        }
        Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)MavenCoordinate.class), MavenCoordinate.TYPE_ADAPTER).create();
        JsonObject root = gson.fromJson((Reader)new StringReader(new String(configContent, StandardCharsets.UTF_8)), JsonObject.class);
        int specVersion = root.getAsJsonPrimitive("spec").getAsInt();
        if (specVersion != 2) {
            throw new IOException("Unsupported NeoForge spec version: " + specVersion);
        }
        if (root.get("ats").isJsonArray()) {
            NeoForgeConfig.convertAccessTransformerPropertyFromForgeToNeoForge(root);
        }
        if (!root.has("sass")) {
            root.add("sass", new JsonArray());
        }
        try {
            return gson.fromJson((JsonElement)root, NeoForgeConfig.class);
        }
        catch (JsonSyntaxException e) {
            throw new IOException("Failed to read NeoForge config from " + zipFile.getName(), e);
        }
    }

    private static void convertAccessTransformerPropertyFromForgeToNeoForge(JsonObject root) {
        JsonArray ats = root.get("ats").getAsJsonArray();
        ArrayList<String> atFiles = new ArrayList<String>();
        for (JsonElement at : ats) {
            atFiles.add(at.getAsString());
        }
        String longestPrefix = FilenameUtil.longestCommonDirPrefix(atFiles);
        if (longestPrefix == null) {
            root.remove("ats");
        } else {
            root.addProperty("ats", longestPrefix);
        }
    }
}

