/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.cli;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.neoform.runtime.artifacts.Artifact;
import net.neoforged.neoform.runtime.artifacts.ArtifactManager;
import net.neoforged.neoform.runtime.cache.CacheManager;
import net.neoforged.neoform.runtime.cache.LauncherInstallations;
import net.neoforged.neoform.runtime.cli.LockManager;
import net.neoforged.neoform.runtime.cli.MinecraftCommand;
import net.neoforged.neoform.runtime.downloads.DownloadManager;
import net.neoforged.neoform.runtime.manifests.MinecraftVersionManifest;
import net.neoforged.neoform.runtime.utils.FileUtil;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(name="download-artifacts", description={"Downloads an artifact declared by the Minecraft version (such as the original client, server or mappings)"})
public class DownloadArtifactsCommand
extends MinecraftCommand {
    @CommandLine.Option(names={"--write-artifact"}, arity="*")
    List<String> writeArtifacts = new ArrayList<String>();
    @CommandLine.Option(names={"--write-version-manifest"}, description={"Downloads and writes the version manifest to the given location"})
    @Nullable
    Path writeVersionManifest;

    @Override
    protected int runMinecraftCommand(DownloadManager downloadManager, CacheManager cacheManager, LockManager lockManager, ArtifactManager artifactManager, LauncherInstallations launcherInstallations, String minecraftVersion) throws IOException {
        Map<String, Path> neededArtifacts = this.writeArtifacts.stream().map(encodedResult -> {
            String[] parts = encodedResult.split(":", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Specify an artifact destination in the form: <artifactId>:<destination>");
            }
            return parts;
        }).collect(Collectors.toMap(parts -> parts[0], parts -> Paths.get(parts[1], new String[0])));
        Path versionManifestPath = artifactManager.getVersionManifest(minecraftVersion).path();
        MinecraftVersionManifest versionManifest = MinecraftVersionManifest.from(versionManifestPath);
        for (Map.Entry<String, Path> entry : neededArtifacts.entrySet()) {
            Artifact artifact = artifactManager.downloadFromManifest(versionManifest, entry.getKey());
            FileUtil.safeCopy(artifact.path(), entry.getValue());
        }
        if (this.writeVersionManifest != null) {
            FileUtil.safeCopy(versionManifestPath, this.writeVersionManifest);
        }
        return 0;
    }
}

