/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoform.runtime.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import net.neoforged.neoform.runtime.utils.MavenCoordinate;

public enum ToolCoordinate {
    JAVA_SOURCE_TRANSFORMER,
    DIFF_PATCH,
    MCF_SIDE_ANNOTATION_STRIPPER;

    private static final Properties VERSIONS;
    private MavenCoordinate version;

    public MavenCoordinate version() {
        return Objects.requireNonNull(this.version, "version");
    }

    static {
        try (InputStream in = ToolCoordinate.class.getResourceAsStream("/tools.properties");){
            if (in == null) {
                throw new IllegalStateException("Packaging error: tools.properties is missing.");
            }
            VERSIONS = new Properties();
            VERSIONS.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException("Could ont read tools.properties", e);
        }
        for (ToolCoordinate value : ToolCoordinate.values()) {
            try {
                value.version = MavenCoordinate.parse(VERSIONS.getProperty(value.name()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Tool coordinate for " + String.valueOf((Object)value) + " is invalid.", e);
            }
        }
        for (String property : VERSIONS.stringPropertyNames()) {
            try {
                ToolCoordinate.valueOf(property);
            }
            catch (IllegalArgumentException ignored) {
                throw new IllegalStateException("tools.properties contains invalid key: " + property);
            }
        }
    }
}

